package com.biz.eisp.mdm.custorg.service;

import java.util.List;
import javax.servlet.http.HttpServletRequest;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.custorg.vo.QueryTmCustOrgVo;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgBusinessVo;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgCustomerVo;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgTerminalVo;
import com.biz.eisp.mdm.custorg.vo.TmCustomerOrgVo;
import com.biz.eisp.mdm.dict.entity.TmDictDataEntity;

/**
 * 客户组织关系业务Service.
 * <p>客户组织关系CURD操作。主要涉及表：tm_customer_org。 此Service就是围绕tm_customer_org表开展的业务<br>
 * @author wuzhujun
 * @version v1.0
 */
public interface TmCustOrgService extends BaseService {
	/**
	 * 获取客户组织关系vo对象信息.
	 * @author wuzhujun
	 * @param id 客户组织关系ID
	 * @return 客户组织关系vo
	 */
	public TmCustomerOrgVo getTmCustOrg(String id);
	/**
	 * 上级客户组织关系下拉树.
	 * <p>获取下拉客户组织关系树的接口方法定义
	 * @author wuzhujun
	 * @param custOrgVo 客户组织关系vo对象
	 * @param comboTree 下拉树对象
	 * @return 下拉树模型
	 */
	List<ComboTree> getParentCustOrg(HttpServletRequest request, ComboTree comboTree);
	/**
	 * 上级客户组织关系下拉树.
	 * <p>获取下拉客户组织关系树的接口方法定义
	 * @author wuzhujun
	 * @param custOrgVo 客户组织关系vo对象
	 * @param comboTree 下拉树对象
	 * @return 下拉树模型
	 */
	List<ComboTree> getParentCustOrgs(HttpServletRequest request, ComboTree comboTree);
	/**
	 * 保存客户组织关系.
	 * <p>保存客户组织关系接口的定义
	 * @author wuzhujun
	 * @param custOrgVo 客户组织关系vo对象
	 * @param page 页面对象
	 */
	 String saveOrUpdateCustOrg(TmCustomerOrgVo custOrgVo, Page page);
	/**
	 * 删除客户组织组织.
	 * @author wuzhujun
	 * @param ids 客户组织关系ids
	 * @return 成功或者失败
	 */
	AjaxJson delCustOrg(String ids);
	/**
	 * 查询客户关系关联客户
	 * @author wuzhujun
	 * @param tmCustOrgCustomerVo 客户组织关系_关联客户vo
	 * @return 客户组织关系_关联客户vo集合
	 */
	public List<TmCustOrgCustomerVo> findTmCustomerByCustOrg(TmCustOrgCustomerVo tmCustOrgCustomerVo,Page page);
	/**
	 * 查询客户关系关联终端
	 * @author wuzhujun
	 * @param tmCustOrgTerminalVo 客户组织关系_关联终端vo
	 * @return 客户组织关系_关联终端vo集合
	 */
	public List<TmCustOrgTerminalVo> findTmTerminalByCustOrg(TmCustOrgTerminalVo tmCustOrgTerminalVo,Page page);
	/**
	 * 通过数据字典类型和数据字典编码查询数据字典值名称
	 * @author wuzhujun
	 * @param DictTypeCode 数据字典类型
	 * @param dictCode 数据字典编码
	 * @return 数据字典值对象
	 */
	public TmDictDataEntity findDictDataByCode(String DictTypeCode,String dictCode);
	/**
	 * 方法的简述.
	 * <p>方法的详细说明第一行<br>
	 * 方法的详细说明第二行
	 * @author wuzhujun
	 * @param tmCustOrgBusinessVo
	 * @return
	 */
	public List<TmCustOrgBusinessVo> findNotRefBusinessGrid(TmCustOrgBusinessVo tmCustOrgBusinessVo,Page page);
	/**
	 * 方法的简述.
	 * <p>方法的详细说明第一行<br>
	 * 方法的详细说明第二行
	 * @author wuzhujun
	 * @param tmCustOrgBusinessVo
	 * @return
	 */
	public List<TmCustOrgBusinessVo> findRefBusinessGrid(TmCustOrgBusinessVo tmCustOrgBusinessVo);	
	/**
	 * 移除某个关联业务归属
	 * @author wuzhujun
	 * @param id 职位id
	 * @param custOrgId 客户组织id
	 * @return
	 */
	public AjaxJson removeCustOrgBusiness(String id,String custOrgId);
	/**
	 * 添加某个关联的业务归属
	 * @author wuzhujun
	 * @param id 职位id
	 * @param custOrgId 客户组织id
	 * @return
	 */
	public AjaxJson addCustOrgBusiness(String id,String custOrgId);
	/**
	 * 客户组织相关接口 - 主要对外.
	 * <p>该接口提供了所有可能查询客户组织的方式.<br>
	 * 0、无参数 custOrgName组织名称，custOrgCode组织编码 custOrgType类型 custOrgLevel级别 模糊查询
	 * 1、当前客户组织信息 所需参数：id客户组织id
	 * 2、客户组织的上级信息 所需参数：parentCustOrgId客户组织id
	 * 3、客户组织的下级信息 所需参数：levelCustOrgId客户组织id
	 * 4、某类型客户组织的的所有上级组织信息 所需参数：parentAllCustOrgId客户组织id
	 * 5、某类型客户组织的的所有下级组织信息 所需参数：levelAllCustOrgId客户组织id
	 * 6、某一职位下的客户组织 所需参数：positionId职位id 或者 positionName职位名称
	 * 7、某一下用户下的客户组织 所属参数：所需参数：userId用户id 或者 fullName用户名称
	 * 8、某一下客户下的客户组织 所属参数：所需参数：custId客户id 或者 custName客户名称
	 * 9、其他情况自由组合0-8
	 * @author grover
	 * @param queryTmCustOrgVo 查询方式vo
	 * @param page 分页对象 如果不分页传入一个null
	 * @return 客户组织vo集合
	 */
	List<TmCustomerOrgVo> findTmCustOrgByAllPossible(QueryTmCustOrgVo queryTmCustOrgVo, Page page);
	/**
	 * 查询客户组织列表.
	 * <p>
	 * 如果只有id，没有查询条件，即动态加载该id的子节点。<br>
	 * 如果有查询条件，即进行查询操作。返回所有的值，构造children<br>
	 * @author wuzhujun
	 * @param custOrgVo
	 * @return
	 */
	public List<TmCustomerOrgVo> findTmCustomerOrgList(TmCustomerOrgVo custOrgVo);
	
	public boolean validate(String id, String param, String fieldName);
	
}
