package com.biz.eisp.mdm.custorg.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.importer.ImpEventHandler;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.importer.validator.ValidatorFactory;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.custorg.service.TmCustOrgBackExtendService;
import com.biz.eisp.mdm.custorg.service.TmCustOrgService;
import com.biz.eisp.mdm.custorg.vo.TmCustomerOrgVo;

/**
 * 客户组织信息excel导入 
 * @author grover
 * @version v1.0
 */
public class TmCustOrgEventHandler extends ImpEventHandler <TmCustomerOrgVo>{
	
	private TmCustOrgService tmCustOrgService = null;

	private TmCustOrgBackExtendService tmCustOrgBackExtendService;
	private List<String> saveIdList;

	public TmCustOrgEventHandler() {
		tmCustOrgService =(TmCustOrgService) ApplicationContextUtils
				.getContext().getBean("tmCustOrgService");

		String[] beanNamesForBackExtendService = ApplicationContextUtils.getContext().getBeanNamesForType(TmCustOrgBackExtendService.class);
		if (beanNamesForBackExtendService.length > 0){
			tmCustOrgBackExtendService = ApplicationContextUtils.getContext().getBean(beanNamesForBackExtendService[0],TmCustOrgBackExtendService.class);
		}

		saveIdList = Collections.synchronizedList(new ArrayList<>());

	}
	
	@Override
	public void endRow(Map<String, Object> row, TmCustomerOrgVo bean) throws ValidateException {
		try {
			//执行保存
			Page page = new EuPage();
			String id = tmCustOrgService.saveOrUpdateCustOrg(bean, page);
			saveIdList.add(id);
		} catch (Exception e) {
			addError("第"+getRowNumber()+"行遇到错误:"+e.getMessage());
			e.printStackTrace();
		}
		//设置已成功导入条数
		setSuccNum(getSuccNum()+1);
	}
	
	@Override
	public void end() {
		//刷新叶子节点
		tmCustOrgService.updateIsLeafColumn(Globals.TABLE_CUSTOMER_ORG);
	}

	@Override
	public void validate(Map<String, Object> row) throws ValidateException {
		//导入字段
		 List<TmMdmTableConfigEntity> list=DynamicConfigUtil.
				allTableConfigImpColumn.get(tableName.toUpperCase());
		for(TmMdmTableConfigEntity tableConfig:list){
		    Object fieldValue=row.get(tableConfig.getField());//字段值
		    //验证主数据配置表单验证
			String errorMsg=ValidatorFactory.
					validateDynamicImplData(tableConfig, fieldValue);
			if(StringUtil.isNotEmpty(errorMsg)){
				addError("第"+getRowNumber()+"行:"+errorMsg);
			}
			//手动验证客户组织名称
			if(StringUtil.equals("customerOrgName", tableConfig.getField())){
				String hql="from TmCustomerOrgEntity where enableStatus=0 and  customerOrgName=?";
				//验证重复
				List counts = tmCustOrgService.findByHql(hql, fieldValue);
				if(counts != null&&counts.size()>0){
					addError("第"+getRowNumber()+"行:客户组织名称"+fieldValue+"已存在");
				}
			}
			//手动验证客户组织编码
			if(StringUtil.equals("custOrgCode", tableConfig.getField())){
				String hql="from TmCustomerOrgEntity where enableStatus=0 and  custOrgCode=?";
				//验证重复
				List count1 =  tmCustOrgService.findByHql(hql, fieldValue);
				if(count1 != null&&count1.size()>0){
					addError("第"+getRowNumber()+"行,客户组织编码"+fieldValue+"已存在");
				}
			}
			//手动验证上级客户组织
			if(StringUtil.equals("parentId", tableConfig.getField())){
				String superOrgCodeHql="from TmCustomerOrgEntity where custOrgCode=? and enableStatus=?";
				//是否存在
				TmCustomerOrgEntity custOrgEntity = tmCustOrgService.getUniqueByHql(
						TmCustomerOrgEntity.class, superOrgCodeHql, fieldValue,Globals.ZERO);
				if(StringUtil.isEmpty(custOrgEntity)){
					addError("第"+getRowNumber()+"行,上级客户组织编码在系统中不存在");
				}else{
					row.put(tableConfig.getField(), custOrgEntity.getId());
				}
			}
		}
		
	}

	@Override
	public void impEnd() {
		if (null != tmCustOrgBackExtendService){
			tmCustOrgBackExtendService.afterImportCustOrg(saveIdList);
		}
	}
}
