package com.biz.eisp.mdm.custorg.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TreeGridUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.custorg.dao.TmCustOrgDao;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.custorg.service.TmCustOrgExtendService;
import com.biz.eisp.mdm.custorg.service.TmCustOrgService;
import com.biz.eisp.mdm.custorg.transformer.TmCustomerOrgEntityToTmCustomerOrgVo;
import com.biz.eisp.mdm.custorg.transformer.TmCustomerOrgVoToTmCustomerEntity;
import com.biz.eisp.mdm.custorg.vo.QueryTmCustOrgVo;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgBusinessVo;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgCustomerVo;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgTerminalVo;
import com.biz.eisp.mdm.custorg.vo.TmCustomerOrgVo;
import com.biz.eisp.mdm.dict.entity.TmDictDataEntity;
import com.biz.eisp.mdm.dict.service.TmDictDataService;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.service.TmUserService;

/** 
 * 客户组织关系服务层接口实现
 * @author wuzhujun
 * @version v1.0
 */
@Service("tmCustOrgService")
@Transactional
public class TmCustOrgServiceImpl extends BaseServiceImpl implements TmCustOrgService{
	/**
	 * 注入客户组织关系dao
	 */
	@Autowired
	private TmCustOrgDao tmCustOrgDao;
	/**
	 * 数据字典值服务层
	 */
	@Autowired
	private TmDictDataService tmDictDataService;
	/**
	 * 职位服务层
	 */
	@Autowired
	private TmPositionService tmPositionService;
	/**
	 * 用户服务层
	 */
	@Autowired
	private TmUserService tmUserService;
	/**
	 * 客户组织扩展service
	 */
	@Autowired(required=false)
	private TmCustOrgExtendService tmCustOrgExtendService;
	
	@Override
	public TmCustomerOrgVo getTmCustOrg(String id) {
		TmCustomerOrgEntity entity = this.get(TmCustomerOrgEntity.class, id);
		TmCustomerOrgVo  tmCustOrgVo  =  new TmCustomerOrgEntityToTmCustomerOrgVo(this).apply(entity);
		return tmCustOrgVo;
	}

	@Override
	public List<ComboTree> getParentCustOrg(HttpServletRequest request, ComboTree comboTree) {
		String selfId = request.getParameter("selfId");
		Criterion cr = Restrictions.eq("enableStatus", Globals.ZERO);
		List<TmCustomerOrgEntity> tmCustOrgList = new ArrayList<TmCustomerOrgEntity>();
		
		if(StringUtil.isNotEmpty(selfId)){
			tmCustOrgList = findByProperty(TmCustomerOrgEntity.class,"id",selfId);
		}else if(StringUtil.isNotEmpty(comboTree.getId())){
			
			Criterion cr2 = Restrictions.eq("tmCustOrg.id", comboTree.getId());
			tmCustOrgList = findByCriteria(TmCustomerOrgEntity.class, cr, cr2);
		}else{
			Criterion cr3 = Restrictions.isNull("tmCustOrg.id");
			tmCustOrgList = findByCriteria(TmCustomerOrgEntity.class, cr,cr3);
		}
		ComboTreeModel comboTreeModel = new ComboTreeModel("id", "customerOrgName", "tmCustOrgs");
		List<ComboTree> comboTrees = this.comboTree(tmCustOrgList, comboTreeModel, null, false);
		return comboTrees;
	}
	
	@Override
	public String saveOrUpdateCustOrg(TmCustomerOrgVo custOrgVo, Page page) {
		TmCustomerOrgEntity tmCustOrg = null;
		//保存前扩展 此时entity还未通过vo转换
		if (StringUtil.isNotEmpty(tmCustOrgExtendService)) {
			//保存前验证
			try {
				tmCustOrgExtendService.validate(custOrgVo, page);
			} catch (Exception e) {
				throw new BusinessException("验证数据失败:"+e.getMessage());
			}
			//保存前扩展
			tmCustOrg = tmCustOrgExtendService.saveBefore(custOrgVo, page);
		}
		//如果entity为null 则通过vo转换
		if(StringUtil.isEmpty(tmCustOrg)){
			tmCustOrg =new TmCustomerOrgVoToTmCustomerEntity(this).apply(custOrgVo);
		}
		//保存前扩展 此时entity已经通过vo转换
		if(StringUtil.isNotEmpty(tmCustOrgExtendService)){
			tmCustOrg = tmCustOrgExtendService.saveBefore(tmCustOrg, custOrgVo, page);
		}
		//修改下级客户组织级别
		if(StringUtil.isNotEmpty(tmCustOrg.getId())){
			List<TmCustomerOrgEntity> subCustOrg =
					this.findByProperty(TmCustomerOrgEntity.class, "tmCustOrg.id", tmCustOrg.getId());
			this.updateSubCustOrg(subCustOrg, tmCustOrg);
		}
		this.saveOrUpdate(tmCustOrg);
		//保存后扩展
		if(StringUtil.isNotEmpty(tmCustOrgExtendService)){
			tmCustOrg = tmCustOrgExtendService.savePost(tmCustOrg, custOrgVo, page);
		}

		if (null != tmCustOrg){
			return tmCustOrg.getId();
		}
		return null;
	}
	
	/**
	 * 递归更新组织custOrgLevel
	 * @param subCustOrg 子客户组织列表
	 * @param parent 上级
	 */
	private void updateSubCustOrg(List<TmCustomerOrgEntity> subCustOrg,TmCustomerOrgEntity  parent) {
	   if(subCustOrg.size() ==0){//没有子菜单是结束
              return;
       }else{
    	   for (TmCustomerOrgEntity custOrg : subCustOrg) {
    		   custOrg.setCustOrgLevel(Integer.valueOf(parent.getCustOrgLevel()+1+""));
				this.saveOrUpdate(custOrg);
				List<TmCustomerOrgEntity> subFunction1 = this.findByProperty(TmCustomerOrgEntity.class, "tmCustOrg.id", custOrg.getId());
				updateSubCustOrg(subFunction1,custOrg);
		   }
       }
	}
	@Override
	public AjaxJson delCustOrg(String ids) {
		AjaxJson j = new AjaxJson();
		String[] custOrgIds = ids.split(",");
		for (String id : custOrgIds) {
			TmCustomerOrgEntity orgEntity = get(TmCustomerOrgEntity.class, id);
			if(!StringUtil.isNotEmpty(orgEntity)){
				j.setSuccess(false);
				j.setMsg("删除失败！");
				return j;
			}else{
				//1.判断删除组织是否有子节点
				if(StringUtil.isNotEmpty(orgEntity.getTmCustOrgs())&&orgEntity.getTmCustOrgs().size()>0){
					j.setSuccess(false);
					j.setMsg("删除失败！【"+orgEntity.getCustomerOrgName()+"】下面子节点！");
					return j;
				}
				TmCustOrgTerminalVo tVo = new TmCustOrgTerminalVo();
				TmCustOrgCustomerVo cVo = new TmCustOrgCustomerVo();
				tVo.setCustOrgId(id);
				cVo.setCustOrgId(id);
				int a = tmCustOrgDao.findTmCustomerByCustOrg(cVo).size();
				int b = tmCustOrgDao.findTmTerminalByCustOrg(tVo).size();
				//2.判断删除组织是否有关联客户
				if(a>0){
					j.setSuccess(false);
					j.setMsg("此客户组织关联有客户不能删除！");
					return j;
				//3.判断客户组织是否有关联终端
				}else if(b>0){
					j.setSuccess(false);
					j.setMsg("此客户组织关联有终端不能删除！");
					return j;
				}else{
					orgEntity.setEnableStatus(Globals.ONE);
					updateEntity(orgEntity);
				}
				
			}
		}
		j.setMsg("删除成功!");
		return j;
	}

	@Override
	public List<TmCustOrgCustomerVo> findTmCustomerByCustOrg(TmCustOrgCustomerVo tmCustOrgCustomerVo,Page page) {
		List<TmCustOrgCustomerVo> custorgcustvos = tmCustOrgDao.findTmCustomerByCustOrg(tmCustOrgCustomerVo,page);
		for(TmCustOrgCustomerVo tto:custorgcustvos){
			//1.根据用户ID查询职位ID集合
			String sql = "select position_id from TM_R_CUST_POS_BG t where t.customer_id = ?";
			List<Map<String, Object>> positionList = findForMapList(sql, tto.getId());
			if(!CollectionUtil.listEmpty(positionList)){
				//2.拼接职位名称
				for(int i = 0;i<positionList.size();i++){
					if(StringUtil.isNotEmpty(positionList.get(i).get("position_id"))){
						String positionId = (String) positionList.get(i).get("position_id");
						TmPositionEntity tmPositionEntity = tmPositionService.get(TmPositionEntity.class,positionId);
						tto.setPositionName((StringUtil.isNotEmpty(tto.getPositionName())?(tto.getPositionName()+","):"")+tmPositionEntity.getPositionName());
						String sql2 = "select user_id from TM_R_USER_POSITION t where t.position_id = ?";
						List<Map<String, Object>> userList = findForMapList(sql2, positionId);
						if(!CollectionUtil.listEmpty(userList)){
							//3.拼接用户名称
							for(int j = 0 ;j<userList.size();j++){
								if(StringUtil.isNotEmpty(userList.get(j).get("user_id"))){
									String userID = (String) userList.get(j).get("user_id");
									TmUserEntity tmUserEntity =  tmUserService.get(TmUserEntity.class,userID);
									tto.setUsername((StringUtil.isNotEmpty(tto.getUsername())?(tto.getUsername()+","):"")+tmUserEntity.getFullName());
								}
							}
						}
					}
				}
			}
		}
		return custorgcustvos;
	}
	
	@Override
	public TmDictDataEntity findDictDataByCode(String dictCode, String dictTypeCode) {
		
		return tmDictDataService.findByCode(dictCode, dictTypeCode);
	}
	
	@Override
	public List<TmCustOrgTerminalVo> findTmTerminalByCustOrg(TmCustOrgTerminalVo tmCustOrgTerminalVo,Page page) {
		return tmCustOrgDao.findTmTerminalByCustOrg(tmCustOrgTerminalVo,page);
	}

	

	@Override
	public List<TmCustOrgBusinessVo> findNotRefBusinessGrid(TmCustOrgBusinessVo tmCustOrgBusinessVo ,Page page) {
		return tmCustOrgDao.findNotRefBusinessGrid(tmCustOrgBusinessVo, page);
	}

	@Override
	public List<TmCustOrgBusinessVo> findRefBusinessGrid(TmCustOrgBusinessVo tmCustOrgBusinessVo) {
		return tmCustOrgDao.findRefBusinessGrid(tmCustOrgBusinessVo);
	}

	@Override
	public List<ComboTree> getParentCustOrgs(HttpServletRequest request, ComboTree comboTree) {
		Criterion cr = Restrictions.eq("enableStatus", Globals.ZERO);
		List<TmCustomerOrgEntity> tmCustOrgList = new ArrayList<TmCustomerOrgEntity>();

		Criterion cr1 = null;
		String selfId = request.getParameter("selfId");

		if(StringUtil.isNotEmpty(selfId)){
			tmCustOrgList = findByProperty(TmCustomerOrgEntity.class,"id",selfId);
		}else if(StringUtil.isNotEmpty(comboTree.getId())){
			Criterion cr2 = Restrictions.eq("tmCustOrg.id", comboTree.getId());
			tmCustOrgList = findByCriteria(TmCustomerOrgEntity.class, cr, cr2);
		}else{
			Criterion cr3 = Restrictions.isNull("tmCustOrg.id");
			tmCustOrgList = findByCriteria(TmCustomerOrgEntity.class, cr,cr3);
		}

		if(StringUtil.isNotEmpty(selfId)){
			ComboTreeModel comboTreeModel = new ComboTreeModel("id", "customerOrgName", "tmCustOrgs");
			List<ComboTree> comboTrees = this.comboTree(tmCustOrgList, comboTreeModel, null, false);
			return comboTrees;
		}else{
			ComboTreeModel comboTreeModel = new ComboTreeModel("id", "customerOrgName", "tmCustOrgs");
			List<ComboTree> comboTrees = this.comboTree(tmCustOrgList, comboTreeModel, null, false);
			return comboTrees;
		}
	}

	@Override
	public AjaxJson removeCustOrgBusiness(String id, String custOrgId) {
		AjaxJson j = new AjaxJson();
		if(StringUtil.isNotEmpty(id)&&StringUtil.isNotEmpty(custOrgId)){
			TmCustomerOrgEntity tmCustomerOrgEntity = null;
			tmCustomerOrgEntity = get(TmCustomerOrgEntity.class, custOrgId);
			if(StringUtil.isNotEmpty(tmCustomerOrgEntity)){
				tmCustomerOrgEntity.setPositionId(null);
				saveOrUpdate(tmCustomerOrgEntity);
			}else{
				j.setMsg("移除失败");
				j.setSuccess(false);
			}
		}else{
			j.setMsg("移除失败");
			j.setSuccess(false);
		}
		return j;
	}

	@Override
	public AjaxJson addCustOrgBusiness(String id, String custOrgId) {
		AjaxJson j = new AjaxJson();
		if(StringUtil.isNotEmpty(id)&&StringUtil.isNotEmpty(custOrgId)){
			TmCustomerOrgEntity tmCustomerOrgEntity = null;
			tmCustomerOrgEntity = get(TmCustomerOrgEntity.class, custOrgId);
			if(StringUtil.isNotEmpty(tmCustomerOrgEntity)){
				tmCustomerOrgEntity.setPositionId(id);
				saveOrUpdate(tmCustomerOrgEntity);
			}else{
				j.setMsg("添加失败");
				j.setSuccess(false);
			}
		}else{
			j.setMsg("添加失败");
			j.setSuccess(false);
		}
		return j;
	}
	@Override
	public List<TmCustomerOrgVo> findTmCustOrgByAllPossible(
			QueryTmCustOrgVo queryTmCustOrgVo, Page page) {
		return tmCustOrgDao.findTmCustOrgByAllPossible(queryTmCustOrgVo, page);
	}

	@Override
	public List<TmCustomerOrgVo> findTmCustomerOrgList(TmCustomerOrgVo custOrgVo) {
		//获取动态sql
		String sql = DynamicConfigUtil.getInstance().buildTreeGridQuerySql(Globals.TABLE_CUSTOMER_ORG, custOrgVo);
		sql+=" order by to_number(regexp_substr(trim(t.cust_org_code),'[0-9]*[0-9]',1)) asc,length(t.cust_org_code) asc";
		List <TmCustomerOrgVo> voList = findBySql(TmCustomerOrgVo.class, sql); 
		//如果带查询条件 则组装树形
		if(DynamicConfigUtil.getInstance().isHaveQuery(Globals.TABLE_CUSTOMER_ORG, custOrgVo)) {
			voList = this.findQueryCustomerOrgList(custOrgVo, voList);
		}
		return voList;
	}
	
	@SuppressWarnings("unchecked")
	private List<TmCustomerOrgVo> findQueryCustomerOrgList(TmCustomerOrgVo custOrgVo, List <TmCustomerOrgVo> voList) {
		//List <TmCustomerOrgVo> voList = tmCustOrgDao.findQueryCustomerOrgList(custOrgVo, fields, conditions);
		//如果是导出，既不用组装成TreeGrid,带有children的树形，直接返回列表值
		if(custOrgVo.getExportExcel().equals("true")) {
			return voList;
		}
		
		//构造成一个树传回
		List<TmCustomerOrgVo> allQueryVolist = TreeGridUtil.buildTreeGrid(voList);
		return allQueryVolist; 
	}

	/**
	 * 是否存在条件查询值.
	 * <p>
	 * @author wuzhujun
	 * @param custOrgVo
	 * @return 有条件查询返回true，没有false
	 */
	private boolean hasQueryValue(TmCustomerOrgVo custOrgVo) {
		if(StringUtils.isBlank(custOrgVo.getCustOrgCode())
				&&StringUtils.isBlank(custOrgVo.getCustomerOrgName())
				&&StringUtils.isBlank(custOrgVo.getCustOrgType())
				&&StringUtils.isBlank(custOrgVo.getCustOrgDesc())
				&&StringUtils.isBlank(custOrgVo.getCustOrgType())
				&&StringUtils.isBlank(custOrgVo.getExtChar1())
				&&StringUtils.isBlank(custOrgVo.getExtChar2())
				&&StringUtils.isBlank(custOrgVo.getExtChar3())
				&&StringUtils.isBlank(custOrgVo.getExtChar4())
				&&StringUtils.isBlank(custOrgVo.getExtChar5())
				&&custOrgVo.getExtNumber1() == null
				&&custOrgVo.getExtNumber2() == null
				&&custOrgVo.getExtNumber3() == null
				){
			return false;
		}
		return true;
	}

	@Override
	public boolean validate(String id, String param, String fieldName) {
		Criterion cr1 = Restrictions.eq(fieldName, param);
		List<TmCustomerOrgEntity> tmtbas = new ArrayList<TmCustomerOrgEntity>();
		if(StringUtil.isNotEmpty(id)){
			Criterion cr2 = Restrictions.ne("id", id);
			tmtbas = findByCriteria(TmCustomerOrgEntity.class, cr1, cr2);
		}else{
			tmtbas = findByCriteria(TmCustomerOrgEntity.class, cr1);
		}
		if(!CollectionUtils.isEmpty(tmtbas)){
			return true;
		}
		return false;
	}
}
