package com.biz.eisp.mdm.custorg.transformer;

import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.custorg.service.TmCustOrgService;
import com.biz.eisp.mdm.custorg.vo.TmCustomerOrgVo;
import com.google.common.base.Function;

/**
 * 客户组织关系实体转vo
 * @author wuzhujun
 * @version v1.0
 */
public class TmCustomerOrgEntityToTmCustomerOrgVo implements Function< TmCustomerOrgEntity,TmCustomerOrgVo> {
	
	
	public TmCustomerOrgEntityToTmCustomerOrgVo(TmCustOrgService tmCustOrgService){
		super();
		this.tmCustOrgService = tmCustOrgService;
	}
	
	private TmCustOrgService tmCustOrgService;
	
	@Override
	public TmCustomerOrgVo apply(TmCustomerOrgEntity entity) {
		TmCustomerOrgVo tmCustOrgVo = new TmCustomerOrgVo();
		try {
			entity = tmCustOrgService.get(TmCustomerOrgEntity.class, entity.getId());
			MyBeanUtils.copyBeanNotNull2Bean( entity,tmCustOrgVo);
			if(StringUtil.isNotEmpty(entity.getTmCustOrg())){
				tmCustOrgVo.setParentId(entity.getTmCustOrg().getId());
				tmCustOrgVo.setParentName(entity.getTmCustOrg().getCustomerOrgName());
				tmCustOrgVo.setParentLevel(entity.getTmCustOrg().getCustOrgLevel());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return tmCustOrgVo;
	}
	
}
