package com.biz.eisp.mdm.custorg.transformer;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.utils.PinyinUtil;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.custorg.service.TmCustOrgService;
import com.biz.eisp.mdm.custorg.vo.TmCustomerOrgVo;
import com.google.common.base.Function;

import jodd.util.StringUtil;

/** 
 * 客户组织关系vo转Po
 * @author wuzhujun
 * @version v1.0
 */
public class TmCustomerOrgVoToTmCustomerEntity implements Function<TmCustomerOrgVo, TmCustomerOrgEntity>{

	
	public TmCustomerOrgVoToTmCustomerEntity(TmCustOrgService tmCustOrgService){
		super();
		this.tmCustOrgService = tmCustOrgService;
	}
	
	private TmCustOrgService tmCustOrgService;
	
	@Override
	public TmCustomerOrgEntity apply(TmCustomerOrgVo vo) {
		TmCustomerOrgEntity tmCustOrgEntity = null;
		//判断是新增还是修改
		if(StringUtil.isNotEmpty(vo.getId())){
			tmCustOrgEntity = tmCustOrgService.get(TmCustomerOrgEntity.class,vo.getId());
		}else{
			tmCustOrgEntity = new TmCustomerOrgEntity();
		}
		//拼音简写
		vo.setHeadString(PinyinUtil.getPinYinHeadChar(vo.getCustomerOrgName()));
		if(vo.getEnableStatus() == null){
			vo.setEnableStatus(Globals.ZERO);
		}
		try {
			//拷贝
//			MyBeanUtils.copyBeanNotNull2Bean(vo, tmCustOrgEntity);
			copyProperties(vo, tmCustOrgEntity);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		//装载上级客户组织关系实体
		if(StringUtil.isNotBlank(vo.getParentId())){
			TmCustomerOrgEntity custOrgEntity = tmCustOrgService.get(TmCustomerOrgEntity.class,vo.getParentId());
			if(custOrgEntity == null){
				throw new BusinessException("转换客户组织关系Vo到Po时，上级组织找不到:" +vo.getParentId());
			}
			tmCustOrgEntity.setTmCustOrg(custOrgEntity);
			Integer baseLevel=custOrgEntity.getCustOrgLevel()==null?0:
					custOrgEntity.getCustOrgLevel();
			tmCustOrgEntity.setCustOrgLevel(baseLevel+1);
		}
		
		//导入时装载上级客户组织关系实体
		if(StringUtil.isNotBlank(vo.getParentName())){
			TmCustomerOrgEntity custOrgEntity = tmCustOrgService
					.findUniqueByProperty(TmCustomerOrgEntity.class,"custOrgCode",vo.getParentName());
			if(custOrgEntity == null){
				//TODO 登康专用
//				throw new BusinessException("转换客户组织关系Vo到Po时，上级组织找不到:" +vo.getParentName());
			}
			tmCustOrgEntity.setTmCustOrg(custOrgEntity);
			Integer baseLevel=custOrgEntity.getCustOrgLevel()==null?0:
					custOrgEntity.getCustOrgLevel();
			tmCustOrgEntity.setCustOrgLevel(baseLevel+1);
		}
		
		//名称非空与重复验证
		if(StringUtil.isNotEmpty(vo.getCustomerOrgName())){
			if(tmCustOrgService.validate(vo.getId(), vo.getCustomerOrgName() , "customerOrgName")){
				throw new BusinessException("转换行政区域关系Vo到Po时，客户组织名称"+ vo.getCustomerOrgName()+"已存在" );
			}
		}else{
			throw new BusinessException("客户组织名称不能为空" );
		}
		
		
		//编码非空与重复验证
		if(StringUtil.isNotEmpty(vo.getCustOrgCode())){
			if(tmCustOrgService.validate(vo.getId(), vo.getCustOrgCode() , "custOrgCode")){
				throw new BusinessException("转换行政区域关系Vo到Po时，客户组织编码"+ vo.getCustOrgCode()+"已存在" );
			}
		}else{
			throw new BusinessException("客户组织编码不能为空" );
		}
		if(tmCustOrgEntity.getCustOrgLevel()==null){
			tmCustOrgEntity.setCustOrgLevel(0);
		}
		return tmCustOrgEntity;
	}
	
	public void copyProperties(TmCustomerOrgVo vo, TmCustomerOrgEntity entity) {
		entity.setCustomerOrgName(vo.getCustomerOrgName());
		entity.setCustOrgCode(vo.getCustOrgCode());
		entity.setCustOrgDesc(vo.getCustOrgDesc());
		entity.setCustOrgType(vo.getCustOrgType());
		entity.setEnableStatus(vo.getEnableStatus());
		entity.setExtChar1(vo.getExtChar1());
		entity.setExtChar2(vo.getExtChar2());
		entity.setExtChar3(vo.getExtChar3());
		entity.setExtChar4(vo.getExtChar4());
		entity.setExtChar5(vo.getExtChar5());
		entity.setExtNumber1(vo.getExtNumber1());
		entity.setExtNumber2(vo.getExtNumber2());
		entity.setExtNumber3(vo.getExtNumber3());
		entity.setHeadString(vo.getHeadString());
//		entity.setPositionId(vo.get);
	}
}
