package com.biz.eisp.mdm.custuser.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.biz.eisp.mdm.custuser.service.TmCustUserBackExtendService;
import com.biz.eisp.mdm.custuser.service.TmCustUserMainExtendService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.custuser.service.TmCustUserFormExtendService;
import com.biz.eisp.mdm.custuser.service.TmCustUserService;
import com.biz.eisp.mdm.user.vo.TmCustUserVo;
import com.biz.eisp.mdm.user.vo.TmUserVo;

/** 
 * <p>客户用户关系CURD操作的Controller层<br>
 * 处理客户用户关系Controller
 * @author grover
 * @version v1.0
 */
@Controller
@RequestMapping("/tmCustUserController")
public class TmCustUserController  extends BaseController{
	/**
	 * 注入Service
	 */
	@Autowired
	private TmCustUserService tmCustUserService;
	/**
	 * 注入客户用户表单界面扩展接口
	 */
	@Autowired(required=false)
	private TmCustUserFormExtendService tmCustUserFormExtendService;

	/**
	 * 注入客户用户主页面扩展接口
	 */
	@Autowired(required=false)
	private TmCustUserMainExtendService tmCustUserMainExtendService;

	@Autowired(required = false)
	private TmCustUserBackExtendService tmCustUserBackExtendService;

	
	/**
	 * 跳转客户用户.
	 * @return 客户用户管理页面路径
	 */
	@RequestMapping(value = "goTmCustUserMain",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goTmCustUserMain(HttpServletRequest request) {
		request.setAttribute("extendTableName",Globals.TABLE_USER);
		if(tmCustUserMainExtendService!=null){
			request.setAttribute("includeJsp", tmCustUserMainExtendService.includeJsp());
		}
		return new ModelAndView("com/biz/eisp/mdm/tmCustUser/tmCustUserMain");
	}
	
	/**
	 * <p>跳转到用户表单页面<br>
	 * 新增，查询，修改 都共同使用此表单页面
	 * @return 用户表单页面路径
	 */
	@RequestMapping(value = "goTmCustUserForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmCustUserForm(TmUserVo tmUserVo, HttpServletRequest request, HttpServletResponse response) {
		if(StringUtil.isNotEmpty(tmUserVo.getId())){
			tmUserVo.setUserType(Globals.CUST_USER);
			TmCustUserVo userVo = tmCustUserService.findTmCustUserById(tmUserVo);
			if(StringUtil.isNotEmpty(userVo)){
				userVo.setPassword(Globals.NO_PASSWORD);
				request.setAttribute("vo", userVo);
			}
		}
		String optype=request.getParameter("optype");
		request.setAttribute("optype", optype);
		request.setAttribute("extendTableName",Globals.TABLE_USER);
		if(tmCustUserFormExtendService != null) {
			request.setAttribute("includeJsp", tmCustUserFormExtendService.includeJsp());
		}
		return new ModelAndView("com/biz/eisp/mdm/tmCustUser/tmCustUserForm");
	}
	
	/**
	 * 查询客户用户.
	 * @author grover
	 * @param tmUserVo 用户vo
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@RequestMapping(value = "findTmCustUserList", method = {RequestMethod.GET, RequestMethod.POST})
	public void findTmCustUserList(TmUserVo tmUserVo, HttpServletRequest request, HttpServletResponse response) {
		Page page = new EuPage(request);
		List <TmCustUserVo> tmUserVoList = tmCustUserService.findTmCustUserList(tmUserVo, page);
		this.datagridReturn(response, tmUserVoList, page);
	}
	
	/**
	 * 保存用户.
	 * @author grover
	 * @param tmUserVo 用户对象
	 * @param request 请求对象
	 * @return 成功或者失败
	 */
	@RequestMapping(value = "saveTmUser", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveTmUser(TmUserVo tmUserVo, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		try {
			Page page = new EuPage(request);
			tmUserVo.setUserType(Globals.CUST_USER);
			String id = tmCustUserService.saveTmUser(tmUserVo, page);
			if (null != tmCustUserBackExtendService){
				tmCustUserBackExtendService.afterSaveTmCustUser(id);
			}
		} catch (Exception e) {
			j.setSuccess(false);
			j.setMsg("操作失败");
			e.printStackTrace();
		}
		
		return j;
	}
	
	/**
	 * 启用停用.
	 * @author grover
	 * @param tmUserVo 用户vo
	 * @return 成功或者失败模型
	 */
	@RequestMapping(value = "startOrStopTmuser", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson startOrStopTmuser(TmUserVo tmUserVo) {
		AjaxJson json = new AjaxJson();
		try {
			json = tmCustUserService.startOrStopTmuser(tmUserVo);
			if (null != tmCustUserBackExtendService){
				tmCustUserBackExtendService.afterStartOrStopTmCustUser(tmUserVo);
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new BusinessException("操作失败，请稍后再试");
		}
		return json;
	}
	/**
	 * 跳转修改密码.
	 * @param request 请求对象
	 * @return 修改密码页面
	 */
	@RequestMapping(value = "goChangeTmUserPassword",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goChangeTmUserPassword(HttpServletRequest request) {
		return new ModelAndView("com/biz/eisp/mdm/tmUser/changeTmPassword");
	}

	/**
	 * <p>跳转到日志管理主页面<br>
	 * @author wuzhujun
	 * @return 日志管理主界面
	 */
	@RequestMapping(value = "goTmLogDetailMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmLogDetailMain( HttpServletRequest request) {
		String businessId=request.getParameter("id");
		request.setAttribute("actionUrl", "tmCustUserController.do?findTmLogList&businessId="+businessId);
		return new ModelAndView("com/biz/eisp/log/tmLogDetailMain");
	}
	
	/**
	 * 分页获取日志列表信息
	 * @author wuzhujun
	 * @param tmLogEntity 日志实体模型
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@RequestMapping(value = "findTmLogList",method = {RequestMethod.GET,RequestMethod.POST})
	public void findTmLogList(TmLogVo tmLogVo, HttpServletRequest request, HttpServletResponse response) {
		Page page = new EuPage(request);
		List <TmLogVo> tmLogList = tmCustUserService.findCustUserLogList(tmLogVo, page);
		this.datagridReturn(response, tmLogList, page);
	}
	
	/**
	 * 导出excel
	 * @param customerVo
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "exportXls", method = {RequestMethod.GET, RequestMethod.POST})
	public void exportXls( TmUserVo tmUserVo, HttpServletRequest request, HttpServletResponse response) {
		List <TmCustUserVo> tmUserVoList = tmCustUserService.findTmCustUserList(tmUserVo,null);
		doExportXls(response, request, tmUserVoList, TmCustUserVo.class, "经销商用户列表");
	}
}
