package com.biz.eisp.mdm.custuser.dao;

import java.util.List;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.user.vo.TmCustUserVo;
import com.biz.eisp.mdm.user.vo.TmUserVo;

/** 客户组织关系Dao接口.
 * @author grover
 * @version v1.0
 */
@InterfaceDao
public interface TmCustUserDao {
	/**
	 * 查询客户用户列表 
	 * @param tmUserVo
	 * @param page
	 * @return
	 */
	@Arguments({"tmUserVo","page"})
	@ResultType(TmCustUserVo.class)
	public List <TmCustUserVo> findTmCustUserList(TmUserVo tmUserVo, Page page);


	/**
	 * 查询客户用户列表
	 * @param tmUserVo
	 * @param page
	 * @return
	 */
	@Arguments({"tmUserVo","sql","page"})
	@ResultType(TmCustUserVo.class)
	public List <TmCustUserVo> findTmCustUserList(TmUserVo tmUserVo,String sql, Page page);
	
	
	/**
	 * 查看客户用户日志
	 * @param tmLogVo
	 * @param page
	 * @return
	 */
	@Arguments({"tmLogVo","page"})
	@ResultType(TmLogVo.class)
	public List<TmLogVo> findCustUserLogList(TmLogVo tmLogVo, Page page);
}
