package com.biz.eisp.mdm.custuser.entity;

import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.log.curd.Loggerable;
import com.biz.eisp.log.curd.ModifyObject;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
/**
 * 用户客户关系.
 * <p>关联数据库表：tm_r_user_customer<br>
 * @author grover
 * @version v1.0
 */
@Entity
@Table(name = "tm_r_user_customer")
public class TmRUserCustomerEntity extends IdEntity implements java.io.Serializable,Loggerable{
	private static final long serialVersionUID = 1L;
	
	/**
	 * 开始时间
	 */
	private Date startDate;
	/**
	 * 结束时间
	 */
	private Date endDate;
	/**
	 * 创建时间
	 */
	private Date createDate;
	/**
	 * 创建人
	 */
	private String createName;
	/**
	 * 修改时间
	 */
	private Date updateDate;
	/**
	 * 修改人
	 */
	private String updateName;
	/**
	 * 状态
	 */
	private Integer status;
	/**
	 * 用户
	 */
	private TmUserEntity tmUser;
	/**
	 * 客户
	 */
	private TmCustomerEntity tmCustomer;
	
	
	/**
	 * 方法:取得java.util.Date
	 * @return java.util.Date 开始时间
	 */
	@Column(name="start_date")
	public Date getStartDate() {
		return startDate;
	}
	
	/**
	 * 方法：设置java.util.Date
	 * @param java.util.Date 开始时间
	 */
	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}
	
	/**
	 * 方法:取得java.util.Date
	 * @return java.util.Date 结束时间
	 */
	@Column(name="end_date")
	public Date getEndDate() {
		return endDate;
	}
	
	/**
	 * 方法：设置java.util.Date
	 * @param java.util.Date 结束时间
	 */
	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}
	/**
	 * 方法:取得java.util.Date
	 * @return java.util.Date 创建时间
	 */
	@Column(name="create_date")
	public Date getCreateDate() {
		return createDate;
	}
	/**
	 * 方法：设置java.util.Date
	 * @param java.util.Date 创建时间
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	/**
	 * 方法：取得java.lang.String
	 * @return java.lang.String 创建人
	 */
	@Column(name="create_name")
	public String getCreateName() {
		return createName;
	}
	
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 创建人
	 */
	public void setCreateName(String createName) {
		this.createName = createName;
	}
	
	/**
	 * 方法:取得java.util.Date
	 * @return java.util.Date 更新时间
	 */
	@Column(name="update_date")
	public Date getUpdateDate() {
		return updateDate;
	}
	/**
	 * 方法:设置java.util.Date
	 * @param java.util.Date 跟新时间
	 */
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 更新人
	 */
	@Column(name="update_name")
	public String getUpdateName() {
		return updateName;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 更新人
	 */
	public void setUpdateName(String updateName) {
		this.updateName = updateName;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * @return java.lang.Integer 状态
	 */
	@Column(name="status")
	public Integer getStatus() {
		return status;
	}
	/**
	 * 方法:设置java.lang.Integer
	 * @param java.lang.Integer 状态
	 */
	public void setStatus(Integer status) {
		this.status = status;
	}
	/**
	 * 方法:取得com.biz.eisp.mdm.user.entity.TmUserEntity
	 * @return com.biz.eisp.mdm.user.entity.TmUserEntity 用户
	 */
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="user_id",insertable=true,updatable=true)
	public TmUserEntity getTmUser() {
		return tmUser;
	}
	/**
	 * 方法:设置com.biz.eisp.mdm.user.entity.TmUserEntity
	 * @param com.biz.eisp.mdm.user.entity.TmUserEntity 用户
	 */
	public void setTmUser(TmUserEntity tmUser) {
		this.tmUser = tmUser;
	}
	/**
	 * 方法:取得com.biz.eisp.mdm.customer.entity.TmCustomerEntity
	 * @return com.biz.eisp.mdm.customer.entity.TmCustomerEntity 客户
	 */
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="customer_id",insertable=true,updatable=true)
	public TmCustomerEntity getTmCustomer() {
		return tmCustomer;
	}
	/**
	 * 方法:设置com.biz.eisp.mdm.customer.entity.TmCustomerEntity
	 * @param com.biz.eisp.mdm.customer.entity.TmCustomerEntity 客户
	 */
	public void setTmCustomer(TmCustomerEntity tmCustomer) {
		this.tmCustomer = tmCustomer;
	}

	@Override
	public String businessDesc() {
		return "客户用户与客户关系";
	}

	@Override
	public String addLogContent() {
		String content="";
		if(tmCustomer!=null){
			content="客户用户["+tmUser.getUserName()+"-"+tmUser.getFullName()+"]关联客户["
					+tmCustomer.getCustomerCode()+"-"+tmCustomer.getCustomerName()+"]</br>";
		}
		return content;
	}

	@Override
	public String updateLogContent(List<ModifyObject> modifyFieldList) {
		String content="";
		String custCode=tmCustomer!=null?tmCustomer.getCustomerCode():"空";
		String custName=tmCustomer!=null?tmCustomer.getCustomerName():"";
		if(tmUser==null){
			content="取消关联客户["+custCode+"-"+custName+"]</br>";
		}
		return content;
	}
}
