package com.biz.eisp.mdm.custuser.service;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.vo.TmUserVo;

/** 
 * 客户用户扩展接口.
 * <p>
 * 客户用户保存或者编辑时的扩展,如需扩展需实现该接口
 * @author grover
 * @version v1.0
 */
public interface TmCustUserExtendService extends BaseService{
	/**
	 * 验证保存数据.
	 * @author 
	 * 			 grover
	 * @param vo
	 *			 vo对象值
	 * @param page 
	 * 			 页面对象
	 * @return 验证失败throw new BusinessException("失败内容")
	 */
	 void validate(TmUserVo vo, Page page);

	/**
	 * 保存客户用户信息前操作(并且没有做vo到Entity的转换操作).
	 * <p>
	 * 返回null即保存前不做任何操作。 返回Entity后，系统即保存返回的Entity。不再做vo转换到Entity的操作。
	 * @author 
	 * 			grover
	 * @param vo
	 *			vo对象值
	 * @param page
	 *          页面对象
	 * @return 返回null即保存前不做任何操作。 返回Entity后，系统即保存返回的Entity。不再做vo转换到Entity的操作。
	 */
	 TmUserEntity saveBefore(TmUserVo vo, Page page);

	/**
	 * 保存客户用户信息前操作（已经做了vo到Entity的转换操作）.
	 * @author 
	 * 			grover
	 * @param entity
	 *          vo转换成Entity的值，该Entity，如果是新增操作即为游离态，修改操作即为持久态
	 * @param vo
	 *          vo对象值
	 * @param page
	 *            页面对象
	 * @return 返回Entity后，系统即保存返回的Entity。
	 */
	 TmUserEntity saveBefore(TmUserEntity entity, TmUserVo vo, Page page);

	/**
	 * 保存客户用户后操作.
	 * <p>
	 * @author grover
	 * @param entity
	 *            保存后的Entity对象，该Entity状态为持久态
	 * @param vo
	 *            vo对象值
	 * @param page
	 *            页面对象
	 * @return 返回Entity后，后面的其他操作，都会使用该Entity
	 */
	 TmUserEntity savePost(TmUserEntity entity, TmUserVo vo, Page page);
}
