package com.biz.eisp.mdm.custuser.service;

import java.util.List;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.user.vo.TmCustUserVo;
import com.biz.eisp.mdm.user.vo.TmUserVo;

/** 
 * 客户用户相关接口.
 * @author grover
 * @version v1.0
 */
public interface TmCustUserService extends BaseService{
	/**
	 * 查询客户用户.
	 * @author grover
	 * @param tmUserVo 用户对象
	 * @param page 分页对象
	 * @return 用户vo集合
	 */
	List<TmCustUserVo> findTmCustUserList(TmUserVo tmUserVo, Page page);
	/**
	 * 根据用户主键查询客户用户.
	 * @author grover
	 * @param tmUserVo 用户对象
	 * @return 用户vo集合
	 */
	TmCustUserVo findTmCustUserById(TmUserVo tmUserVo);
	
	/**
	 *  保存客户用户.
	 * @author grover
	 * @param tmUserVo 用户vo对象
	 * @param page 页面对象
	 */
	public String saveTmUser(TmUserVo tmUserVo, Page page);
	
	/**
	 * 启用停用.
	 * @author grover
	 * @param tmUserVo 用户vo对象
	 * @return 失败或者成功
	 */
	AjaxJson startOrStopTmuser(TmUserVo tmUserVo);
	
	/**
	 * 查看客户用户日志
	 * @param tmLogVo
	 * @param page
	 * @return
	 */
	public List<TmLogVo> findCustUserLogList(TmLogVo tmLogVo, Page page);
}
