package com.biz.eisp.mdm.custuser.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.importer.ImpEventHandler;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.importer.validator.ValidatorFactory;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.custuser.entity.TmRUserCustomerEntity;
import com.biz.eisp.mdm.custuser.service.TmCustUserBackExtendService;
import com.biz.eisp.mdm.custuser.service.TmCustUserService;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.biz.eisp.mdm.user.vo.TmUserVo;

/**  用户导入.
 * @author grover
 * @version v1.0
 */
public class TmCustUserEventHandler extends ImpEventHandler <TmUserVo>{
	/**
	 * service注入.
	 */
	private TmCustUserService tmUserService;


	private TmCustUserBackExtendService tmCustUserBackExtendService;

	private List<String> saveIdList;

	public TmCustUserEventHandler(){
		tmUserService = (TmCustUserService) ApplicationContextUtils.getContext().getBean("tmCustUserService");


		String[] beanNamesForBackExtendService = ApplicationContextUtils.getContext().getBeanNamesForType(TmCustUserBackExtendService.class);
		if (beanNamesForBackExtendService.length > 0){
			tmCustUserBackExtendService = ApplicationContextUtils.getContext().getBean(beanNamesForBackExtendService[0],TmCustUserBackExtendService.class);
		}

		saveIdList = Collections.synchronizedList(new ArrayList<>());
	}
	
	@Override
	public void endRow(Map<String, Object> row, TmUserVo bean) throws ValidateException {
		bean.setPassword("123456");
		bean.setUserType(Globals.CUST_USER);
		try {
			Page page = new EuPage();
			String id = tmUserService.saveTmUser(bean, page);
			saveIdList.add(id);
		} catch (Exception e) {
			addError("第"+getRowNumber()+"行遇到错误:"+e.getMessage());
			e.printStackTrace();
		}
		setSuccNum(getSuccNum()+1);
	}
	
	@Override
	public void validate(Map<String, Object> row) throws ValidateException {
		
		//导入字段
		 List<TmMdmTableConfigEntity> cfList=DynamicConfigUtil.
				allTableConfigImpColumn.get(tableName.toUpperCase());
		for(TmMdmTableConfigEntity tableConfig:cfList){
			Object fieldValue=row.get(tableConfig.getField());//字段值
		    //验证主数据配置表单验证
			String errorMsg=ValidatorFactory.validateDynamicImplData(
					tableConfig, fieldValue);
			if(StringUtil.isNotEmpty(errorMsg)){
				addError("第"+getRowNumber()+"行:"+errorMsg);
			}
			//手动验证登录名
			if(StringUtil.equals("userName", tableConfig.getField())){
				//验证重复
				String hql=" from TmUserEntity where userType=0 and userName=?";
				List result = tmUserService.findByHql(hql,fieldValue);
				if(result != null&&result.size()>0){
					addError("第" + getRowNumber() + "行,登录账号" + fieldValue + "已存在或出现重复");
				}
			}
		}
	    //手动验证客户编码
		Object customerCode = row.get("custId");
		if (StringUtil.isNotEmpty(customerCode)) {
			// 验证是否存在
			TmCustomerEntity entity = tmUserService.findUniqueByProperty(
					TmCustomerEntity.class, "customerCode", customerCode);
			
			if (entity == null || StringUtil.isEmpty(entity.getId())) {
				addError("第" + getRowNumber() + "行,客户编码" + customerCode
						+ "在系统中不存在");
			} else {
				
				if(entity.getEnableStatus()==1){
					addError("客户信息["+customerCode+"]已停用" );
				}
				
				List lists = tmUserService.findByProperty(TmRUserCustomerEntity.class, 
						"tmCustomer.id", entity.getId());
				if (lists!=null&&lists.size() > 0) {
					addError("第" + getRowNumber() + "行,客户" + customerCode
							+ "已绑定用户");
				} else {
					row.put("custId", entity.getId());
				}
			}
		}
		// 手动验证角色编码
		Object roleCode = row.get("roleIds");
		if (StringUtil.isNotEmpty(roleCode)) {
			String[] roles = roleCode.toString().split(",");
			String roleIds = "";
			List<String> list = new ArrayList<String>();
			for (String role : roles) {
				// 验证是否被用
				TmRoleEntity entity = tmUserService.findUniqueByProperty(
						TmRoleEntity.class, "roleCode", role);
				if (entity == null) {
					addError("第" + getRowNumber() + "行,角色编码" + role + "在系统中不存在");
				}
				if (list.contains(role)) {
					addError("第" + getRowNumber() + "行,角色编码" + role + "存在重复项");
				}
				list.add(role);
				if(StringUtil.isNotEmpty(entity)){
					roleIds += entity.getId() + ",";
				}
			}
			if(StringUtil.isNotEmpty(roleIds)){
				row.put("roleIds", roleIds.substring(0, roleIds.length() - 1));
			}
		}
	}

	@Override
	public void impEnd() {
		if (null != tmCustUserBackExtendService){
			tmCustUserBackExtendService.afterImportCustUser(saveIdList);
		}
	}
}
