package com.biz.eisp.mdm.custuser.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.login.service.PasswdService;
import com.biz.eisp.mdm.custuser.dao.TmCustUserDao;
import com.biz.eisp.mdm.custuser.entity.TmRUserCustomerEntity;
import com.biz.eisp.mdm.custuser.service.TmCustUserExtendService;
import com.biz.eisp.mdm.custuser.service.TmCustUserSearchExtendService;
import com.biz.eisp.mdm.custuser.service.TmCustUserService;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.entity.TmUserRoleEntity;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.transformer.TmUserVoToTmUserEntity;
import com.biz.eisp.mdm.user.vo.TmCustUserVo;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/** 
 * 客户用户关系服务层接口实现
 * @author grover
 * @version v1.0
 */
@Service("tmCustUserService")
@Transactional
public class TmCustUserServiceImpl extends BaseServiceImpl implements TmCustUserService{
	/**
	 * 注入dao.
	 */
	@Autowired
	private TmCustUserDao tmCustUserDao;
	/**
	 * 注入dao.
	 */
	@Autowired
	private TmUserService tmUserService;
	/**
	 * 注入客户用户扩展service .
	 */
	@Autowired(required=false)
	private TmCustUserExtendService tmCustUserExtendService;


	@Autowired(required=false)
	private TmCustUserSearchExtendService tmCustUserSearchExtendService;

	/**
	 * 密码加密扩展
	 */
	@Autowired(required = false)
	private PasswdService passwdService;
	
	@Override
	public List<TmCustUserVo> findTmCustUserList(TmUserVo tmUserVo, Page page) {
		List<TmCustUserVo> userVos =new ArrayList<>();
		if(tmCustUserSearchExtendService!=null){
			String sql=tmCustUserSearchExtendService.buildSearchSql(tmUserVo);
			userVos= tmCustUserDao.findTmCustUserList(tmUserVo,sql, page);
		}else{
			userVos = tmCustUserDao.findTmCustUserList(tmUserVo, page);
		}
		return userVos;
	}

	@Override
	public TmCustUserVo findTmCustUserById(TmUserVo tmUserVo) {
		List<TmCustUserVo> list = tmCustUserDao.findTmCustUserList(tmUserVo, null);
		if(CollectionUtil.listNotEmptyNotSizeZero(list)){
			TmCustUserVo userVo = list.get(0);
			return userVo;
		}
		return null;
	}
	
	@Override
	public String saveTmUser(TmUserVo tmUserVo, Page page) {
		TmUserEntity tmUserEntity =  null;
		String userId="";
		//保存前扩展 此时entity还未通过vo转换
		if(StringUtil.isNotEmpty(tmCustUserExtendService)){
			//验证数据
			try {
				tmCustUserExtendService.validate(tmUserVo, page);
			} catch (Exception e) {
				throw new BusinessException("验证数据失败:"+e.getMessage());
			}
			//扩展
			tmUserEntity = tmCustUserExtendService.saveBefore(tmUserVo, page);
		}
		//entity为null时 通过vo转换
		if(StringUtil.isEmpty(tmUserEntity)){
			TmUserVoToTmUserEntity tmUserVoToTmUserEntity = new TmUserVoToTmUserEntity(tmUserService,passwdService);
			tmUserEntity = tmUserVoToTmUserEntity.apply(tmUserVo);
			userId=tmUserEntity.getId();
		}
		//保持前扩展 此时entity已经通过vo转换
		if(StringUtil.isNotEmpty(tmCustUserExtendService)){
			tmUserEntity = tmCustUserExtendService.saveBefore(tmUserEntity, tmUserVo, page);
		}
		//1.保存用户主数据
		this.saveOrUpdate(tmUserEntity);
		//保存后扩展
		if(StringUtil.isNotEmpty(tmCustUserExtendService)){
			tmUserEntity = tmCustUserExtendService.savePost(tmUserEntity, tmUserVo, page);
		}
		
		//2.删除无用关系数据同时记录日志 用户对应角色 
		String urhql="FROM TmUserRoleEntity where tmUser.id is null";
		List<TmUserRoleEntity> userRolelist=this.findByHql(urhql);
		for(TmUserRoleEntity userRole:userRolelist){
			String userRoleId=userRole.getId();
			super.addLogAndRemoveInvalidInfo(userRoleId, userRole, userId,null);
		}
		//删除无用用户与角色关系
		executeSql("DELETE FROM TM_R_USER_ROLE WHERE USER_ID IS NULL");
		
		//3.删除无用关系数据同时记录日志 用户对应客户
		String uchql="FROM TmRUserCustomerEntity where tmUser.id is null";
		List<TmRUserCustomerEntity> list=this.findByHql(uchql);
		for(TmRUserCustomerEntity userCustomer:list){
			String userCustId=userCustomer.getId();
			super.addLogAndRemoveInvalidInfo(userCustId, userCustomer, userId,null);
		}
		//删除无用用户与客户关系
		executeSql("DELETE FROM TM_R_USER_CUSTOMER WHERE USER_ID IS NULL OR CUSTOMER_ID IS NULL ");

		if (null != tmUserEntity){
			return tmUserEntity.getId();
		}else{
			return null;
		}
	}
	
	@Override
	public AjaxJson startOrStopTmuser(TmUserVo tmUserVo) {
		AjaxJson j = new AjaxJson();
		TmUserEntity tmUserEntity = get(TmUserEntity.class, tmUserVo.getId());
		if(StringUtil.isNotEmpty(tmUserEntity)){
			if(tmUserEntity.getEnableStatus().toString().equals(tmUserVo.getEnableStatus().toString())){
				j.setSuccess(false);
				String fg = Globals.ZERO == tmUserVo.getEnableStatus().shortValue()?"启用":"停用";
				j.setMsg("该数据状态已经为"+fg+"，无需再次操作");
			}else{
				tmUserEntity.setEnableStatus(Short.parseShort(tmUserVo.getEnableStatus().toString()));
				tmUserEntity.setLoginErrTimes(Globals.User_Normal);
				updateEntity(tmUserEntity);
			}
		}else{
			throw new BusinessException("未找到该纪录");
		}
		return j;
	}

	@Override
	public List<TmLogVo> findCustUserLogList(TmLogVo tmLogVo, Page page) {
		return tmCustUserDao.findCustUserLogList(tmLogVo, page);
	}
}
