package com.biz.eisp.mdm.dict.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.dict.entity.TmDictDataEntity;
import com.biz.eisp.mdm.dict.service.TmDictDataService;
import com.biz.eisp.mdm.dict.vo.DictTreeGrid;
import com.biz.eisp.mdm.dict.vo.TmDictDataVo;

/** 数据字典值的控制器
 * <p>数据类型值的增、删、改、查相关操作
 * @author wuzhujun
 * @version v1.0
 */
@SuppressWarnings("deprecation")
@Controller
@RequestMapping("/tmDictDataController")
public class TmDictDataController extends BaseController{
	/**
	 * 数据字典值服务层
	 */
	@Autowired
	private TmDictDataService tmDictDataService;
	
	/**
	 * 数据字典值treeGrid异步加载数据
	 * @author wuzhujun
	 * @param request 请求对象
	 * @param treegrid 	数据模型
	 * @return treeGrid的json模型
	 */
	@RequestMapping(value="dictGrid", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public List<DictTreeGrid> dictGrid(HttpServletRequest request, DictTreeGrid dictTreegrid){
		return  tmDictDataService.getDictsList(request, dictTreegrid);
	}
	/**
	 * 根据ID删除数据字典值.
	 * @author wuzhujun
	 * @param request 请求对象
	 * @param id 数据字典值ID
	 * @return json数据模型
	 */
	@RequestMapping(value="delete",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public AjaxJson deleteDictData(HttpServletRequest request,String id){
		String realId = id.split("_")[0];
		String type = id.split("_")[1];
		AjaxJson ajaxJson = new AjaxJson();
		if(type.equals("1")){
			ajaxJson.setMsg("请选择数据字典值删除！");
			return ajaxJson;
		}
		tmDictDataService.delete(realId);
		return ajaxJson;
	}
	/**
	 * 数据字典值添加页面跳转
	 * @author wuzhujun
	 * @param req 请求对象
	 * @param response 响应对象
	 * @return 返回数据字典类型添加页面
	 */
	@RequestMapping(value="goSaveDictData",method=RequestMethod.GET)
	public ModelAndView goSaveDictData(HttpServletRequest req
			,HttpServletResponse response){
		String id = req.getParameter("id");
		String dictTypeCode = req.getParameter("dictTypeCode");
		String realId = id.split("_")[0];
		String type = id.split("_")[1];
		DictTreeGrid dictgrid = new DictTreeGrid();
		if(type.equals("2")){
			dictgrid.setParentId(realId);
		}
		dictgrid.setDictTypeCode(dictTypeCode);
		req.setAttribute("dictTreegrid", dictgrid);
		return new ModelAndView("com/biz/eisp/mdm/dict/dictDataForm");
	}
	/**
	 * 保存修改数据字典值.
	 * @author wuzhujun
	 * @param dictTreegrid 数据字典vo
	 * @param req 请求对象
	 * @param response 响应对象
	 * @return json模型
	 */
	@RequestMapping(value = "saveOrUpdate", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveOrUpdateDictData(DictTreeGrid dictTreegrid, HttpServletRequest req
			,HttpServletResponse response){
		tmDictDataService.saveAndUpdate(dictTreegrid);
		return new AjaxJson();
	}
	/**
	 * 数据字典值修改页面跳转
	 * @author wuzhujun
	 * @param req 请求对象
	 * @param response 响应对象
	 * @return 返回数据字典类型添加页面
	 */
	@RequestMapping(value="goUpdateData",method=RequestMethod.GET)
	public ModelAndView goUpdateData(DictTreeGrid dictTreegrid,HttpServletRequest req
			,HttpServletResponse response){
		TmDictDataEntity t = tmDictDataService.get(dictTreegrid.getId().split("_")[0]);
		DictTreeGrid dictgrid = new DictTreeGrid(t);
		req.setAttribute("dictTreegrid", dictgrid);
		return new ModelAndView("com/biz/eisp/mdm/dict/dictDataForm");
	} 
	/**
	 * 验证重复数据字典值dictCode.
	 * @author wuzhujun
	 * @param  dictTreegrid 
	 * @param 验证对象
	 */
	@RequestMapping(value = "validateDataCode", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public ValidForm validateDataCode(DictTreeGrid dictTreegrid,HttpServletRequest request) {
		String param = OConvertUtils.getString(request.getParameter("param"));
		ValidForm validForm = new ValidForm();
		Criterion cr1 = Restrictions.eq("tmDictType.dictTypeCode", dictTreegrid.getDictTypeCode());
		Criterion cr2 = Restrictions.eq("dictCode",param);
		//验证
		if(StringUtil.isNotEmpty(dictTreegrid.getId())){
			//修改
			Criterion cr3 = Restrictions.ne("id", dictTreegrid.getId().split("_")[0]);
			List<TmDictDataEntity> dicts = tmDictDataService.findByCriteria(TmDictDataEntity.class, cr1,cr2,cr3);
			if(!CollectionUtils.isEmpty(dicts)){
				validForm.setStatus("n");
				validForm.setInfo("数据字典值编码已存在");
			}
		}else{
			List<TmDictDataEntity> dicts = tmDictDataService.findByCriteria(TmDictDataEntity.class, cr1,cr2);
			if(!CollectionUtils.isEmpty(dicts)){
				validForm.setStatus("n");
				validForm.setInfo("数据字典值编码已存在");
			}
		}
		return validForm;
	}
	
	/**
	 * 根据数据字典类型获取数据字典值 Grid列表.
	 * <p>
	 * @param request
	 * @param dictTypeCode
	 * @return
	 */
	@RequestMapping(value="goDictDataGridByTypeMain",method=RequestMethod.GET)
	public ModelAndView goDictDataByTypeForm(HttpServletRequest request, String dictTypeCode){
		request.setAttribute("dictTypeCode", dictTypeCode);
		return new ModelAndView("com/biz/eisp/mdm/dict/dictGridMain");
	} 
	
	/**
	 * 根据数据字典类型获取数据字典值.
	 * <p>
	 * @param request
	 * @param dictTypeCode
	 * @return
	 */
	@RequestMapping(value="findDictDataByType", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findDictDataByType(HttpServletRequest request, String dictTypeCode){
		List <TmDictDataVo> voList = tmDictDataService.findVoByType(dictTypeCode);
		DataGrid dataGrid = new DataGrid(voList, null);
		return dataGrid;
	}
}
