package com.biz.eisp.mdm.dict.controller;



import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.dict.entity.TmDictTypeEntity;
import com.biz.eisp.mdm.dict.service.TmDictDataService;
import com.biz.eisp.mdm.dict.service.TmDictTypeService;
import com.biz.eisp.mdm.dict.vo.DictTreeGrid;

/** 数据字典类型控制器类
 * <p>数据字典类型相关增、删、改、查相关访问
 * @author wuzhujun
 * @version v1.0
 */
@SuppressWarnings("deprecation")
@Controller
@RequestMapping("/tmDictTypeController")
public class TmDictTypeController extends BaseController{
	/**
	 * 数据字典类型服务层
	 */
	@Autowired
	private TmDictTypeService tmDictTypeService;
	/**
	 * 数据字典值的服务层
	 */
	@Autowired
	private TmDictDataService tmDictDataService;
	/**
	 * 第一次跳转到数据字典管理主界面
	 * <p>数据字典主界面跳转
	 * @author wuzhujun
	 * @return 数据模型和视图
	 */
	@RequestMapping(value="goDictMain",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goDictMain(){
		ModelAndView modelAndView = new ModelAndView(); 
		modelAndView.setViewName("com/biz/eisp/mdm/dict/dictMain");
		return modelAndView;
	}
	
	/**
	 * 删除数据字典类型
	 * @author wuzhujun
	 * @param id 删除的类型ID
	 * @return json模型数据
	 */
	@RequestMapping(value="deleteDictType", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson deleteDictType(String id){
		String realId = id.split("_")[0];
		String type = id.split("_")[1];
		
		AjaxJson ajaxJson = new AjaxJson();
		if(type.equals("2")){
			tmDictDataService.deleteDictData(realId);
		}else{
			tmDictTypeService.deleteDictType(realId);
		}
		return ajaxJson;
	}
	/**
	 * 数据字典类型添加页面跳转
	 * @author wuzhujun
	 * @param req 请求对象
	 * @param response 响应对象
	 * @return 返回数据字典类型添加页面
	 */
	@RequestMapping(value="goSaveDictType",method=RequestMethod.GET)
	public ModelAndView goSaveDictType(HttpServletRequest req
			,HttpServletResponse response){
		return new ModelAndView("com/biz/eisp/mdm/dict/dictTypeForm");
	}
	/**
	 * 保存修改数据字典类型.
	 * @author wuzhujun
	 * @param dictTreegrid 
	 * @param req 请求对象
	 * @param response 响应对象
	 * @return json模型
	 */
	@RequestMapping(value = "saveOrUpdate",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveOrUpdateDictType(DictTreeGrid dictTreegrid, HttpServletRequest req
			,HttpServletResponse response){
		//获取session信息
		tmDictTypeService.saveAndUpdate(dictTreegrid);
		return new AjaxJson();
	}
	/**
	 * 数据字典类型添加页面跳转
	 * @author wuzhujun
	 * @param req 请求对象
	 * @param response 响应对象
	 * @return 返回数据字典类型添加页面
	 */
	@RequestMapping(value="goUpdateType",method=RequestMethod.GET)
	public ModelAndView goUpdateType(DictTreeGrid dictTreegrid,HttpServletRequest req
			,HttpServletResponse response){
		TmDictTypeEntity t = tmDictTypeService.get(dictTreegrid.getId().split("_")[0]);
		DictTreeGrid dictgrid = new DictTreeGrid(t);
		req.setAttribute("dictTreegrid", dictgrid);
		return new ModelAndView("com/biz/eisp/mdm/dict/dictTypeForm");
	} 
	/**
	 * 验证重复Code.
	 * @author wuzhujun
	 * @param  dictTreegrid 
	 * @param 验证对象
	 */
	@RequestMapping(value = "validateTypeCode", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public ValidForm validateTypeCode(DictTreeGrid dictTreegrid,HttpServletRequest request) {
		String param = OConvertUtils.getString(request.getParameter("param"));
		ValidForm validForm = new ValidForm();
		//验证
		if(StringUtil.isNotEmpty(dictTreegrid.getId())){
			//修改
			Criterion cr2 = Restrictions.ne("id", dictTreegrid.getId().split("_")[0]);
			Criterion cr3 = Restrictions.eq("dictTypeCode", param);
			List<TmDictTypeEntity> tmDictTypes = tmDictTypeService.findByCriteria(TmDictTypeEntity.class,cr2, cr3);
			if(!CollectionUtils.isEmpty(tmDictTypes)){
				validForm.setStatus("n");
				validForm.setInfo("数据字典类型编码已存在");
			}
		}else{
			List<TmDictTypeEntity> tmDictTypes = tmDictTypeService.findByProperty(TmDictTypeEntity.class, "dictTypeCode", param);
			if(!CollectionUtils.isEmpty(tmDictTypes)){
				validForm.setStatus("n");
				validForm.setInfo("数据字典类型编码已存在");
			}
		}
		return validForm;
	}
	
}
