package com.biz.eisp.mdm.dict.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import com.biz.eisp.base.common.identity.IdEntity;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

/** 数据字典值表(tm_dict_data)
 * @author wuzhujun
 * @version v1.0
 */
@Entity
@Table(name = "tm_dict_data")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)  
public class TmDictDataEntity extends IdEntity implements java.io.Serializable{
	/**
	 * 描述.
	 */
	private static final long serialVersionUID = 1L;
	/**
	 * 数据字典编码
	 */
	private String dictCode;
	/**
	 * 数据字典名称
	 */
	private String dictValue;
	/**
	 * 权限对象值，对应数据字典authobj_value下的值
	 */
	private String dictDesc;
	/**
	 * 创建时间
	 */
	private Date createDate;
	/**
	 * 创建用户账号，对应tm_user表中的username字段值
	 */
	private String createName;
	/**
	 * 修改时间
	 */
	private Date  updateDate;
	/**
	 * 修改用户账号，对应tm_user表中的username字段值
	 */
	private String updateName;
	/**
	 * 上级字典ID，对应tm_dict_data表ID
	 */
	private TmDictDataEntity tmDictData;
	/**
	 * 数据字典类型编码，对应tm_dict_type表dict_type_code编码
	 */
	private TmDictTypeEntity tmDictType;
	/**
	 * 下级字典
	 */
	private List<TmDictDataEntity> TmDictDataList = new ArrayList<TmDictDataEntity>();
	private String text;
	private String value;
	private boolean checked = false;
	
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 数据字典值编码
	 */
	@Column(name = "dict_code",nullable=false)
	public String getDictCode() {
		return dictCode;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String  数据字典值编码
	 */
	public void setDictCode(String dictCode) {
		this.dictCode = dictCode;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String  数据字典值
	 */
	@Column(name = "dict_value",nullable=false)
	public String getDictValue() {
		return dictValue;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 数据字典值
	 */
	public void setDictValue(String dictValue) {
		this.dictValue = dictValue;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String  数据字典值描述
	 */
	@Column(name = "dict_desc",nullable=true)
	public String getDictDesc() {
		return dictDesc;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 数据字典值描述
	 */
	public void setDictDesc(String dictDesc) {
		this.dictDesc = dictDesc;
	}
	 /**
	 * 方法:取得java.util.Date
	 * @return java.util.Date 创建时间
	 */
	@Column(name = "create_date",nullable=true)
	public Date getCreateDate() {
		return createDate;
	}
	 /**
	 * 方法:设置java.util.Date
	 * @param java.util.Date 创建时间
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String  创建人
	 */
	@Column(name = "create_name",nullable=true)
	public String getCreateName() {
		return createName;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String  创建人
	 */
	public void setCreateName(String createName) {
		this.createName = createName;
	}
	/**
	 * 方法:取得java.util.Date
	 * @return java.util.Date 更新时间
	 */
	@Column(name = "update_date",nullable=true)
	public Date getUpdateDate() {
		return updateDate;
	}
	 /**
	 * 方法:设置java.util.Date
	 * @param java.util.Date 更新时间
	 */
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String  更新人
	 */
	@Column(name = "update_name",nullable=true)
	public String getUpdateName() {
		return updateName;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String   更新人
	 */
	public void setUpdateName(String updateName) {
		this.updateName = updateName;
	}
	/**
	 * 方法:取得com.biz.eisp.mdm.dict.entity.TmDictDataEntity
	 * @return  com.biz.eisp.mdm.dict.entity.TmDictDataEntity  上级字典ID，对应tm_dict_data表ID
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "parent_id",nullable=true)
	public TmDictDataEntity getTmDictData() {
		return tmDictData;
	}
	/**
	 * 方法:设置com.biz.eisp.mdm.dict.entity.TmDictDataEntity
	 * @param com.biz.eisp.mdm.dict.entity.TmDictDataEntity 上级字典ID，对应tm_dict_data表ID
	 */
	public void setTmDictData(TmDictDataEntity tmDictData) {
		this.tmDictData = tmDictData;
	}
	/**
	 * 方法:取得com.biz.eisp.mdm.dict.entity.TmDictTypeEntity
	 * @return com.biz.eisp.mdm.dict.entity.TmDictTypeEntity 数据字典类型
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "dict_type_code", referencedColumnName="dict_type_code")
	public TmDictTypeEntity getTmDictType() {
		return tmDictType;
	}
	/**
	 * 方法:设置com.biz.eisp.mdm.dict.entity.TmDictTypeEntity
	 * @param com.biz.eisp.mdm.dict.entity.TmDictTypeEntity 数据字典类型
	 */
	public void setTmDictType(TmDictTypeEntity tmDictType) {
		this.tmDictType = tmDictType;
	}
	/**
	 * 方法:取得java.util.List<com.biz.eisp.mdm.dict.entity.TmDictDataEntity>
	 * @return java.util.List<com.biz.eisp.mdm.dict.entity.TmDictDataEntity> 子数据字典值集合
	 */
	@Fetch(FetchMode.SUBSELECT)
	@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER, mappedBy = "tmDictData")
	public List<TmDictDataEntity> getTmDictDataList() {
		return TmDictDataList;
	}
	/**
	 * 方法:设置java.util.List<com.biz.eisp.mdm.dict.entity.TmDictDataEntity>
	 * @param java.util.List<com.biz.eisp.mdm.dict.entity.TmDictDataEntity> 子数据字典值集合
	 */
	public void setTmDictDataList(List<TmDictDataEntity> tmDictDataList) {
		TmDictDataList = tmDictDataList;
	}
	@Transient
	public String getText() {
		return text;
	}
	public void setText(String text) {
		this.text = text;
	}
	@Transient
	public String getValue() {
		return value;
	}
	public void setValue(String value) {
		this.value = value;
	}
	@Transient
	public boolean isChecked() {
		return checked;
	}
	public void setChecked(boolean checked) {
		this.checked = checked;
	}
	
}
