package com.biz.eisp.mdm.dict.entity;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.base.common.util.CollectionUtil;

import javax.persistence.*;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** 数据字典类型实体类(tm_dict_type)
 * @author wuzhujun
 * @version v1.0
 */
@Entity
@Table(name= "tm_dict_type")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE) 
public class TmDictTypeEntity extends IdEntity implements java.io.Serializable{

	/**
	 * 描述.
	 */
	private static final long serialVersionUID = 1L;
	/**
	 * 数据字典编码
	 */
	private String dictTypeCode;
	/**
	 * 数据字典名称 
	 */
	private String dictTypeName;
	/**
	 * 权限对象值，对应数据字典authobj_value下的值
	 */
	private String dictDesc;
	/**
	 * 创建时间
	 */
	private Date createDate;
	/**
	 * 创建用户账号，对应tm_user表中的username字段值
	 */
	private String  createName;
	/**
	 * 修改时间 
	 */
	private Date updateDate;
	/**
	 * 修改用户账号，对应tm_user表中的username字段值
	 */
	private String updateName;

    /**
     * 数据字典值
     */
    private List<TmDictDataEntity> tmDictDataList;
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 类型编码
	 */
	@Column(name = "dict_type_code",unique=true,nullable=false)
	public String getDictTypeCode() {
		return dictTypeCode;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 类型编码
	 */
	public void setDictTypeCode(String dictTypeCode) {
		this.dictTypeCode = dictTypeCode;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 名称
	 */
	@Column(name = "dict_type_name",nullable=false)
	public String getDictTypeName() {
		return dictTypeName;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 名称
	 */
	public void setDictTypeName(String dictTypeName) {
		this.dictTypeName = dictTypeName;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 描述
	 */
	@Column(name = "dict_desc",nullable=true)
	public String getDictDesc() {
		return dictDesc;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String  描述
	 */
	public void setDictDesc(String dictDesc) {
		this.dictDesc = dictDesc;
	}
	 /**
	 * 方法:取得java.util.Date
	 * @return java.util.Date 创建时间
	 */
	@Column(name = "create_date",nullable=true)
	public Date getCreateDate() {
		return createDate;
	}
	/**
	 * 方法:设置java.util.Date
	 * @param java.util.Date 创建时间
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 创建人
	 */
	@Column(name = "create_name",nullable=true)
	public String getCreateName() {
		return createName;
	}
	/**
	 * 方法:设置java.lang.String 
	 * 
	 * @param java.lang.String 创建人
	 */
	public void setCreateName(String createName) {
		this.createName = createName;
	}
	/**
	 * 方法:取得java.util.Date
	 * @return java.util.Date 更新时间
	 */
	@Column(name = "update_date",nullable=true)
	public Date getUpdateDate() {
		return updateDate;
	}
	/**
	 * 方法:设置java.util.Date
	 * @param java.util.Date 更新时间
	 */
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 更新人
	 */
	@Column(name = "update_name",nullable=true)
	public String getUpdateName() {
		return updateName;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 更新人
	 */
	public void setUpdateName(String updateName) {
		this.updateName = updateName;
	}
	/**
	 * 方法:取得java.util.List<com.biz.eisp.mdm.dict.entity.TmDictDataEntity> 
	 * @return java.util.List<com.biz.eisp.mdm.dict.entity.TmDictDataEntity> 数据字典集合 
	 */
	@Fetch(FetchMode.SUBSELECT)
    @OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER, mappedBy = "tmDictType")
    public List<TmDictDataEntity> getTmDictDataList() {
        return tmDictDataList;
    }
    /**
     * 方法:设置java.util.List<com.biz.eisp.mdm.dict.entity.TmDictDataEntity> 
     * @param java.util.List<com.biz.eisp.mdm.dict.entity.TmDictDataEntity>  数据字典集合 
     */
    public void setTmDictDataList(List<TmDictDataEntity> tmDictDataList) {
        this.tmDictDataList = tmDictDataList;
    }
    
}
