package com.biz.eisp.mdm.dict.service;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.dict.entity.TmDictDataEntity;
import com.biz.eisp.mdm.dict.vo.DictTreeGrid;
import com.biz.eisp.mdm.dict.vo.TmDictDataVo;
import com.biz.eisp.mdm.dict.vo.TmDictTypeVo;

/** 数据字典类型值服务类
 * <p>定义其增删改查功能
 * @author wuzhujun
 * @version v1.0
 */
@SuppressWarnings("deprecation")
public interface TmDictDataService extends BaseService{
	/**
	 * 保存和跟新数据字典值
	 * @author wuzhujun
	 * @param dictTreegrid 数据字典vo
	 */
	public void saveAndUpdate(DictTreeGrid dictTreegrid);
	/**
	 * 根据ID删除一个数据字典值
	 * @author wuzhujun
	 * @param id 数据字典值ID
	 */
	public void deleteDictData(String id);
	/**
	 * @author wuzhujun
	 * @param id 根据ID加载一个数据字典值
	 * @return 数据字典类型
	 */
	public TmDictDataEntity get(String id);
	/**
	 * 获取全部数据字典值
	 * @author wuzhujun
	 * @return  全部数据字典类型集合
	 */
	public List<TmDictDataEntity> list();
	/**
	 * 根据数据字典类型查找数据字典值的集合.
	 * @author wuzhujun
	 * @param typeCode 数据字典类型编码
	 * @return 某种类型的数据字典值的集合
	 */
	public List<TmDictDataEntity> findByType(String typeCode);
	/**
	 * 根据数据字典类型查找数据字典值的集合.
	 * @author wuzhujun
	 * @param typeCode 数据字典类型编码
	 * @return 某种类型的数据字典值的集合
	 */
	public List<TmDictDataVo> findVoByType(String typeCode);
	/**
	 * 加载数据字典的datagrid数据.
	 * @author wuzhujun
	 * @param request 请求对象
	 * @param treegrid 树对象
	 * @return 数据字典信息集合
	 */
	public  List<DictTreeGrid> getDictsList(HttpServletRequest request, DictTreeGrid dictTreeGrid);
	/**
	 * 根据数据字典值编码和数据字典类型编码.
	 * 查询数据字典值
	 * @author wuzhujun
	 * @param dictCode 数据字典值编码
	 * @param dictTypeCode 数据字典类型编码
	 * @return 数据字典值对象
	 */
	public TmDictDataEntity findByCode(String dictCode,String dictTypeCode);

	/**
	 * 同步缓存信息
	 */
	public  void syncDictCache(String  dictTypeCode);

	/**
	 * 同步缓存信息
	 */
	public  void syncDictCacheNew(TmDictTypeVo typeVo,List<TmDictDataVo> list,String lastCode);
}
