package com.biz.eisp.mdm.dict.service;

import java.util.List;

import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.dict.entity.TmDictTypeEntity;
import com.biz.eisp.mdm.dict.vo.DictTreeGrid;

/** 数据字典类型服务类
 * <p>实现对数据字典类型的增 删 改 查功能
 * @author wuzhujun
 * @version v1.0
 */
@SuppressWarnings("deprecation")
public interface TmDictTypeService extends BaseService{
	/**
	 * 保存和跟新数据字典类型
	 * @author wuzhujun
	 * @param dictTreegrid 数据字典vo
	 */
	public void saveAndUpdate(DictTreeGrid dictTreegrid);
	/**
	 * 根据ID删除一个数据字典类型
	 * @author wuzhujun
	 * @param id 数据字典类型ID
	 */
	public void deleteDictType(String id);
	/**
	 * @author wuzhujun
	 * @param id 根据ID加载一个数据字典类型
	 * @return 数据字典类型
	 */
	public TmDictTypeEntity get(String id);
	/**
	 * 获取全部数据字典类型
	 * @author wuzhujun
	 * @return
	 */
	public List<TmDictTypeEntity> list();
	
	

}
