package com.biz.eisp.mdm.dict.service.impl;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import com.biz.eisp.api.TmMqSerivce;
import com.biz.eisp.base.core.redis.cache.IRedisCacheService;
import com.biz.eisp.base.core.redis.cache.IRedisDictCacheService;
import com.biz.eisp.base.utils.DBConfigUtil;
import com.biz.eisp.mdm.dict.dao.TmDictDao;
import com.biz.eisp.mdm.dict.vo.TmDictTypeVo;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.dict.entity.TmDictDataEntity;
import com.biz.eisp.mdm.dict.entity.TmDictTypeEntity;
import com.biz.eisp.mdm.dict.service.TmDictDataService;
import com.biz.eisp.mdm.dict.service.TmDictTypeService;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.dict.vo.DictTreeGrid;
import com.biz.eisp.mdm.dict.vo.TmDictDataVo;

/**
 * 数据字典类型值的服务层实现类.
 * <p>实现了数据字典类型的增删改查的具体类型<br>
 *
 * @author wuzhujun
 * @version v1.0
 */
@SuppressWarnings("deprecation")
@Service("tmDictDataService")
@Transactional
public class TmDictDataServiceImpl extends BaseServiceImpl implements TmDictDataService {
    /**
     * 数据字典类型服务
     */
    @Autowired
    private TmDictTypeService tmDictTypeService;

    @Autowired(required = false)
    private TmMqSerivce tmMqSerivce;

    @Autowired(required = false)
    private IRedisDictCacheService redisDictCacheService;
    @Autowired
    private TmDictDao tmDictDao;
    @Autowired
    private IRedisCacheService redisCacheService;

    @Resource
    private DBConfigUtil dbConfigUtil;

    @Override
    public void saveAndUpdate(DictTreeGrid dictTreegrid) {
        TmDictDataEntity dictData = null;
        String id = dictTreegrid.getId();
        String parentId = dictTreegrid.getParentId();
        String dictTypeCode = dictTreegrid.getDictTypeCode();
        TmDictTypeEntity dictTypeEntity = getDictTypeEntity(dictTypeCode);
        //如果ID为空新加一条值的记录
        TmDictDataEntity tdd = null;
        String lastCode="";
        if (id == null || "".equals(id)) {
            dictData = dictTreegrid.getDictData(dictTypeEntity, this.get(parentId));
            dictData.setId(null);
            this.saveOrUpdate(dictData);
        } else {
            tdd = this.get(TmDictDataEntity.class, id.split("_")[0]);
            if (tdd == null) {
                throw new BusinessException("您所要修改的数据字典值不存在");
            }

            try {   //先清除已经有的缓存 后继再添加字典缓存
                redisCacheService.removeMap(this.dbConfigUtil.getJdbcUserName()+"_dict_json_data" + dictTypeCode, tdd.getDictCode()); //清除对应的字典
            } catch (Exception e) {
                e.printStackTrace();
                throw new BusinessException(e.getMessage());
            }
            lastCode=tdd.getDictCode()+"";
            dictData = dictTreegrid.getDictData(dictTypeEntity, this.get(parentId));
            tdd.setId(dictData.getId());
            tdd.setDictCode(dictData.getDictCode());
            tdd.setTmDictType(dictData.getTmDictType());
            tdd.setTmDictData(dictData.getTmDictData());
            tdd.setDictDesc(dictData.getDictDesc());
            tdd.setDictValue(dictData.getDictValue());
            this.saveOrUpdate(tdd);
        }
        if (StringUtil.isNotEmpty(tmMqSerivce)) {
            tmMqSerivce.dicCallBack(dictData);
        } else {
            TmDictTypeVo typeVo=new TmDictTypeVo();
            typeVo.setId(dictTypeEntity.getId());
            typeVo.setDictTypeCode(dictTypeEntity.getDictTypeCode());
            typeVo.setDictDesc(dictTypeEntity.getDictDesc());
            typeVo.setDictTypeName(dictTypeEntity.getDictTypeName());
            List<TmDictDataVo> list=new ArrayList<>();
            TmDictDataVo dataVo=new TmDictDataVo();
            dataVo.setId(dictData.getId());
            dataVo.setDictCode(dictData.getDictCode());
            dataVo.setDictTypeCode(dictTypeEntity.getDictTypeCode());
            dataVo.setParentId(dictData.getTmDictData()!=null?dictData.getTmDictData().getId():null);
            dataVo.setDictDesc(dictData.getDictDesc());
            dataVo.setDictValue(dictData.getDictValue());
            list.add(dataVo);
            syncDictCacheNew(typeVo,list,lastCode);
        }
    }

    /**
     * 同步缓存信息
     */
    @Override
    public void syncDictCache(String dictTypeCode) {
        if (redisDictCacheService != null) {
            redisDictCacheService.syncDictCache(dictTypeCode);
        }
        TmDictTypeVo vo = new TmDictTypeVo();
        vo.setDictTypeCode(dictTypeCode);
        List<TmDictTypeVo> typeGroups = tmDictDao.getDictTypeVoList(vo);
        try {
            for (TmDictTypeVo dictTypeEntity : typeGroups) {
                DictUtil.allDictType.put(dictTypeEntity.getDictTypeCode(),
                        dictTypeEntity);
                List<TmDictDataVo> list = tmDictDao.getDictDataVoList(vo);
                if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                    DictUtil.allDictData.put(dictTypeEntity.getDictTypeCode(), list);
                    for (int i = 0; i < list.size(); i++) {
                        redisCacheService.setMap(this.dbConfigUtil.getJdbcUserName()+"_dict_json_data"+dictTypeCode, list.get(i).getDictCode(), list.get(i));
                    }
                }
            }
        } catch (Exception e) {
            throw new BusinessException("缓存异常！");
        }
        redisCacheService.incrBy(this.dbConfigUtil.getJdbcUserName()+"_dict_version", 1);//添加版本更新提示
    }

    @Override
    public void syncDictCacheNew( TmDictTypeVo typeVo, List<TmDictDataVo> list,String lastCode) {
        String dictTypeCode=typeVo.getDictTypeCode();
        if (redisDictCacheService != null) {
            redisDictCacheService.syncDictCache(dictTypeCode);
        }
        try {
            DictUtil.allDictType.put(typeVo.getDictTypeCode(),
                    typeVo);
            List<TmDictDataVo> list1 = tmDictDao.getDictDataVoList(typeVo);
            if (CollectionUtil.listNotEmptyNotSizeZero(list1)) { //存在数据那么先判断是否 是新增
                String dictCode=list.get(0).getDictCode();
                for (int i = 0; i <list1.size() ; i++) {
                    TmDictDataVo dataVo=list1.get(i);
                    if (!dataVo.getDictCode().equals(dictCode)){
                        //如果上次为空或者 修改前的与修改后的 不相同时处理以下逻辑
                        if (StringUtils.isBlank(lastCode)||!dataVo.getDictCode().equals(lastCode)){
                            list.add(dataVo);
                        }
                    }
                }
            }
            DictUtil.allDictData.put(dictTypeCode, list);
            for (int i = 0; i < list.size(); i++) {
                redisCacheService.setMap(this.dbConfigUtil.getJdbcUserName()+"_dict_json_data"+dictTypeCode, list.get(i).getDictCode(), list.get(i));
            }
        } catch (Exception e) {
            throw new BusinessException("缓存异常！");
        }
        redisCacheService.incrBy(this.dbConfigUtil.getJdbcUserName()+"_dict_version", 1);//添加版本更新提示
    }

    /**
     * 根据数据字典类型编码获取类型对象
     *
     * @param dictTypeCode 数据字典类型编码
     * @return 数据字典类型对象
     * @author wuzhujun
     */
    private TmDictTypeEntity getDictTypeEntity(String dictTypeCode) {
        Criterion cr1 = Restrictions.eq("dictTypeCode", dictTypeCode);
        List<TmDictTypeEntity> dictType = findByCriteria(TmDictTypeEntity.class, cr1);
        if (CollectionUtils.isEmpty(dictType)) {
            throw new BusinessException("数据字典类型不存在");
        }
        return dictType.get(0);
    }

    @Override
    public void deleteDictData(String id) {
        TmDictDataEntity t = super.get(TmDictDataEntity.class, id);
        String dictTypeCode = t.getTmDictType().getDictTypeCode();
        List<TmDictDataEntity> tdds = super.findByProperty(TmDictDataEntity.class, "tmDictData", t);
        if (tdds != null && tdds.size() > 0) {
            throw new BusinessException("删除的对象有子对象，不能删除");
        }
//		super.delete(t);
        tmDictDao.delDataVo(id);
        try {
            if (StringUtil.isNotEmpty(tmMqSerivce)) {
                tmMqSerivce.dicCallBack(t);
            } else {
                redisCacheService.removeMap(this.dbConfigUtil.getJdbcUserName()+"_dict_json_data"+dictTypeCode,t.getDictCode()); //清除对应的字典
                syncDictCache(dictTypeCode);
            }
        } catch (Exception e) {
            throw new BusinessException("删除失败！");
        }
    }

    @Override
    public TmDictDataEntity get(String id) {
        return super.get(TmDictDataEntity.class, id);
    }

    @Override
    public List<TmDictDataEntity> list() {
        return super.loadAll(TmDictDataEntity.class);
    }

    @Override
    public List<TmDictDataEntity> findByType(String typeCode) {
        String hql = "select data from TmDictDataEntity data where data.tmDictType.dictTypeCode = ?";
        return this.findByHql(hql, typeCode);
    }

    @Override
    public List<DictTreeGrid> getDictsList(HttpServletRequest request, DictTreeGrid dictTreeGrid) {
        //当treeGrid不为空时，查询数据字典值表，否则查询数据字典类型表
        String girdID = request.getParameter("id");
        List<DictTreeGrid> dictTreeGrids = new ArrayList<DictTreeGrid>();
        if (StringUtil.isNotEmpty(girdID)) {
            String gridId = girdID.split("_")[0];
            String gridType = girdID.split("_")[1];

            List<TmDictDataEntity> dictDataList = new ArrayList<TmDictDataEntity>();
            if (gridType.equals("1")) {
                TmDictTypeEntity ty = tmDictTypeService.get(gridId);
                dictDataList = this.findByHql("select t from TmDictDataEntity t where t.tmDictData is null and t.tmDictType = ?  order by create_date desc", ty);
            } else {
                TmDictDataEntity td = this.get(gridId);
                dictDataList = this.findByHql("select t from TmDictDataEntity t where t.tmDictData = ?  order by create_date desc", td);
            }
            for (TmDictDataEntity td : dictDataList) {
                DictTreeGrid d = new DictTreeGrid(td);
                dictTreeGrids.add(d);
            }
            return dictTreeGrids;
        } else {
            List<TmDictTypeEntity> dictTypeList = new ArrayList<TmDictTypeEntity>();
            dictTypeList = this.findBySql(TmDictTypeEntity.class, "select * from tm_dict_type order by create_date desc");
            for (TmDictTypeEntity t : dictTypeList) {
                DictTreeGrid d = new DictTreeGrid(t);
                //判断类型下面是否还有类型值，如果有把status设置为colsed
                if (hasDictData(t)) {
                    d.setState("closed");
                }
                dictTreeGrids.add(d);
            }
            return dictTreeGrids;
        }
    }

    /**
     * 判断数据字典下是否含有值.
     *
     * @param ty 数据字典类型对象
     * @return 数据字典类型是否含有数据字典类型值
     * @author wuzhujun
     */
    private boolean hasDictData(TmDictTypeEntity ty) {
        Criterion cr1 = Restrictions.eq("tmDictType", ty);
        List<TmDictDataEntity> dicts = findByCriteria(TmDictDataEntity.class, cr1);
        if (!CollectionUtils.isEmpty(dicts) && dicts.size() > 0) {
            return true;
        }
        return false;
    }

    @Override
    public TmDictDataEntity findByCode(String dictCode, String dictTypeCode) {
        Criterion cr1 = Restrictions.eq("dictCode", dictCode);
        Criterion cr2 = Restrictions.eq("tmDictType.dictTypeCode", dictTypeCode);
        List<TmDictDataEntity> dicts = findByCriteria(TmDictDataEntity.class, cr1, cr2);
        if (!CollectionUtils.isEmpty(dicts)) {
            TmDictDataEntity dictDataEntity = dicts.get(0);
            return dictDataEntity;
        }
        return new TmDictDataEntity();
    }

    @Override
    public List<TmDictDataVo> findVoByType(String typeCode) {
        String sql = "SELECT id AS id, dict_code AS dictCode,dict_value AS dictValue,dict_desc AS dictDesc FROM tm_dict_data WHERE dict_type_code = ?";
        List<TmDictDataVo> dictDataVos = findBySql(TmDictDataVo.class, sql, typeCode);
        return dictDataVos;
    }
}
