package com.biz.eisp.mdm.dict.service.impl;

import java.util.List;

import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.dict.entity.TmDictDataEntity;
import com.biz.eisp.mdm.dict.entity.TmDictTypeEntity;
import com.biz.eisp.mdm.dict.service.TmDictTypeService;
import com.biz.eisp.mdm.dict.vo.DictTreeGrid;

/** 数据字典类型服务层实现类.
 * <p>具体实现了数据字典服务层<br>
 * 的增删改查等业务功能
 * @author wuzhujun
 * @version v1.0
 */
@SuppressWarnings("deprecation")
@Service("tmDictTypeService")
@Transactional
public class TmDictTypeServiceImpl extends BaseServiceImpl implements TmDictTypeService{

	@Override
	public void deleteDictType(String id) {
		TmDictTypeEntity t = super.get(TmDictTypeEntity.class, id);
		List<TmDictDataEntity> tdds = super.findByProperty(TmDictDataEntity.class, "tmDictType", t);
		if(tdds!=null&&tdds.size()>0){
			throw new BusinessException("要删除的对象，还有子对象不能删除");
		}
		super.delete(t);
		
	}
	@Override
	public TmDictTypeEntity get(String id) {
		return super.get(TmDictTypeEntity.class, id);
	}
	@Override
	public List<TmDictTypeEntity> list() {
		String hql = "from TmDictTypeEntity";
		return super.findByHql(hql);
	}
	
	@Override
	public void saveAndUpdate(DictTreeGrid dictTreegrid) {
		TmDictTypeEntity dictType = null;
		String id = dictTreegrid.getId().split("_")[0];
		if(id == null || "".equals(id)){
			dictType = dictTreegrid.getDictType();
			dictType.setId(null);
			this.saveOrUpdate(dictType);
		}else{
			TmDictTypeEntity t = this.get(TmDictTypeEntity.class, id);
			if(t == null){
				throw new BusinessException("修改的对象已经不存在");
			}
			dictType = dictTreegrid.getDictType();
			t.setId(dictType.getId());
			t.setDictDesc(dictType.getDictDesc());
			t.setDictTypeName(dictType.getDictTypeName());
			t.setDictTypeCode(dictType.getDictTypeCode());
			this.saveOrUpdate(t);
			//批量更新dictData里面dictTypeCode值
			String oldTypeCode  = t.getDictTypeCode();
			Criterion cr = Restrictions.eq("tmDictType", getDictTypeEntity(oldTypeCode));
			List<TmDictDataEntity> dicts = findByCriteria(TmDictDataEntity.class, cr);
			for(TmDictDataEntity ty :dicts){
				ty.setTmDictType(t);
				this.saveOrUpdate(ty);
			}
		}
		
	}
	/**
	 * 根据数据字典类型编码获取类型对象
	 * @author wuzhujun
	 * @param dictTypeCode 数据字典类型编码
	 * @return 数据字典类型对象
	 */
	private TmDictTypeEntity getDictTypeEntity(String dictTypeCode){
		Criterion cr1 = Restrictions.eq("dictTypeCode", dictTypeCode);
		List<TmDictTypeEntity> dictType = findByCriteria(TmDictTypeEntity.class, cr1);
		if(CollectionUtils.isEmpty(dictType)){
			throw new BusinessException("数据字典类型不存在");
		}
		return dictType.get(0);
	}

}
