package com.biz.eisp.mdm.dict.transformer;

import java.util.List;

import com.biz.eisp.mdm.dict.vo.TmDictDataAuVo;
import org.springframework.util.CollectionUtils;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.mdm.authobj.entity.TmRoleFuncAuthobjEntity;
import com.biz.eisp.mdm.dict.entity.TmDictDataEntity;
import com.biz.eisp.mdm.dict.vo.TmDictDataVo;
import com.google.common.base.Function;

/** 数据字典转换器.
 * @author grover
 * @version v1.0
 */
public class TmDictDataEntityToTmDictDataVo implements Function<TmDictDataEntity, TmDictDataAuVo> {
	/**
	 * 选中的权限值
	 */
	private List<TmRoleFuncAuthobjEntity> roleFuncAuth;
	/**
	 * 构造.
	 * @param roleFuncAutList 选中的权限值
	 */
	public TmDictDataEntityToTmDictDataVo(List<TmRoleFuncAuthobjEntity> roleFuncAutList){
		this.roleFuncAuth = roleFuncAutList;
	}
	
	@Override
	public TmDictDataAuVo apply(TmDictDataEntity arg0) {
		TmDictDataAuVo dictDataVo = new TmDictDataAuVo();
		dictDataVo.setChildren(arg0.getTmDictDataList());
		dictDataVo.setCreateDate(arg0.getCreateDate());
		dictDataVo.setCreateName(arg0.getCreateName());
		dictDataVo.setDictCode(arg0.getDictCode());
		dictDataVo.setDictDesc(arg0.getDictDesc());
		dictDataVo.setDictTypeCode(arg0.getTmDictType());
		dictDataVo.setDictValue(arg0.getDictValue());
		dictDataVo.setId(arg0.getId());
		dictDataVo.setParentId(arg0.getTmDictData());
		dictDataVo.setUpdateDate(arg0.getUpdateDate());
		dictDataVo.setUpdateName(arg0.getUpdateName());
		//转换
		if(!CollectionUtils.isEmpty(roleFuncAuth)){
			for (TmRoleFuncAuthobjEntity authobjEntity : roleFuncAuth) {
				if(arg0.getDictCode().equals(authobjEntity.getAuthobjValue())){
					dictDataVo.setStatus(Globals.User_Normal.toString());
				}
			}
		}
		return dictDataVo;
	}

}
