package com.biz.eisp.mdm.dict.util;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.redis.cache.IRedisCacheService;
import com.biz.eisp.base.core.redis.cache.IRedisDictCacheService;
import com.biz.eisp.base.core.redis.util.RedisUtils;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.base.utils.DBConfigUtil;
import com.biz.eisp.mdm.dict.vo.TmDictDataVo;
import com.biz.eisp.mdm.dict.vo.TmDictTypeVo;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** 类简述.
 * <p>类的详细说明第一行<br>
 * 类的详细说明第二行
 * @author 肖胜
 * @version v1.0
 */
public class DictUtil {


	private static DBConfigUtil dbConfigUtil;

	static {
		dbConfigUtil = ApplicationContextUtils.getContext().getBean(DBConfigUtil.class);
	}

//	public final  static String dict_version= ResourceUtil.getDbConfigProperty("jdbc.username") +"_dict_version";
//	public final  static String dict_json_data=ResourceUtil.getDbConfigProperty("jdbc.username") +"_dict_json_data";
//	public final  static String dict_json_type=ResourceUtil.getDbConfigProperty("jdbc.username") +"_dict_json_type";

//	public final  static String dict_version= DictUtil.dbConfigUtil.getJdbcUserName()+"_dict_version";
//	public final  static String dict_json_data=DictUtil.dbConfigUtil.getJdbcUserName() +"_dict_json_data";
//	public final  static String dict_json_type=DictUtil.dbConfigUtil.getJdbcUserName() +"_dict_json_type";

	public final static HashMap<String,Long> versionMap=new HashMap<>();
	//缓存数据字典
	public static Map<String, TmDictTypeVo> allDictType =
			new HashMap<String, TmDictTypeVo>();

	//缓存数据字典值
    public static Map<String, List<TmDictDataVo>> allDictData =
    		new HashMap<String, List<TmDictDataVo>>();

    public static List<TmDictDataVo> getDictList(String typCode){
		List<TmDictDataVo> dictList=new ArrayList<>();
		IRedisCacheService redisCacheService=RedisUtils.getIRedisCacheService();
		if (redisCacheService!=null){
			Long now=	redisCacheService.incrBy(DictUtil.dbConfigUtil.getJdbcUserName()+"_dict_version",0);//加0  获取当前的版本号
			Long old= DictUtil.versionMap.get(DictUtil.dbConfigUtil.getJdbcUserName()+"_dict_version");
			if(old == null) {
				old = -1L;
			}
			if (now.intValue()!=old.intValue()){ //表示版本有更新
				DictUtil.versionMap.put(DictUtil.dbConfigUtil.getJdbcUserName()+"_dict_version",now); //更新本地版本
				try {
					List<TmDictTypeVo> typeVos = redisCacheService.getMapValues(DictUtil.dbConfigUtil.getJdbcUserName() +"_dict_json_type", TmDictTypeVo.class);//获取所有 typeredis数据
				   if (CollectionUtils.isEmpty(typeVos)) {
					   allDictType.clear();
					   allDictData.clear();
					   for (int i = 0; i < typeVos.size(); i++) {
						   allDictType.put(typeVos.get(i).getDictTypeCode(),typeVos.get(i));
						   List<TmDictDataVo> vos = redisCacheService.getMapValues(DictUtil.dbConfigUtil.getJdbcUserName() +"_dict_json_data"+typeVos.get(i).getDictTypeCode(), TmDictDataVo.class);//获取所有data redis数据
						   allDictData.put(typeVos.get(i).getDictTypeCode(),vos);
					   }
				   }
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		dictList=allDictData.get(typCode);
		return dictList;
	}
    /**
     * 根据数据字典Code获取值
     * @param typeCode
     * @param dataCode
     * @return
     */
    public static String getDictDataValueByCode(String typeCode,String dataCode){
		//数据字典转换
		String dataValue="";
		IRedisDictCacheService redisDictCacheService = RedisUtils.getIRedisDictCacheService();
		if(redisDictCacheService!=null){
			dataValue=redisDictCacheService.getDictDataValueByCode(typeCode, dataCode);
		}else{
			List<TmDictDataVo> dictDatas = DictUtil.getDictList(typeCode);
			if(CollectionUtil.listNotEmptyNotSizeZero(dictDatas)){
				for (TmDictDataVo tmDictDataVo : dictDatas) {
					if(dataCode.equals(tmDictDataVo.getDictCode())){
						dataValue = tmDictDataVo.getDictValue();
					}
				}
			}
		}
		return dataValue;
    }

    /**
     * 根据数据字典值获取code
     * @param typeCode
     * @param dataValue
     * @return
     */
    public static String getDictCodeByValue(String typeCode,String dataValue){
		//数据字典转换
		String dataCode = "";
		IRedisDictCacheService redisDictCacheService = RedisUtils.getIRedisDictCacheService();
		if(redisDictCacheService!=null){
			dataCode=redisDictCacheService.getDictCodeByValue(typeCode, dataValue);
		}else {
			List<TmDictDataVo> dictDatas = DictUtil.getDictList(typeCode);
			if (CollectionUtil.listNotEmptyNotSizeZero(dictDatas)) {
				for (TmDictDataVo tmDictDataVo : dictDatas) {
					if (dataValue.trim().equals(tmDictDataVo.getDictValue())) {
						dataCode = tmDictDataVo.getDictCode();
					}
				}
			}
		}
		return dataCode;
    }
    /**
     * 根据数据字典codes（以，号分割）获取值
     * @param typeCode 类型code
     * @param dataValues 值
     * @return 值以，号分割
     */
    public static String getDictDatasByCodes(String typeCode,String dataValues){
		//数据字典转换
		String dataCodes = "";
		IRedisDictCacheService redisDictCacheService = RedisUtils.getIRedisDictCacheService();
		if(redisDictCacheService!=null){
			dataCodes=redisDictCacheService.getDictDatasByCodes(typeCode, dataValues);
		}else {
			if (StringUtil.isNotEmpty(dataValues)) {
				if (dataValues.indexOf(",") != -1) {
					for (String value : dataValues.split(",")) {
						if (StringUtil.isNotEmpty(dataCodes)) {
							dataCodes += ",";
						}
						dataCodes += getDictDataValueByCode(typeCode, value);
					}
				} else {
					dataCodes += getDictDataValueByCode(typeCode, dataValues);
				}
			}
		}
    	return dataCodes;
    }
    /**
     * 获取字典对象
     * @param typeCode 类型code
     * @param dataCode code
     * @return
     */
    public static TmDictDataVo getDicData(String typeCode,String dataCode){
		//数据字典转换
		TmDictDataVo data = null;
		IRedisDictCacheService redisDictCacheService = RedisUtils.getIRedisDictCacheService();
		if(redisDictCacheService!=null){
			data=redisDictCacheService.getDicData(typeCode, dataCode);
		}else {

			List<TmDictDataVo> dictDatas = DictUtil.getDictList(typeCode);
			if (CollectionUtil.listNotEmptyNotSizeZero(dictDatas)) {
				for (TmDictDataVo tmDictDataVo : dictDatas) {
					if (dataCode.equals(tmDictDataVo.getDictCode())) {
						data = tmDictDataVo;
					}
				}
			}
		}
		return data;
    }

    /**
     * 获取字典名
     * @param typeCode 类型code
     * @param dataCode code
     * @return
     */
    public static String getDicDataValue(String typeCode,String dataCode){
		//数据字典转换
		String dataVal=null;

		IRedisDictCacheService redisDictCacheService = RedisUtils.getIRedisDictCacheService();

		if(redisDictCacheService!=null){
			dataVal=redisDictCacheService.getDicDataValue(typeCode, dataCode);
		}else {
			List<TmDictDataVo> dictDatas = DictUtil.getDictList(typeCode);
			if (CollectionUtil.listNotEmptyNotSizeZero(dictDatas)) {
				for (TmDictDataVo tmDictDataEntity : dictDatas) {
					if (dataCode.equals(tmDictDataEntity.getDictCode())) {
						dataVal = tmDictDataEntity.getDictValue();
					}
				}
			}
		}
		return dataVal;
    }
}
