package com.biz.eisp.mdm.dict.vo;

import java.util.Date;


import com.biz.eisp.mdm.dict.entity.TmDictDataEntity;
import com.biz.eisp.mdm.dict.entity.TmDictTypeEntity;

/** 数据字典Vo类
 * @author zhujun
 * @version v1.0
 */
public class DictTreeGrid implements java.io.Serializable {
	/**
	 * 描述.
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * 主键ID
	 */
	private String id;
	/**
	 * 数据字典值code
	 */
	private String dictCode;
	/**
	 * 数据字典类型Code
	 */
	private String dictTypeCode;
	
	/**
	 * 类型或者值的名称。
	 */
	private String text;
	/**
	 * 类型或者值的描述
	 */
	private String desc;
	/**
	 * 创建时间
	 */
	private Date createDate;
	/**
	 * 创建人
	 */
	private String createName;
	/**
	 * 更新时间
	 */
	private Date updateDate;
	/**
	 * 更新人
	 */
	private String updateName;
	/**
	 * 父ID
	 */
	private String parentId;
	/**
	 * 是否是数据字典类型
	 */
	private String isType;
	/**
	 * 是否关闭
	 */
	private String state = "open";
	/**
	 * 数据字典值的类型名称
	 */
	private String typeName = "";
	
	public String getDictCode() {
		return dictCode;
	}
	public void setDictCode(String dictCode) {
		this.dictCode = dictCode;
	}
	public String getDictTypeCode() {
		return dictTypeCode;
	}
	public void setDictTypeCode(String dictTypeCode) {
		this.dictTypeCode = dictTypeCode;
	}
	
	public String getText() {
		return text;
	}
	public void setName(String text) {
		this.text = text;
	}
	
	
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public String getDesc() {
		return desc;
	}
	public void setDesc(String desc) {
		this.desc = desc;
	}
	public Date getCreateDate() {
		return createDate;
	}
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	public String getCreateName() {
		return createName;
	}
	public void setCreateName(String createName) {
		this.createName = createName;
	}
	public String getIsType() {
		return isType;
	}
	public void setIsType(String isType) {
		this.isType = isType;
	}
	public void setText(String text) {
		this.text = text;
	}
	public Date getUpdateDate() {
		return updateDate;
	}
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}
	public String getUpdateName() {
		return updateName;
	}
	public void setUpdateName(String updateName) {
		this.updateName = updateName;
	}
	public String getParentId() {
		return parentId;
	}
	public void setParentId(String parentId) {
		this.parentId = parentId;
	}
	public String isType() {
		return isType;
	}
	public void setType(String isType) {
		this.isType = isType;
	}
	public String getState() {
		return state;
	}
	public void setState(String state) {
		this.state = state;
	}
	public String getTypeName() {
		return typeName;
	}
	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}
	/**
	 * 空的构造方法.
	 */
	public DictTreeGrid(){
	}
	/**
	 * 得到数据字典值的对象
	 * @author wuzhujun
	 * @param type 数据字典类型
	 * @param parnet 父节点
	 * @return 数据字典值的对象
	 */
	public TmDictDataEntity getDictData(TmDictTypeEntity type,TmDictDataEntity parnet){
		TmDictDataEntity dictData = new TmDictDataEntity();
		dictData.setId(this.getId().split("_")[0]);
		dictData.setDictDesc(this.getDesc());
		dictData.setDictValue(this.getText());
		dictData.setCreateDate(this.getCreateDate());
		dictData.setCreateName(this.getCreateName());
		dictData.setUpdateDate(updateDate);
		dictData.setUpdateName(updateName);
		dictData.setDictCode(dictCode);
		dictData.setTmDictType(type);
		dictData.setTmDictData(parnet);
		return dictData;
	}
	/**
	 * 从vo中得到数据字典类型对象.
	 * @author wuzhujun
	 * @return  数据字典类型对象
	 */
	public TmDictTypeEntity getDictType(){
		TmDictTypeEntity dictType = new TmDictTypeEntity();
		dictType.setId(this.getId().split("_")[0]);
		dictType.setDictDesc(this.getDesc());
		dictType.setDictTypeName(this.getText());
		dictType.setCreateDate(this.getCreateDate());
		dictType.setCreateName(this.getCreateName());
		dictType.setUpdateDate(updateDate);
		dictType.setUpdateName(updateName);
		dictType.setDictTypeCode(this.getDictTypeCode());
		return dictType;
	}
	/**
	 * 初始化数据字典值.
	 * @param dictData 数据字典值对象
	 */
	public DictTreeGrid(TmDictDataEntity dictData){
		this.setId(dictData.getId()+"_2");
		this.setCreateDate(dictData.getCreateDate());
		this.setCreateName(dictData.getCreateName());
		this.setDesc(dictData.getDictDesc());
		this.setName(dictData.getDictValue());
		this.setUpdateDate(dictData.getUpdateDate());
		this.setUpdateName(dictData.getUpdateName());
		this.setDictCode(dictData.getDictCode());
		this.setDictTypeCode(dictData.getTmDictType()!=null?dictData.getTmDictType().getDictTypeCode():null);
		this.setTypeName(dictData.getTmDictType()!=null?dictData.getTmDictType().getDictTypeName():null);
		if(dictData.getTmDictDataList()!=null&&dictData.getTmDictDataList().size()>0){
			this.setState("closed");
		}
		
		this.setType("2");
		if(dictData.getTmDictData()!=null){
			this.setParentId(dictData.getTmDictData().getId());
		}
		
	}
	/**
	 * 初始化数据字典类型.
	 * @param dictType 数据字典类型对象
	 */
	public DictTreeGrid(TmDictTypeEntity dictType){
		this.setId(dictType.getId()+"_1");
		this.setCreateDate(dictType.getCreateDate());
		this.setCreateName(dictType.getCreateName());
		this.setDesc(dictType.getDictDesc());
		this.setName(dictType.getDictTypeName());
		this.setUpdateDate(dictType.getUpdateDate());
		this.setUpdateName(dictType.getUpdateName());
		this.setDictTypeCode(dictType.getDictTypeCode());
		this.setType("1");
	}
}
