package com.biz.eisp.mdm.erpcode.handler;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.mdm.erpcode.commond.QuoteStrategy;

/**
 * 第三方系统编码访问处理器
 * @author 肖胜
 * @version v1.0
 */
public class QuoteCodeHandler {

	//访问策略
	private QuoteStrategy quoteStrategy;

	private QuoteCodeHandler(){
	}
	
	private static QuoteCodeHandler instance = null;  
	 
	public static QuoteCodeHandler getInstance() {  
        if (instance == null) {  
            instance = new QuoteCodeHandler();  
        }  
        return instance;  
     }  
	 
	/**
	 * 执行访问
	 * @return
	 */
	public Object requestCodeInfo(String code){
		if(StringUtil.isEmpty( code)){
			return quoteStrategy.remoteAccess();
		}
		return quoteStrategy.remoteAccess(code);
	}

	/**
	 * 设置执行策略
	 * @param quoteStrategy
	 */
	public QuoteCodeHandler setQuoteStrategy(QuoteStrategy quoteStrategy) {
		this.quoteStrategy = quoteStrategy;
		return this;
	}
	
}
