
package com.biz.eisp.mdm.function.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.TreeGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.function.entity.TmFunctionEntity;
import com.biz.eisp.mdm.function.service.TmFunctionService;
import com.biz.eisp.mdm.function.transformer.TmFunctionEntityToTmFunctionVo;
import com.biz.eisp.mdm.function.vo.TmFunctionVo;
import com.biz.eisp.mdm.icon.entity.TmIconEntity;
/**
 * 菜单管理Controller
 * @author 肖胜
 * @version v1.0
 */
@Controller
@RequestMapping("/functionController")
public class TmFunctionController extends BaseController {
	/**
	 * 注入菜单服务层.
	 */
	@Autowired
	private TmFunctionService tmFunctionService;


	
	/**
	 * 跳转至菜单管理主页面
	 * @return ModelAndView
	 */
    @RequestMapping(value = "goFunctionMain",method = {RequestMethod.GET,RequestMethod.POST})
    public ModelAndView goFunctionMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/function/functionMain");
    }

	/**
	 * 跳转至菜单选择页面
	 * @return ModelAndView
	 */
	@RequestMapping(value = "goFunctionSelect", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goFunctionSelect(HttpServletRequest request) {
		return new ModelAndView("com/biz/eisp/mdm/function/functionSelect");
	}

	/**
	 * 跳转至菜单管理主页面
	 * @return ModelAndView
	 */
    @RequestMapping(value = "goFunctionForm", method = {RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goFunctionForm(HttpServletRequest request,TmFunctionEntity tmFunctionEntity) {
    	if (StringUtil.isNotEmpty(tmFunctionEntity.getId())) {
    		TmFunctionVo functionVo=new TmFunctionEntityToTmFunctionVo(tmFunctionService).apply(tmFunctionEntity);
    		request.setAttribute("function", functionVo);
		}
    	//将图标列表传到页面10
    	List<TmIconEntity> iconlist = tmFunctionService.findByProperty(TmIconEntity.class, "iconType", 10);
    	request.setAttribute("iconlist", iconlist);
    	
        return new ModelAndView("com/biz/eisp/mdm/function/functionForm");
    }
	
    /**
     * 菜单列表请求.
     * <p>菜单datagrid请求方法
     * @param request 请求对象
     * @param treegrid 树对象
     * @return 树json模型
     */
    @RequestMapping(value = "functionGrid", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public List<TreeGrid> functionGrid(HttpServletRequest request, TreeGrid treegrid) {
        return  tmFunctionService.getFunctionsList(request, treegrid);
    }
    
	/**
	 * 菜单树型下拉列表
	 * @param request 请求对象
	 * @param comboTree 树型下拉列表对象
	 * @return 树型下拉列表集合
	 */
	@RequestMapping(value = "getFunctionTree", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public List<ComboTree> getFunctionTree(HttpServletRequest request,
			ComboTree comboTree) {
		return tmFunctionService.getFunctionForComboTree(request, comboTree);
	}
	
	/**
	 * 保存菜单信息
	 * @param request 请求对象
	 * @param response 响应对象
	 * @param function 菜单记录对象
	 */
	@RequestMapping(value = "saveFunction", method = {RequestMethod.GET, RequestMethod.POST})
	public void saveFunction(HttpServletRequest request,HttpServletResponse response,TmFunctionVo functionVo){
		try {
			//保存 更新
			tmFunctionService.saveFunction(functionVo);
			//更新菜单等级
			tmFunctionService.updateFuntionLevel();
		} catch (Exception e) {
			e.printStackTrace();
			this.message="操作失败，请联系开发人员！";
		}
		sendResponse(response);
	}
	
	/**
	 * 删除菜单信息
	 * @param request 请求对象
	 * @param response 响应对象
	 * @param function 菜单记录对象
	 */
	@RequestMapping(value = "deleteFunction", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public JSONObject deleteFunction(HttpServletRequest request,HttpServletResponse response,String functionId){
		try {
			tmFunctionService.deleteFunction(functionId);
		} catch (Exception e) {
			e.printStackTrace();
			this.message="操作失败，请联系开发人员！";
		}
		return returnJson();
	}
}
