package com.biz.eisp.mdm.function.dao;

import java.util.List;

import com.biz.eisp.mdm.function.entity.TmFunctionEntity;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;
/**
 * 菜单持久层.
 * <p>菜单相关方法的数据库操作
 * @author grover
 * @version v1.0
 */
@InterfaceDao
public interface TmFuncionDao {
	/**
	 * 获取菜单树
	 * @param selfId 当前id
	 * @param id 父id
	 * @return 菜单集合	
	 */
	@Arguments({"selfId","id"})
	@ResultType(TmFunctionEntity.class)
	public List<TmFunctionEntity> getFunctionsByTree(String selfId, String id);
}
