package com.biz.eisp.mdm.function.entity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.mdm.icon.entity.TmIconEntity;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

/**
 * 系统菜单实体.
 * @author grover
 * @version v1.0
 */
@Entity
@Table(name = "tm_function")
@org.hibernate.annotations.Proxy(lazy = false)
@JsonIgnoreProperties(value={"hibernateLazyInitializer"})
public class TmFunctionEntity extends IdEntity implements java.io.Serializable {
	private static final long serialVersionUID = 1L;
	
	/**
	 * 菜单名称
	 */
	private String functionName;
	/**
	 * 菜单等级
	 */
	private Short functionLevel;
	/**
	 * 菜单地址
	 */
	private String functionUrl;
	/**
	 * 菜单排序
	 */
	private Integer functionOrder;
	/**
	 * 创建时间
	 */
	private java.util.Date createDate;
	/**
	 * 创建人名称
	 */
	private java.lang.String createName;
	/**
	 * 修改时间
	 */
	private java.util.Date updateDate;
	/**
	 * 修改人名称
	 */
	private java.lang.String updateName;
	/**
	 * 菜单名称拼音简写
	 */
	private java.lang.String headString;
	
	/**
	 * 状态 0删除 1正常
	 */
	private Integer status;
	/**
	 * 父菜单
	 */
	private TmFunctionEntity tmFunction;
	/**
	 * 图标
	 */
	private TmIconEntity tmIcon;
	/**
	 * 下级菜单
	 */
	private List<TmFunctionEntity> tmFunctionList = new ArrayList<TmFunctionEntity>();

	/**
	 * 状态 0系统 1手机
	 */
	private Integer isSystem;


	
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  创建时间
	 */
	@Column(name ="create_date",nullable=true)
	public java.util.Date getCreateDate(){
		return this.createDate;
	}
	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  创建时间
	 */
	public void setCreateDate(java.util.Date createDate){
		this.createDate = createDate;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  创建人名称
	 */
	@Column(name ="create_name",nullable=true,length=32)
	public java.lang.String getCreateName(){
		return this.createName;
	}
	/**
	 *方法: 取得java.lang.Integer
	 *@return: java.lang.Integer 状态
	 */
	@Column(name = "status")
	public Integer getStatus() {
		return status;
	}
	/**
	 *方法: 设置java.lang.Integer
	 *@param: java.lang.Integer 状态
	 */
	public void setStatus(Integer status) {
		this.status = status;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  创建人名称
	 */
	public void setCreateName(java.lang.String createName){
		this.createName = createName;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  修改时间
	 */
	@Column(name ="update_date",nullable=true)
	public java.util.Date getUpdateDate(){
		return this.updateDate;
	}

	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  修改时间
	 */
	public void setUpdateDate(java.util.Date updateDate){
		this.updateDate = updateDate;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  修改人名称
	 */
	@Column(name ="update_name",nullable=true)
	public java.lang.String getUpdateName(){
		return this.updateName;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  修改人名称
	 */
	public void setUpdateName(java.lang.String updateName){
		this.updateName = updateName;
	}
	
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 菜单名称
	 */
	@Column(name = "function_name", nullable = false)
	public String getFunctionName() {
		return this.functionName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String 菜单名称
	 */
	public void setFunctionName(String functionName) {
		this.functionName = functionName;
	}
	/**
	 *方法: 取得 java.lang.Short
	 *@return: java.lang.Short 菜单级别
	 */
	@Column(name = "function_level")
	public Short getFunctionLevel() {
		return this.functionLevel;
	}
	/**
	 *方法: 设置java.lang.Short
	 *@param: java.lang.Short 菜单级别
	 */
	public void setFunctionLevel(Short functionLevel) {
		this.functionLevel = functionLevel;
	}
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 菜单url
	 */
	@Column(name = "function_url")
	public String getFunctionUrl() {
		return this.functionUrl;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String 菜单url
	 */
	public void setFunctionUrl(String functionUrl) {
		this.functionUrl = functionUrl;
	}
	/**
	 *方法: 取得 java.lang.Integer
	 *@return: java.lang.Integer 菜单排序
	 */
	@Column(name = "function_order")
	public Integer getFunctionOrder() {
		return functionOrder;
	}
	/**
	 *方法: 设置java.lang.Integer
	 *@param: java.lang.Integer 菜单排序
	 */
	public void setFunctionOrder(Integer functionOrder) {
		this.functionOrder = functionOrder;
	}
	
	/**
	 *方法: 取得 java.lang.Short
	 *@return: java.lang.Short 名称拼音简写
	 */
	@Column(name = "headstring")
	public java.lang.String getHeadString() {
		return headString;
	}
	/**
	 *方法: 设置 java.lang.String
	 *@param: java.lang.String 名称拼音简写
	 */
	public void setHeadString(java.lang.String headString) {
		this.headString = headString;
	}
	/**
	 *方法: 取得 java.lang.boolean
	 *@return: java.lang.boolean 是否有上级
	 */
	public boolean hasSubFunction(Map<Integer, List<TmFunctionEntity>> map) {
		if(map.containsKey(this.getFunctionLevel()+1)){
			return hasSubFunction(map.get(this.getFunctionLevel()+1));
		}
		return false;
	}
	/**
	 *方法: 设置 java.lang.boolean
	 *@param: java.lang.boolean 是否有上级
	 */
	public boolean hasSubFunction(List<TmFunctionEntity> functions) {
		for (TmFunctionEntity f : functions) {
			if(f.getTmFunction().getId().equals(this.getId())){
				return true;
			}
		}
		return false;
	}
	/**
	 *方法: 取得 com.biz.eisp.mdm.icon.entity.TmIconEntity
	 *@return: com.biz.eisp.mdm.icon.entity.TmIconEntity 图标
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "icon_id")
	public TmIconEntity getTmIcon() {
		return tmIcon;
	}
	/**
	 *方法: 设置 com.biz.eisp.mdm.icon.entity.TmIconEntity 图标
	 *@param: com.biz.eisp.mdm.icon.entity.TmIconEntity 图标
	 */
	public void setTmIcon(TmIconEntity tmIcon) {
		this.tmIcon = tmIcon;
	}
	/**
	 *方法: 取得 com.biz.eisp.mdm.function.entity.TmFunctionEntity
	 *@return: com.biz.eisp.mdm.function.entity.TmFunctionEntity 父级菜单
	 */
    @ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "parent_id")
	public TmFunctionEntity getTmFunction() {
		return this.tmFunction;
	}
    /**
	 *方法: 设置com.biz.eisp.mdm.function.entity.TmFunctionEntity
	 *@param: com.biz.eisp.mdm.function.entity.TmFunctionEntity 父级菜单
	 */
	public void setTmFunction(TmFunctionEntity tmFunction) {
		this.tmFunction = tmFunction;
	}
	/**
	 *方法: 取得 com.biz.eisp.mdm.function.entity.TmFunctionEntity
	 *@return: com.biz.eisp.mdm.function.entity.TmFunctionEntity 下级菜单集合
	 */
	@Fetch(FetchMode.SUBSELECT)
	@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER, mappedBy = "tmFunction")
	public List<TmFunctionEntity> getTmFunctionList() {
		return tmFunctionList;
	}
	/**
	 *方法: 设置 com.biz.eisp.mdm.function.entity.TmFunctionEntity
	 *@param: com.biz.eisp.mdm.function.entity.TmFunctionEntity 下级菜单集合
	 */
	public void setTmFunctionList(List<TmFunctionEntity> tmFunctionList) {
		this.tmFunctionList = tmFunctionList;
	}

	@Column(name = "is_system")
	public Integer getIsSystem() {
		return isSystem;
	}

	public void setIsSystem(Integer isSystem) {
		this.isSystem = isSystem;
	}
}
