package com.biz.eisp.mdm.function.service;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import com.biz.eisp.mdm.function.vo.TmFunctionVo;
import com.biz.eisp.mdm.role.vo.TmRoleFunctionVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
/**
 * 菜单权限接口.
 * <p>菜单权限的相关方法
 * @author grover
 * @version v1.0
 */
public interface MenuPermissionService {
	/**
	 * 获取菜单权限.
	 * <p>根据用户获取菜单权限的方法.
	 * @author grover
	 * @param tmUserEntity 用户对象
	 * @return 菜单权限集合
	 */
	public List<TmFunctionVo> getFunctionsByUser(TmUserEntity tmUserEntity);
	/**
	 * 获取用户是否有访问菜单权限.
	 * <p>根据请求和用户获取菜单权限.使用请求获取到会话信息，<br>
	 * 然后获取用户并查询菜单权限.
	 * @param request 请求对象
	 * @param tmUserEntity 用户对象
	 * @return 是否有权限 true有 false无
	 */
	public boolean getFunctionsByRequest(HttpServletRequest request,TmUserEntity tmUserEntity);
	/**
	 * 获取按钮权限.
	 * <p>根据请求和用户获取按钮权限.使用请求获取到会话信息，<br>
	 * 然后获取用户并查询系统按钮权限
	 * @author grover
	 * @param request 请求对象
	 * @param tmUserEntity 用户对象
	 * @return 角色权限菜单集合
	 */
	List<TmRoleFunctionVo> getOperationsByRequest(HttpServletRequest request,TmUserEntity tmUserEntity);
	/**
	 * 获取菜单数据权限配置.
	 * @author grover
	 * @param request 请求对象
	 * @param roleFunctionVos 角色菜单集合
	 */
	void getDataRuleByRequest(HttpServletRequest request, List<TmRoleFunctionVo> roleFunctionVos);
}
