package com.biz.eisp.mdm.function.service;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.TreeGrid;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.authobj.vo.TmFunctionAuthVo;
import com.biz.eisp.mdm.function.vo.TmFunctionVo;
import com.biz.eisp.mdm.operation.entity.TmOperationEntity;
/**
 * 菜单接口.
 * <p>菜单相关方法
 * @author grover
 * @version v1.0
 */
public interface TmFunctionService extends BaseService{
	
	/**
	 * 获取菜单信息.
	 * @param request 请求对象
	 * @param treeGrid 树对象
	 * @return 菜单信息集合.
	 */
	List<TreeGrid> getFunctionsList(HttpServletRequest request,TreeGrid treeGrid);
	
	/**
	 * 获取菜单comboTree
	 * @param request
	 * @param comboTree
	 * @return comboTree集合
	 */
	List<ComboTree> getFunctionForComboTree(HttpServletRequest request,ComboTree comboTree);
	/**
	 * 获取所有菜单并且处理选中
	 * @param request 请求对象
	 * @param comboTree 树对象
	 * @param roleId 角色
	 * @return 菜单集合
	 */
	List<ComboTree> getAllFuncAndHandleCheck(HttpServletRequest request,ComboTree comboTree,String roleId);
	/**
	 * 保存菜单
	 * @param function
	 */
	public void saveFunction(TmFunctionVo tmFunctionVo);
	/**
	 * 更新菜单等级.
	 * @author grover
	 */
	void updateFuntionLevel();
	
	/**
	 * 删除菜单
	 * @param function
	 */
	public void deleteFunction(String functionId) throws Exception;
	/**
	 * 获取所有菜单的按钮
	 * @param request 请求对象
	 * @param comboTree 树对象
	 * @param roleId 角色
	 * @return 菜单集合
	 */
	List<TmOperationEntity> getOptByRoleFunc(String roleId, String funcId);
	/**
	 * 删除某一角色之前存在的菜单并且现在移除的菜单关系.
	 * @author grover
	 * @param roleId 角色id
	 * @param funcIds 菜单集合ids
	 */
	void delExistFuncRole(String roleId, String funcIds);
	/**
	 * 设置角色菜单权限.
	 * <p>设置对应角色菜单的权限接口.
	 * @author grover
	 * @param roleId 角色id
	 * @param funcIds 菜单集合ids
	 */
	void setFuncRole(String roleId, String funcIds);
	/**
	 * 设置按钮权限.
	 * <p>设置对应角色菜单的按钮接口
	 * @author grover
	 * @param opretionIds 按钮ids
	 * @param roleId 角色id
	 * @param funcId 菜单id
	 */
	void setOperateByFuncRole(String opretionIds, String roleId, String funcId);
	/**
	 * 获取权限对象.
	 * <p>通过菜单角色获取权限对象接口
	 * @author grover
	 * @param roleId 角色id
	 * @param funcId 菜单id
	 * @return 权限对象集合 
	 */
	@SuppressWarnings("deprecation")
	List<TmFunctionAuthVo> getAuthObjByFunc(String roleId, String funcId);
}
