package com.biz.eisp.mdm.function.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.utils.SysConfigUtils;
import com.biz.eisp.mdm.function.service.MenuPermissionExtendsService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.authobj.entity.TmRoleFuncAuthobjEntity;
import com.biz.eisp.mdm.function.entity.TmFunctionEntity;
import com.biz.eisp.mdm.function.service.MenuPermissionService;
import com.biz.eisp.mdm.function.vo.TmFunctionVo;
import com.biz.eisp.mdm.operation.entity.TmOperationEntity;
import com.biz.eisp.mdm.role.vo.TmRoleFunctionVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.web.pojo.Client;

/**
 * 权限接口实现.
 * @author grover
 * @version v1.0
 */
@Service("menuPermissionService")
@Transactional
public class MenuPermissionServiceImpl extends BaseServiceImpl implements MenuPermissionService {

	@Autowired(required=false)
	private MenuPermissionExtendsService menuPermissionExtendsService;

	@Autowired
	private SysConfigUtils sysConfigUtils;
	/**
	 * 获取菜单权限.
	 * <p>根据用户获取菜单权限的实现方法.
	 * @param tmUserEntity 用户对象
	 * @return 菜单权限集合
	 */
	@Override
	public List<TmFunctionVo> getFunctionsByUser(TmUserEntity tmUserEntity) {
		boolean b=false;
		//String useType=ResourceUtil.getSysConfigProperty("useType");
		String useType=sysConfigUtils.getUseType();
		if (StringUtils.isNotBlank(useType)&&useType.equals("Y"))
			b=true;
		//返回集合
		List<TmFunctionVo> returnFunctions = new ArrayList<TmFunctionVo>();
		//不同用户类型 不同菜单菜单查询逻辑
		if(Globals.ENTERPRISE_USER==tmUserEntity.getUserType().intValue()){
			//企业用户菜单
			List<TmFunctionVo> tmFunctions = enterPriseTmFunctions(tmUserEntity);
			//set转换list
			returnFunctions.addAll(tmFunctions);
		}else if(Globals.CUST_USER==tmUserEntity.getUserType().intValue()&&!b){
			//经销商用户菜单
			List<TmFunctionVo> tmFunctions = custTmFunctions(tmUserEntity);
			//set转换list
			returnFunctions.addAll(tmFunctions);
		}else if(Globals.OTHER_USER==tmUserEntity.getUserType().intValue()||b){
			if(menuPermissionExtendsService!=null){
				//其他用户加载菜单
				List<TmFunctionVo> tmFunctions = menuPermissionExtendsService.findFunctionList(tmUserEntity);
				//set转换list
				returnFunctions.addAll(tmFunctions);
			}
		}else{
			return returnFunctions;
		}
		
		return returnFunctions;
	}
	
	/**
	 * 经销商用户菜单.
	 * <p>当前登录人属于经销商用户类型的菜单
	 * @author grover
	 * @param tmUserEntity 用户对象
	 * @return 经销商用户菜单集合
	 */
	private List<TmFunctionVo> custTmFunctions(TmUserEntity tmUserEntity) {
		//获取用户与角色的关系
		String custFunctionsSql = "SELECT DISTINCT TF.*,TI.ICONCLAS AS ICONCLAS,TI.PATH AS ICONPATH,(SELECT COUNT(1) FROM TM_FUNCTION WHERE PARENT_ID=TF.ID) AS HAVELEVEL"
								+" FROM TM_USER TU JOIN TM_R_USER_ROLE TUR ON TU.ID=TUR.USER_ID"
								+" JOIN TM_ROLE TM ON TUR.ROLE_ID=TM.ID"
								+" JOIN TM_R_ROLE_FUNCTION TRF ON TRF.ROLE_ID=TM.ID"
								+" JOIN TM_FUNCTION TF ON TF.ID=TRF.FUNCTION_ID"
								+" LEFT JOIN TM_ICON TI ON TI.ID=TF.ICON_ID"
								+" WHERE TF.is_system<>1 and TU.ID=? ORDER BY TF.FUNCTION_LEVEL ASC";
		
		List<TmFunctionVo> tfs = super.findBySql(TmFunctionVo.class, custFunctionsSql, tmUserEntity.getId());
		return tfs;
	}
	/**
	 * 企业用户菜单.
	 * <p>当前登录人类型属于企业用户时的菜单
	 * @author grover
	 * @param tmUserEntity 用户对象
	 * @return 企业用户菜单集合
	 */
	private List<TmFunctionVo> enterPriseTmFunctions(
			TmUserEntity tmUserEntity) {
		//权限集合
		String menuSql = "SELECT DISTINCT TF.*,TI.ICONCLAS AS ICONCLAS,TI.PATH AS ICONPATH,(SELECT COUNT(1) FROM TM_FUNCTION WHERE PARENT_ID=TF.ID) AS HAVELEVEL"
						+" FROM TM_FUNCTION TF JOIN TM_R_ROLE_FUNCTION TRF ON TF.ID=TRF.FUNCTION_ID"
						+" JOIN TM_ROLE TR ON TRF.ROLE_ID=TR.ID JOIN TM_R_POSITION_ROLE TRPR ON TR.ID=TRPR.ROLE_ID"
						+" JOIN TM_R_USER_POSITION TUP ON TUP.IS_MAIN = 0 AND TUP.POSITION_ID=TRPR.POSITION_ID"
						+" JOIN TM_USER TU ON TUP.USER_ID=TU.ID"
						+" LEFT JOIN TM_ICON TI ON TI.ID=TF.ICON_ID"
						+" WHERE TF.is_system<>1 and TU.ID=? ORDER BY TF.FUNCTION_LEVEL ASC";
		List<TmFunctionVo> tfs = super.findBySql(TmFunctionVo.class,
				menuSql, tmUserEntity.getId());
		return tfs;
	}
	/**
	 * 封装菜单vo成树形.
	 * @author grover 
	 * @param nodeList 树形结构菜单vo集合
	 * @param tfs 菜单列表
	 */
	private void packageMenu(List<TmFunctionVo> nodeList, List<TmFunctionVo> tfs) {
		if(CollectionUtil.listNotEmptyNotSizeZero(tfs)) {
			//封装权限
			for(TmFunctionVo node : tfs){  
			    recursiveSub(nodeList, node);  
			    if(StringUtil.isEmpty(node.getParentId())){  
			        nodeList.add(node);   
			    }  
			} 
		}
	}
	/**
	 * 递归处理下级.
	 * @author grover
	 * @param nodeList 树形结构菜单vo集合
	 * @param handleFunction 待处理的vo
	 */
	private void recursiveSub(List<TmFunctionVo> nodeList, TmFunctionVo handleFunction) {
		boolean mark = false;
		for (TmFunctionVo tmFunctionVo : nodeList) {
			if (StringUtil.isNotEmpty(handleFunction.getParentId())
					&& handleFunction.getParentId().equals(tmFunctionVo.getId())) {
				if (CollectionUtil.listEmpty(tmFunctionVo.getFunctionVos())) {
					tmFunctionVo.setFunctionVos(new ArrayList<TmFunctionVo>());
				}
				tmFunctionVo.getFunctionVos().add(handleFunction);
				mark = true;
				break;
			}
		}
		// 如果该菜单不是在根菜单下 则递归继续处理
		for (TmFunctionVo tmFunctionVo : nodeList) {
			if (!mark && StringUtil.isNotEmpty(handleFunction.getParentId())
					  && CollectionUtil.listNotEmptyNotSizeZero(tmFunctionVo.getFunctionVos())) {
				recursiveSub(tmFunctionVo.getFunctionVos(), handleFunction);
			}
		}
	}
	
	/**
	 * 获取用户是否有访问菜单的权限.
	 * <p>根据请求和用户获取菜单权限的实现方法.<br>
	 * @param request 请求对象
	 * @param tmUserEntity 用户对象
	 * @return 是否有权限
	 */
	@Override
	public boolean getFunctionsByRequest(
			HttpServletRequest request,TmUserEntity tmUserEntity) {
		//默认有权限
		boolean isPermission = true;
		//访问url
		String reqUrl = ResourceConfigUtils.getRequestPath(request);
		reqUrl = "'"+reqUrl+"%'";
		//请求是否在管理的权限表中
		String isExistSql = "SELECT COUNT(1) FROM TM_FUNCTION WHERE FUNCTION_URL LIKE "+reqUrl;
		long isExistCount = getCountForJdbcParam(isExistSql);
		//在配置表中有则检查是否有权限 没有则不验证
		if(isExistCount > 0){
			//该角色是否有权限
			String isPermissionSql = "SELECT COUNT(1) FROM TM_FUNCTION TF JOIN TM_R_ROLE_FUNCTION TRF ON TF.ID=TRF.FUNCTION_ID"
						+" JOIN TM_ROLE TR ON TRF.ROLE_ID=TR.ID JOIN TM_R_POSITION_ROLE TRPR ON TR.ID=TRPR.ROLE_ID"
						+" JOIN TM_R_USER_POSITION TUP ON TUP.POSITION_ID=TRPR.POSITION_ID"
						+" JOIN TM_USER TU ON TUP.USER_ID=TU.ID WHERE TF.FUNCTION_URL LIKE "+reqUrl+" AND TU.ID=?";
			long isPermissionCount = getCountForJdbcParam(isPermissionSql, tmUserEntity.getId());
			if(isPermissionCount == 0) {
				isPermission = false;
			}
		}
		return isPermission;
	}
	/**
	 * 获取按钮权限.
	 * <p>根据请求和用户获取按钮权限的实现方法.<br>
	 * 使用请求获取到会话信息，然后获取用户并查询系统按钮权限
	 * @param request 请求对象
	 * @param tmUserEntity 用户对象
	 * @return 角色权限菜单集合
	 */
	@Override
	public List<TmRoleFunctionVo> getOperationsByRequest(
			HttpServletRequest request,TmUserEntity tmUserEntity) {
		//请求url
		String reqUrl = ResourceConfigUtils.getRequestPath(request);
		//获取菜单访问权限集合
		String sql = "SELECT TRF.FUNCTION_ID functionId,TRF.ROLE_ID roleId, to_char(listagg(trf.operation,',') within GROUP (order by trf.operation)) AS operation FROM TM_FUNCTION TF JOIN TM_R_ROLE_FUNCTION TRF ON TF.ID=TRF.FUNCTION_ID"
				+" JOIN TM_ROLE TR ON TRF.ROLE_ID=TR.ID JOIN TM_R_POSITION_ROLE TRPR ON TR.ID=TRPR.ROLE_ID"
				+" JOIN TM_R_USER_POSITION TUP ON TUP.POSITION_ID=TRPR.POSITION_ID AND tup.is_main = 0"
				+" JOIN TM_USER TU ON TUP.USER_ID=TU.ID"
				+" WHERE TF.FUNCTION_URL LIKE '"+reqUrl+"%' AND TU.ID=? GROUP BY TRF.FUNCTION_ID,TRF.ROLE_ID";
		List<TmRoleFunctionVo> tmRoleFunctions = super.findBySql(TmRoleFunctionVo.class,sql,tmUserEntity.getId());
		//根据权限获取按钮code
		if(tmRoleFunctions!=null && tmRoleFunctions.size()>0){
			StringBuffer operateIdBuffer = new StringBuffer();
			//菜单vo
			TmRoleFunctionVo roleFunctionVo = tmRoleFunctions.get(0);
			//权限按钮ids
			String operateIds = "";
			for (TmRoleFunctionVo tmRoleFunctionVo : tmRoleFunctions) {
				if(StringUtil.isNotEmpty(operateIds)){
					operateIds += ",";
				}
				operateIds += tmRoleFunctionVo.getOperation();
			}
			//封装按钮查询条件
			if(StringUtils.isNotEmpty(operateIds)){
				String[] operates = operateIds.split(",");
				for (String operatId : operates) {
					if(operateIdBuffer.length()>0){
						operateIdBuffer.append(",");
					}
					operateIdBuffer.append("'").append(operatId).append("'");
				}
			}else{
				operateIdBuffer.append("'-1'");
			}
			//查询按钮信息
			String hql="FROM TmOperationEntity WHERE id IN ("+operateIdBuffer+")";
			List<TmOperationEntity> list = super.findByHql(hql);
			//1.有权限的集合
			request.setAttribute(Globals.Yes_Operation_Codes, list);
			//2.无权限的集合
			hql = "FROM TmOperationEntity WHERE tmFunction.id=? AND id NOT IN ("+operateIdBuffer+")";
			List<TmOperationEntity> noPerlist = super.findByHql(hql,
					roleFunctionVo.getFunctionId());
			request.setAttribute(Globals.No_Operation_Codes, noPerlist);
		}
		return tmRoleFunctions;
	}

	@Override
	public void getDataRuleByRequest(HttpServletRequest request,
			List<TmRoleFunctionVo> roleFunctionVos) {
		//返回容器
		Map<String, String> returnMap = new HashMap<String, String>();
		//获取对象和对象值集合
		if(CollectionUtil.listNotEmptyNotSizeZero(roleFunctionVos)){
			TmRoleFunctionVo roleFunctionVo =  roleFunctionVos.get(0);
			//获取对象和值
			String sql = "SELECT TRRFA.* FROM TM_R_ROLE_FUNC_AUTHOBJ TRRFA"
						+" JOIN TM_R_ROLE_FUNCTION TRRF ON TRRF.ID=TRRFA.ROLE_FUNCTION_ID"
						+" WHERE TRRF.FUNCTION_ID=? AND TRRF.ROLE_ID=?";
			List<TmRoleFuncAuthobjEntity> list = this.findBySql(
					TmRoleFuncAuthobjEntity.class, sql,
					roleFunctionVo.getFunctionId(), roleFunctionVo.getRoleId());
			//封装返回
			if(CollectionUtil.listNotEmptyNotSizeZero(list)){
				for (TmRoleFuncAuthobjEntity roleFuncAuthobjEntity : list) {
					if(returnMap.containsKey(roleFuncAuthobjEntity.getAuthobj())){
						String authObjValue = returnMap.get(roleFuncAuthobjEntity.getAuthobj());
						if(StringUtil.isNotEmpty(authObjValue)){
							authObjValue += ","+roleFuncAuthobjEntity.getAuthobjValue(); 
						}
						returnMap.put(roleFuncAuthobjEntity.getAuthobj(), authObjValue);
					}else{
						returnMap.put(roleFuncAuthobjEntity.getAuthobj(),
								roleFuncAuthobjEntity.getAuthobjValue());
					}
				}
			}
			//添加权限对象
			String functionId=roleFunctionVo.getFunctionId();
			if(roleFunctionVo!=null&&
					StringUtil.isNotEmpty(functionId)){

				Client client = ResourceConfigUtils.getClient();
				List<Map<String, Map<String, String>>> authObjList=client.getAuthObjList()==null
						?new ArrayList<Map<String, Map<String, String>>>():client.getAuthObjList();
						
				//权限对象特殊处理标识		
				TmFunctionEntity functionEntity=this.get(TmFunctionEntity.class, functionId);
				if(functionEntity!=null){
					String fucntionName=functionEntity.getFunctionName();
					if(StringUtil.isNotEmpty(fucntionName)&&
							(StringUtil.equals(fucntionName, Globals.FUNCTION_CUSTOMER)
									||StringUtil.equals(fucntionName, Globals.FUNCTION_TERMINAL))){
						Map<String, String> authMap=(Map<String, String>) (client.getObj()==null
								?new HashMap<String,String>():client.getObj());
						authMap.put(functionId, fucntionName);
						client.setObj(authMap);
					}
				}
				
				//判断权限值是否存在
				if(authObjList!=null&&authObjList.size()>0){
					for(Map<String, Map<String, String>> map:authObjList){
						map.put(functionId, returnMap);
					}
				}else{
					Map<String, Map<String, String>> authMap=new HashMap<String, Map<String, String>>();
					authMap.put(functionId, returnMap);
					authObjList.add(authMap);
					client.setAuthObjList(authObjList);
					ResourceConfigUtils.setClient(client);
				}
			}
		}
	}
}
