package com.biz.eisp.mdm.function.service.impl;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import oracle.security.o5logon.a;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.TreeGrid;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.tag.bean.TreeGridModel;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.authobj.entity.TmFunAuthEntity;
import com.biz.eisp.mdm.authobj.service.TmFunAuthService;
import com.biz.eisp.mdm.authobj.transform.TmFuncAuthTransForm;
import com.biz.eisp.mdm.authobj.vo.TmFunctionAuthVo;
import com.biz.eisp.mdm.function.dao.TmFuncionDao;
import com.biz.eisp.mdm.function.entity.TmFunctionEntity;
import com.biz.eisp.mdm.function.service.TmFunctionService;
import com.biz.eisp.mdm.function.transformer.TmFunctionVoToTmFunctionEntity;
import com.biz.eisp.mdm.function.vo.TmFunctionVo;
import com.biz.eisp.mdm.icon.entity.TmIconEntity;
import com.biz.eisp.mdm.operation.entity.TmOperationEntity;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.biz.eisp.mdm.role.entity.TmRoleFunctionEntity;
import com.google.common.collect.Lists;
/**
 * 菜单接口实现.
 * @author grover
 * @version v1.0
 */
@Service("tmFunctionService")
@Transactional
public class TmFunctionServiceImpl extends BaseServiceImpl implements TmFunctionService {
	/**
	 * 注入权限对象service
	 */
	@Autowired
	private TmFunAuthService tmFunAuthService;
	
	/**
	 * 注入菜单dao实现
	 */
	@Autowired
	private TmFuncionDao tmFuncionDao;
	
	@Override
	public  List<TreeGrid> getFunctionsList(HttpServletRequest request,
			TreeGrid treeGrid) {
        String selfId = request.getParameter("selfId");
    	List<TmFunctionEntity> functionList=new ArrayList();
        if(StringUtil.isNotEmpty(selfId)){
        	functionList=this.findByPropertyisOrder(TmFunctionEntity.class, "id", selfId,true,"functionOrder");
        }
        if(StringUtil.isNotEmpty(treeGrid.getId())){
        	functionList=this.findByPropertyisOrder(TmFunctionEntity.class, "tmFunction.id", treeGrid.getId(),true,"functionOrder");
        }else{
        	Criterion cr=Restrictions.isNull("tmFunction.id");
        	functionList=this.findByCriteria(TmFunctionEntity.class, cr);
        }
		return this.treeGridModel(functionList);
	}

	/**
	 *拼装TreeGrid模型
	 * @param functionList 菜单集合
	 * @return TreeGrid集合
	 */
	private List<TreeGrid> treeGridModel(List<TmFunctionEntity> functionList){
		//拼装模型
        List<TreeGrid> treeGrids = new ArrayList<TreeGrid>();
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setTextField("functionName");
        treeGridModel.setParentText("tmFunction_functionName");
        treeGridModel.setParentId("tmFunction_id");
        treeGridModel.setSrc("functionUrl");
        treeGridModel.setIdField("id");
        treeGridModel.setChildList("tmFunctionList");
		treeGridModel.setIcon("tmIcon_iconPath");
        // 添加排序字段
        treeGridModel.setOrder("functionOrder");
        treeGrids = this.treegrid(functionList, treeGridModel);
        return treeGrids;
	}

	@Override
	public List<ComboTree> getFunctionForComboTree(HttpServletRequest request, ComboTree comboTree) {
		 String selfId = request.getParameter("selfId");
	    	List<TmFunctionEntity> functionList=new ArrayList();
	        if(StringUtil.isNotEmpty(selfId)){
	        	functionList=this.findByProperty(TmFunctionEntity.class, "id", selfId);
	        }
	        if(StringUtil.isNotEmpty(comboTree.getId())){
	        	functionList=this.findByProperty(TmFunctionEntity.class, "tmFunction.id", comboTree.getId());
	        }else{
	        	Criterion cr=Restrictions.isNull("tmFunction.id");
	        	functionList=this.findByCriteria(TmFunctionEntity.class, cr);
	        }
	    	List<ComboTree> comboTrees = new ArrayList<ComboTree>();
			ComboTreeModel comboTreeModel = new ComboTreeModel("id",
					"functionName", "tmFunctionList");
			comboTrees = this.comboTree(functionList, comboTreeModel,
					null, false);
			return comboTrees;
	}

	@Override
	public void deleteFunction(String functionId)  throws Exception{
		try {
			TmFunctionEntity function = this.get(TmFunctionEntity.class, functionId);
			List<TmFunAuthEntity>  funAuthList=
					findByProperty(TmFunAuthEntity.class, "tmFunction.id", functionId);
			
			this.deleteAllEntity(funAuthList);
			
			List<TmRoleFunctionEntity> roleFunList=
					findByProperty(TmRoleFunctionEntity.class, "tmFunction.id", functionId);
			
			this.deleteAllEntity(roleFunList);
			
			this.delete(function);
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
	}

	@Override
	public void saveFunction(TmFunctionVo tmFunctionVo) {
		TmFunctionEntity tmFunction=
				new TmFunctionVoToTmFunctionEntity(this).apply(tmFunctionVo);
		if(StringUtil.isNotEmpty(tmFunctionVo.getIconId())){
			TmIconEntity iconEntity=this.get(TmIconEntity.class, tmFunctionVo.getIconId());
			tmFunction.setTmIcon(iconEntity);
		}
		this.saveOrUpdate(tmFunction);
	}
	
	@Override
	public List<ComboTree> getAllFuncAndHandleCheck(
			HttpServletRequest request, ComboTree comboTree,String roleId) {
		//选中的id
		String selfId = request.getParameter("selfId");
		//所有的菜单
    	List<TmFunctionEntity> functionList=new ArrayList<TmFunctionEntity>();
    	//选中的菜单集合
    	List<TmFunctionEntity> inFunctionList=new ArrayList<TmFunctionEntity>();
    	//处理所有菜单
        if(StringUtil.isNotEmpty(selfId)){
        	functionList=this.findByProperty(TmFunctionEntity.class, "id", selfId);
        }
        if(StringUtil.isNotEmpty(comboTree.getId())){
        	functionList=this.findByProperty(TmFunctionEntity.class, "tmFunction.id", comboTree.getId());
        }else{
        	Criterion cr=Restrictions.isNull("tmFunction.id");
        	functionList=this.findByCriteria(TmFunctionEntity.class, cr);
        }
        //处理已经有权限的菜单
        List<TmRoleFunctionEntity> list = super.findByProperty(
        		TmRoleFunctionEntity.class, "tmRole.id", roleId);
        if(list != null && list.size() > 0){
        	for (TmRoleFunctionEntity tmRoleFunctionEntity : list) {
        		inFunctionList.add(tmRoleFunctionEntity.getTmFunction());
			}
        }
        //tree模型
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "functionName", "tmFunctionList");
        //树json封装
        List<ComboTree> comboTrees = super.comboTree(functionList, comboTreeModel, inFunctionList, true);
		return comboTrees;
	}

	@Override
	public List<TmOperationEntity> getOptByRoleFunc(String roleId, String funcId) {
		//step1:查询所属菜单的所有按钮
		List<TmOperationEntity> allOptByFuncs = 
				this.findByProperty(TmOperationEntity.class, "tmFunction.id", funcId);
		//step2:查询有权限的按钮
    	//查询角色和菜单的关系
    	Criterion funcCrt = Restrictions.eq("tmFunction.id", funcId);
    	Criterion roleCrt = Restrictions.eq("tmRole.id", roleId);
    	List<TmRoleFunctionEntity> tmRoleFunctions = this
    			.findByCriteria(TmRoleFunctionEntity.class, funcCrt, roleCrt);
    	//查询按钮集合
    	if(tmRoleFunctions != null && tmRoleFunctions.size() > 0){
    		//获取按钮codes
			String operations = tmRoleFunctions.get(0).getOperation();
    		if(allOptByFuncs.size() > 0){
    			for (TmOperationEntity tmOperationEntity : allOptByFuncs) {
    				//设置是否选中
					if(StringUtil.isNotEmpty(operations) && operations.contains(tmOperationEntity.getId())){
						tmOperationEntity.setStatus(String.valueOf(Globals.User_Normal));
					} else {
						tmOperationEntity.setStatus(String.valueOf(Globals.User_Forbidden));
					}
				}
    		}
    	}
		return allOptByFuncs;
	}

	@Override
	public void delExistFuncRole(String roleId, String funcIds) {
		//查询之前存在  现在不存在的关系数据
		List<TmRoleFunctionEntity> functions = null;
		Criterion cr1 = Restrictions.eq("tmRole.id", roleId);
		if(StringUtils.isNotBlank(funcIds)) {
			Criterion cr2 = Restrictions.not(Restrictions.in("tmFunction.id",funcIds.split(",")));
			functions = findByCriteria(TmRoleFunctionEntity.class, cr1, cr2);
		} else {
			functions = findByCriteria(TmRoleFunctionEntity.class, cr1);
		}
		 
		//删除现在不存在的关系
		if(CollectionUtil.listNotEmptyNotSizeZero(functions)){
			deleteAllEntity(functions);
		}
	}
	
	@Override
	public void setFuncRole(String roleId, String funcIds) {
		String alredyExistsFuncId = "";
		//查询已经有的关系
		List<TmRoleFunctionEntity> functions = null;
		Criterion cr1 = Restrictions.eq("tmRole.id", roleId);
		if(StringUtils.isNotBlank(funcIds)) {
			Criterion cr2 = Restrictions.in("tmFunction.id", funcIds.split(","));
			functions = findByCriteria(TmRoleFunctionEntity.class, cr1, cr2);
		} else {
			functions = findByCriteria(TmRoleFunctionEntity.class, cr1);
		}
		if(CollectionUtil.listNotEmptyNotSizeZero(functions)){
			for (TmRoleFunctionEntity tmRoleFunctionEntity : functions) {
				if(StringUtil.isNotEmpty(alredyExistsFuncId)){
					alredyExistsFuncId+=",";
				}
				alredyExistsFuncId+=tmRoleFunctionEntity.getTmFunction().getId();
			}
		}
		//先判断关系是否存在 不存在时才新增
		if(StringUtil.isNotEmpty(funcIds)){
			for (String funcId : funcIds.split(",")) {
				if (!(StringUtil.isNotEmpty(alredyExistsFuncId)
						&& alredyExistsFuncId.contains(funcId))) {
					//新增
					TmRoleFunctionEntity roleFunctionEntity = new TmRoleFunctionEntity();
					TmFunctionEntity tmFunction = new TmFunctionEntity();
					tmFunction.setId(funcId);
					roleFunctionEntity.setTmFunction(tmFunction);
					TmRoleEntity roleEntity = new TmRoleEntity();
					roleEntity.setId(roleId);
					roleFunctionEntity.setTmRole(roleEntity);
					save(roleFunctionEntity);
				}
			}
		}
	}

	@Override
	public void setOperateByFuncRole(String opretionIds, String roleId, String funcId) {
		//判断是否已经有数据
		Criterion roleCrt = Restrictions.eq("tmRole.id", roleId);
		Criterion funcCrt = Restrictions.eq("tmFunction.id", funcId);
		List<TmRoleFunctionEntity> roleFuncs =
				findByCriteria(TmRoleFunctionEntity.class, roleCrt, funcCrt);
		if(roleFuncs.size()==0){
			//新增
			TmRoleFunctionEntity tmRoleFunctionEntity = new TmRoleFunctionEntity();
			TmFunctionEntity tmFunctionEntity = new TmFunctionEntity();
			tmFunctionEntity.setId(funcId);
			tmRoleFunctionEntity.setTmFunction(tmFunctionEntity);
			TmRoleEntity tmRoleEntity = new TmRoleEntity();
			tmRoleEntity.setId(roleId);
			tmRoleFunctionEntity.setTmRole(tmRoleEntity);
			tmRoleFunctionEntity.setOperation(opretionIds);
			save(tmRoleFunctionEntity);
		}else{
			//修改
			if(StringUtil.isNotEmpty(roleFuncs) && roleFuncs.size() > 0){
				TmRoleFunctionEntity roleFunctionEntity = roleFuncs.get(0);
				roleFunctionEntity.setOperation(opretionIds);
				updateEntity(roleFunctionEntity);
			}
		}
	}

	@Override
	public List<TmFunctionAuthVo> getAuthObjByFunc(String roleId, String funcId) {
		//获取菜单拥有的权限对象
		List<TmFunAuthEntity> allAuthByFunc = tmFunAuthService.getTmFunAuthList(funcId);
		//获取角色所属菜单已经拥有的权限对象
		List<TmFunAuthEntity> partAuthByFunc = tmFunAuthService.getTmFunAuthListByRoleFunc(roleId, funcId);
		//转换
		List<TmFunctionAuthVo> allAuthByFuncVos = Lists.transform(allAuthByFunc, new TmFuncAuthTransForm(partAuthByFunc));
		return allAuthByFuncVos;
	}
	
	@Override
	public void updateFuntionLevel() {
		String sql="MERGE INTO TM_FUNCTION T1"
				  +" USING ( SELECT  T.ID, LEVEL-1 AS LV FROM TM_FUNCTION T"
				  +" WHERE 1=1 AND T.FUNCTION_LEVEL<>LEVEL-1"
				  +" START WITH T.PARENT_ID IS NULL"
				  +" CONNECT BY PRIOR T.ID = T.PARENT_ID"	
				  +") T2 ON (T1.ID=T2.ID)"
				  +" WHEN MATCHED THEN UPDATE SET T1.FUNCTION_LEVEL = T2.LV";
		executeSql(sql);
	}
}
