package com.biz.eisp.mdm.function.transformer;

import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.mdm.function.entity.TmFunctionEntity;
import com.biz.eisp.mdm.function.service.TmFunctionService;
import com.biz.eisp.mdm.function.vo.TmFunctionVo;
import com.biz.eisp.mdm.icon.entity.TmIconEntity;
import com.google.common.base.Function;

/** 
 * function vo转entity
 * @author 肖胜
 * @version v1.0
 */
public class TmFunctionEntityToTmFunctionVo implements Function< TmFunctionEntity,TmFunctionVo>{
	
	public TmFunctionEntityToTmFunctionVo(TmFunctionService functionService) {
		super();
		this.functionService = functionService;
	}

	private TmFunctionService functionService;
	
	@Override
	public TmFunctionVo apply(TmFunctionEntity input) {
		TmFunctionVo 	tmFunctionVo=new TmFunctionVo();
		if(StringUtil.isNotEmpty(input.getId())){
			input=functionService.get(TmFunctionEntity.class, input.getId());
			try {
				MyBeanUtils.copyBeanNotNull2Bean( input,tmFunctionVo);
				tmFunctionVo.setParentId(input.getTmFunction()!=null?input.getTmFunction().getId():"");
				tmFunctionVo.setParentName(input.getTmFunction()!=null?input.getTmFunction().getFunctionName():"");
				tmFunctionVo.setParentLevel(input.getTmFunction()!=null?input.getTmFunction().getFunctionLevel():0);
				tmFunctionVo.setIconName(input.getTmIcon().getIconName());
				TmIconEntity iconEntity=input.getTmIcon();
				tmFunctionVo.setIconId(iconEntity.getId());
				tmFunctionVo.setIconPath(iconEntity.getIconPath());
				tmFunctionVo.setIconName(iconEntity.getIconName());
				tmFunctionVo.setIsSystem(input.getIsSystem());
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return tmFunctionVo;
	}


}
