package com.biz.eisp.mdm.function.transformer;

import java.util.Date;

import com.biz.eisp.base.common.util.ResourceConfigUtils;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.utils.PinyinUtil;
import com.biz.eisp.mdm.function.entity.TmFunctionEntity;
import com.biz.eisp.mdm.function.service.TmFunctionService;
import com.biz.eisp.mdm.function.vo.TmFunctionVo;
import com.biz.eisp.mdm.icon.entity.TmIconEntity;
import com.google.common.base.Function;

import jodd.util.StringUtil;

/** 
 * function vo转entity
 * @author 肖胜
 * @version v1.0
 */
public class TmFunctionVoToTmFunctionEntity implements Function< TmFunctionVo,TmFunctionEntity>{
	
	
	
	public TmFunctionVoToTmFunctionEntity(TmFunctionService functionService) {
		super();
		this.functionService = functionService;
	}

	private TmFunctionService functionService;
	
	@Override
	public TmFunctionEntity apply(TmFunctionVo input) {
		TmFunctionEntity tmFunction=null;
		//判断是新增还是修改
		if(StringUtil.isNotEmpty(input.getId())){
			tmFunction=functionService.get(TmFunctionEntity.class, input.getId());
			tmFunction.setUpdateDate(new Date());
			tmFunction.setUpdateName(ResourceConfigUtils.getSessionUserName().getUserName());
		}else{
			tmFunction=new TmFunctionEntity();
			tmFunction.setCreateDate(new Date());
			tmFunction.setCreateName(ResourceConfigUtils.getSessionUserName().getUserName());
		}
		
		//设置默认排序
		if (com.biz.eisp.base.common.util.StringUtil.isNotEmpty(input.getFunctionOrder())) {
			tmFunction.setFunctionOrder(0);
		}
		
		//装载上级菜单实体
		if(StringUtil.isNotBlank(input.getParentId())){
			TmFunctionEntity function=
					functionService.get(TmFunctionEntity.class, input.getParentId());
			if(function == null) {
				throw new BusinessException("转换菜单Vo到Po时，上级菜单找不到:" +input.getParentId());
			}
			tmFunction.setTmFunction(function);
			
			tmFunction.setFunctionLevel(Short.valueOf(function.getFunctionLevel()
					+ 1 + ""));
		}
		//装载图标信息实体
		if(StringUtil.isNotBlank(input.getIconId())){
			TmIconEntity tmIcon=
					functionService.get(TmIconEntity.class, input.getIconId());
			if(tmIcon == null) {
				throw new BusinessException("转换菜单Vo到Po时，图标信息找不到:" +input.getIconId());
			}
		}
		//基础信息加载
		tmFunction.setFunctionName(input.getFunctionName());
		tmFunction.setHeadString(PinyinUtil.getPinYinHeadChar(input.getFunctionName()));
		tmFunction.setFunctionLevel(input.getFunctionLevel());
		tmFunction.setFunctionOrder(input.getFunctionOrder());
		tmFunction.setFunctionUrl(input.getFunctionUrl());
		tmFunction.setIsSystem(input.getIsSystem());
		return tmFunction;
	}


}
