package com.biz.eisp.mdm.icon.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.icon.service.TmIconService;
import com.biz.eisp.mdm.icon.vo.TmIconVo;

/** 图标操作控制器类
 * @author paul
 * @version v1.0
 */
@Controller
@RequestMapping("/iconController")
public class TmIconController extends BaseController {
	/**
	 * 注入service业务层
	 */
	@Autowired
	private TmIconService iconService;
	/**
	 * 进入图标管理界面
	 * @author paul
	 * @param req 请求对象
	 * @param response 响应对象
	 * @return ModelAndView 图标管理主界面
	 */
	@RequestMapping(value = "goIconList",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goIconList(HttpServletRequest req
			,HttpServletResponse response){
		return new ModelAndView("com/biz/eisp/mdm/icon/tmIconMain");
	}
	
	/**
	 * 加载图标数据
	 * @author paul
	 * @param req 请求对象
	 * @param response 响应对象
	 * @param datagrid 图标数据
	 */
	@RequestMapping(value="findIconMainGrid", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findIconMainGrid(HttpServletRequest req,TmIconVo icon
			,HttpServletResponse response){
		page = new EuPage(req);
		List<TmIconVo> icons = 
			this.iconService.findIconMainGrid(icon, page);
		return new DataGrid(icons,page);
	}
	
	/**
	 * 后台处理新增编辑请求
	 * @author wuzhujun
	 * @param icon 图标Vo
	 * @param req 请求对象 
	 * @param response 响应对象
	 * @return 返回json数据模型
	 */
	@RequestMapping(value = "addOrUpdate", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson addOrUpdateIcon(TmIconVo icon, HttpServletRequest req
			,HttpServletResponse response){
		String result = iconService.saveOrUpdateIcon(icon);
		AjaxJson msg = new AjaxJson();
		msg.setMsg(result);
		return msg;
	}
	
	/**
	 * 进入图标新增编辑界面
	 * @author paul
	 * @param req
	 * @param response
	 * @return ModelAndView 图标编辑界面
	 */
	@RequestMapping(value = "goSaveOrUpdateForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goSaveOrUpdateForm(TmIconVo ic
			,HttpServletRequest req
			,HttpServletResponse response){
		if(StringUtil.isNotEmpty(ic.getId())){
			TmIconVo icon = iconService.getIconById(ic.getId());
			req.setAttribute("icon", icon);
		}
		return new ModelAndView("com/biz/eisp/mdm/icon/tmIconForm");
	}
	
	/**
	 * 删除图标.
	 * @author wuzhujun
	 * @param ids 所要删除的图标ids
	 * @return 成功或者失败
	 */
	@RequestMapping(value = "delIcon", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson delIcon(String ids) {
		AjaxJson j = iconService.delIcon(ids);
		return j;
	}
}
