package com.biz.eisp.mdm.icon.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;

/**
 * 图标信息表
 * 关联数据库表tm_icon
 *  @author Sean
 */
@Entity
@Table(name = "tm_icon")
public class TmIconEntity extends IdEntity implements java.io.Serializable {
	
	private static final long serialVersionUID = 1L;

	public TmIconEntity() {
	}

	/**
	 * 图标名称
	 */
	private String iconName;
	/**
	 * 图标路径
	 */
	private String iconPath;
	/**
	 * 图标扩展名
	 */
	private String extend;
	/**
	 *图标类型
	 */
	private Integer iconType;
	/**
	 * 图标样式
	 */
	private String iconClas;
	/**
	 * 图标描述
	 */
	private String iconContent;
	
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 图标名称
	 */
	@Column(name = "name", nullable = false)
	public String getIconName() {
		return this.iconName;
	}
	/**
	 *方法: 设置 java.lang.String
	 *@param: java.lang.String 图标名称
	 */
	public void setIconName(String iconName) {
		this.iconName = iconName;
	}
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 图标路径
	 */
	@Column(name = "path", precision =300)
	public String getIconPath() {
		return this.iconPath;
	}
	/**
	 *方法: 设置 java.lang.Short
	 *@param: java.lang.Short 图标路径
	 */
	public void setIconPath(String iconPath) {
		this.iconPath = iconPath;
	}
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 图标扩展
	 */
	@Column(name = "extend")
	public String getExtend() {
		return extend;
	}
	/**
	 *方法: 设置 java.lang.String
	 *@param: java.lang.String 图标扩展
	 */
	public void setExtend(String extend) {
		this.extend = extend;
	}

	/**
	 *方法: 取得 java.lang.Short
	 *@return: java.lang.Short 图标类型
	 */
	@Column(name = "type")
	public Integer getIconType() {
		return this.iconType;
	}
	/**
	 *方法: 设置 java.lang.Short
	 *@param: java.lang.Short 图标类型
	 */
	public void setIconType(Integer iconType) {
		this.iconType = iconType;
	}
	
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 图标样式
	 */
	@Column(name = "iconclas")
	public String getIconClas() {
		return iconClas;
	}
	/**
	 *方法: 设置 java.lang.String
	 *@param: java.lang.String 图标样式
	 */
	public void setIconClas(String iconClas) {
		this.iconClas = iconClas;
	}
	/**
	 *方法: 设置 java.lang.byte
	 *@param: java.lang.byte 图标描述
	 */
	public void setIconContent(String iconContent) {
		this.iconContent = iconContent;
	}
	/**
	 *方法: 取得 java.lang.byte
	 *@return: java.lang.byte 图标描述
	 */
	@Column(name = "content",precision =3000)
	public String getIconContent() {
		return iconContent;
	}

}
