package com.biz.eisp.mdm.icon.service;

import java.util.List;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.icon.vo.TmIconVo;

/** 图标业务层接口类.
 * <p>操作图标的业务逻辑方法<br>
 * @author paul
 * @version v1.0
 */
public interface TmIconService extends BaseService {
	/**
	 * 保存或者更新图标信息
	 * @author paul
	 * @param icon 界面提交的iconVo对象
	 * @return 处理结果提示信息
	 */
	String saveOrUpdateIcon(TmIconVo icon);
	/**
	 * 根据id获取图标信息
	 * @author paul
	 * @param iconId
	 * @return iconVo对象
	 */
	TmIconVo getIconById(String iconId);
	/**
	 * 根据参数、分页、排序查询
	 * @author paul
	 * @param datagrid datagrid对象，排序信息
	 * @param icon icon对象，查询参数
	 * @param page page对象，分页信息
	 * @return iconVo集合
	 */
	List<TmIconVo> findIconMainGrid(TmIconVo icon,Page page);
	/**
	 * 删除图标
	 * @author wuzhujun
	 * @param ids 所要删除的IDs
	 * @return json数据模型
	 */
	AjaxJson delIcon(String ids);
}
