package com.biz.eisp.mdm.icon.service.impl;

import java.util.ArrayList;
import java.util.List;


import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.icon.entity.TmIconEntity;
import com.biz.eisp.mdm.icon.service.TmIconService;
import com.biz.eisp.mdm.icon.transformer.TmIconEntityToTmIconVo;
import com.biz.eisp.mdm.icon.transformer.TmIconVoToTmIconEntity;
import com.biz.eisp.mdm.icon.vo.TmIconVo;
import com.google.common.collect.Lists;

/** 图标业务层实现类.
 * <p>操作图标的业务逻辑方法的具体实现<br>
 * @author paul
 * @version v1.0
 */
@Service("iconService")
@Transactional
public class TmIconServiceImpl extends BaseServiceImpl 
		implements TmIconService {

	@Override
	public String saveOrUpdateIcon(TmIconVo ic) {
		TmIconEntity icon = null;
		TmIconVoToTmIconEntity transForm = new TmIconVoToTmIconEntity(this);
		icon = transForm.apply(ic);
		this.saveOrUpdate(icon);
		return "操作成功";
	}

	@Override
	public TmIconVo getIconById(String iconId) {
		TmIconEntity ie = this.get(TmIconEntity.class, iconId);
		if(ie != null){
			TmIconEntityToTmIconVo trans = new TmIconEntityToTmIconVo(this);
			return trans.apply(ie);
		}
		return null;
	}
	@Override
	public List<TmIconVo> findIconMainGrid(TmIconVo icon, Page page) {
		String hql = "from TmIconEntity  t where 1 = 1 ";
		String name = icon.getIconName();
		String path = icon.getIconPath();
		String extend = icon.getExtend();
		String clas = icon.getIconClas();
		Integer type = icon.getIconType();
		
		if(name!=null&&!"".equals(name)){
			hql+=" and t.iconName like "+"'%"+name+"%'";
		}
		if(path!=null&&!"".equals(path)){
			hql+=" and t.iconPath like "+"'%"+path+"%'";
		}
		if(extend!=null&&!"".equals(extend)){
			hql+=" and t.extend like "+"'%"+extend+"%'";
		}
		if(clas!=null&&!"".equals(clas)){
			hql+=" and t.iconClas like "+"'%"+clas+"%'";
		}
		if(type!=null&&!"".equals(type)){
			hql+=" and t.iconType = "+"'"+type+"'";
		}
		List<TmIconEntity> list = new ArrayList<TmIconEntity>();
		if(page!=null){
			list = this.findByHql(hql, page);
		}else{
			list = this.findByHql(hql);
		}
		List<TmIconVo> tmIconVos = new ArrayList<TmIconVo>();
		TmIconEntityToTmIconVo trans = new TmIconEntityToTmIconVo(this);
		tmIconVos  = Lists.transform(list, trans);
		return tmIconVos;
	}

	@Override
	public AjaxJson delIcon(String ids) {
		AjaxJson j = new AjaxJson();
		String[] iconIds = ids.split(",");
		for(String id:iconIds){
			TmIconEntity tmIconEntity = get(TmIconEntity.class,id);
			if(tmIconEntity == null){
				j.setMsg("删除失败！");
				j.setSuccess(false);
				return j;
			}
			delete(tmIconEntity);
		}
		j.setMsg("删除成功！");
		return j;
	}
	
}
