package com.biz.eisp.mdm.icon.transformer;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.mdm.icon.entity.TmIconEntity;
import com.biz.eisp.mdm.icon.service.TmIconService;
import com.biz.eisp.mdm.icon.vo.TmIconVo;
import com.google.common.base.Function;

/**
 *  图标管理po装换vo工具类.
 * @author wuzhujun
 * @version v1.0
 */
public class TmIconEntityToTmIconVo implements Function<TmIconEntity,TmIconVo>{
	private TmIconService tmIconService;
	public TmIconEntityToTmIconVo(TmIconService tmIconService){
		this.tmIconService = tmIconService;
	}
	@Override
	public TmIconVo apply(TmIconEntity entity) {
		TmIconVo tmIconVo = new TmIconVo();
		entity  = tmIconService.get(TmIconEntity.class, entity.getId());
		try {
			MyBeanUtils.copyBeanNotNull2Bean(entity,tmIconVo);
		} catch (Exception e) {
			e.printStackTrace();
			throw new BusinessException("在图标管理po转vo出现异常");
		}
		return tmIconVo;
	}
}
