package com.biz.eisp.mdm.icon.transformer;


import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.mdm.icon.entity.TmIconEntity;
import com.biz.eisp.mdm.icon.service.TmIconService;
import com.biz.eisp.mdm.icon.vo.TmIconVo;
import com.google.common.base.Function;

/** icon PO对象和vo对象相互转换的工具类
 * @author paul
 * @version v1.0
 */
public class TmIconVoToTmIconEntity implements Function<TmIconVo,TmIconEntity>{
	private TmIconService tmIconService;
	
	public TmIconVoToTmIconEntity(TmIconService tmIconService){
		this.tmIconService = tmIconService;
	}
	@Override
	public TmIconEntity apply(TmIconVo vo) {
		TmIconEntity tmIconEntity = null;
		//判断是新增还是修改
		if(StringUtil.isNotEmpty(vo.getId())){
			tmIconEntity = tmIconService.get(TmIconEntity.class, vo.getId());
		}else{
			tmIconEntity = new TmIconEntity();
		}
		try {
			MyBeanUtils.copyBeanNotNull2Bean(vo,tmIconEntity);
		} catch (Exception e) {
			e.printStackTrace();
			throw new BusinessException("转换图标管理Vo到Po时，出现异常");
		}
		return tmIconEntity;
	}
	
}
