package com.biz.eisp.mdm.interceptors;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.*;
import com.biz.eisp.base.common.util.json.Head;
import com.biz.eisp.base.common.util.json.ResponseBean;
import com.biz.eisp.base.core.redis.cache.IRedisCacheService;
import com.biz.eisp.base.utils.JwtUtils;
import com.biz.eisp.base.utils.ResultBean;
import com.biz.eisp.base.utils.SysConfigUtils;
import com.biz.eisp.mdm.function.service.MenuPermissionService;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.role.vo.TmRoleFunctionVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.web.Oauth2Vo;
import com.biz.eisp.mdm.web.pojo.Client;
import io.jsonwebtoken.Claims;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class AuthInterceptor implements HandlerInterceptor {
	
	private List<String> excludeUrls;

	@Autowired
	private JwtUtils jwtUtils;
	@Autowired
	private MenuPermissionService menuPermissionService;

	@Autowired
	private TmUserService tmUserService;
	@Autowired(required = false)
	private IRedisCacheService redisCacheService;
	@Autowired
	private TmPositionService tmPositionService;

	@Autowired
	private SysConfigUtils sysConfigUtils;

	public List<String> getExcludeUrls() {
		return excludeUrls;
	}

	public void setExcludeUrls(List<String> excludeUrls) {
		this.excludeUrls = excludeUrls;
	}

	/**
	 * 在controller后拦截
	 */
	public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object object,
			Exception exception) throws Exception {
	}

	public void postHandle(HttpServletRequest request, HttpServletResponse response, Object object,
			ModelAndView modelAndView) throws Exception {
		//用于权限对象传递
		String accessEntry=request.getParameter("clickFunctionId");
		if(StringUtil.isEmpty(accessEntry)){
			accessEntry=request.getParameter(Globals.AccessEntry);
		}
		request.setAttribute(Globals.AccessEntry, accessEntry);
		
		//发布版本号，主要处理js缓存等问题
		//String pub_version = ResourceUtil.getSysConfigProperty("pub_version");
		String pub_version = sysConfigUtils.getPubVersion();
		request.setAttribute("pubVersion", pub_version);
	}

	/**
	 * 在controller前拦截
	 */
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object object) throws Exception {
		//获取请求url
		String reqUrl = ResourceConfigUtils.getRequestPath(request);
		String hurl=request.getRequestURI();
		//获取手机请求参数
		String phoneSend = request.getParameter("phoneSend");//手机请求
		String posId = request.getParameter("posId");//职位
		String userId = request.getParameter("userId");//用户
		String subFlag = request.getParameter("subFlag");// 请求类型
        String isLogin= request.getParameter("isLogin");//1表示登录
		String tokenStr=request.getParameter(TokenUtil.TOKEN_STRING_NAME);//获取token
		String wxtag = request.getParameter("wx");
		String wxopenid=request.getParameter("wxopenid");
		String jwtToken=request.getHeader("jwtToken");
		String imei=request.getHeader("imei");

		//特殊url处理  直接转入访问的目标路径
		if (excludeUrls.contains(hurl)) {
			return true;
		}
		if (StringUtil.isNotEmpty(jwtToken) && StringUtil.isNotEmpty(imei) ){
			Claims claims=jwtUtils.getClaimByToken(jwtToken);
			//加密的用户码 组成为  用户+手机im 唯一码
			if (null != claims && claims.getSubject().equals(imei)){ //认证成功
				return true;
			}else{  //认证失败
				checkvalid(response);
			}
			return false;
		}else {
			//获取会话id并查找client对象
			HttpSession session = ContextHolderUtils.getSession();
			Client client = ResourceConfigUtils.getClient();
			if (client == null) {
				client = ResourceConfigUtils.getClient();
			}
			//此处用以 后台swagger放过
			//String enable_swagger = ResourceUtil.getSysConfigProperty("enable_swagger");
			String enable_swagger = sysConfigUtils.getEnableSwagger();
			if (StringUtil.isNotEmpty(enable_swagger) && enable_swagger.equals("true")
					&& reqUrl.indexOf(".do") == -1) {  //放开swagger配置
				return true;
			}
			if (StringUtil.isNotEmpty(phoneSend) && phoneSend.equals("1")) {
				//String need_token = ResourceUtil.getSysConfigProperty("need_token");
				String need_token = sysConfigUtils.getNeedToken();
				if (StringUtils.isBlank(need_token) || "0".equals(need_token)) {
					//拦截是否手机切换了职位 如果检测到切换则修改成主职位
					if (StringUtil.isNotEmpty(userId)
							&& StringUtil.isNotEmpty(posId)
							&& (!Globals.OffLine.equalsIgnoreCase(subFlag))
							&& (!Globals.phoneNoIntecepter.containsKey(reqUrl))
							&& tmPositionService.isMainPosition(posId) == 0) {

						tmPositionService.updatePositionIsMain(userId, posId);
					}
					return true;
				} else {
					session.setAttribute(TokenUtil.TOKEN_STRING_NAME, tokenStr);
					//拦截是否手机切换了职位 如果检测到切换则修改成主职位
					if (Globals.OffLine.equalsIgnoreCase(subFlag)) {
						return true;
					} else {
						if (StringUtil.isNotEmpty(isLogin) && isLogin.equals("1")) {
							return true;
						} else {
							if (StringUtils.isBlank(tokenStr)) {
								valid(response);
								return false;
							} else {
								if (!TokenUtil.isTokenStringValid(redisCacheService, tokenStr)) {
									valid(response);
									return false;
								}
								return true;
							}
						}

					}
				}
			} else if (StringUtils.isNotBlank(wxtag) && wxtag.equals("1")) {
				if (client == null) {
					String code = request.getParameter("code");
					response.sendRedirect("memberController.do?gologin&_requestPath="
							+ reqUrl + "&code=" + code + "&wxopenid=" + wxopenid);
					return false;
				} else {
					Oauth2Vo oau = client.getOau();
					if (oau == null) {
						String code = request.getParameter("code");
						response.sendRedirect("memberController.do?gologin&_requestPath="
								+ reqUrl + "&code=" + code + "&wxopenid=" + wxopenid);
						return false;
					}
					if (oau != null && StringUtils.isNotBlank(oau.getSapid())) {
						if (!checksap(oau.getSapid())) {
							response.sendRedirect("memberController.do?gologin&_requestPath="
									+ reqUrl + "&opbind=1&bindid=" + oau.getSapid() + "&wxopenid=" + wxopenid);
							return false;
						}
					}
					if (oau != null && StringUtils.isBlank(oau.getSapid())) {
						String code = request.getParameter("code");
						response.sendRedirect("memberController.do?gologin&_requestPath="
								+ reqUrl + "&code=" + code + "&wxopenid=" + wxopenid);
						return false;
					}
					return true;
				}

			} else {
				//特殊url处理  直接转入访问的目标路径
				if (excludeUrls.contains(reqUrl)) {
					return true;
				}
				//无client对象表示未登录 跳转登录界面
				if (client == null) {
					forward(request, response);
					return false;
				} else if (client.getUser() == null) {
					forward(request, response);
					return false;
				} else {
					TmUserEntity tmUserEntity = client.getUser();
					//1.处理是否有权限访问
					boolean isPermission = menuPermissionService.getFunctionsByRequest(request, tmUserEntity);
					if (!isPermission && !Globals.Admin_Name.equalsIgnoreCase(tmUserEntity.getUserName())
							&& tmUserEntity.getUserType().intValue() != Globals.OTHER_USER.intValue()) {
						this.noPermisson(response);
						return false;
					}
					//2.处理页面按钮权限
					List<TmRoleFunctionVo> roleFunctionVos = menuPermissionService.getOperationsByRequest(request, tmUserEntity);
					//3.处理数据权限
					menuPermissionService.getDataRuleByRequest(request, roleFunctionVos);
				}
				return true;
			}
		}
	}
	private void checkvalid(HttpServletResponse response) throws Exception{
		ResultBean bean=new ResultBean();
		bean.setCode(101);
		bean.setMessage("登录失效!");
		bean.setTs(System.currentTimeMillis());
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		out.print(JSONObject.toJSONString(bean));
		out.flush();
	}

	private void valid( HttpServletResponse response) throws Exception{
		ResponseBean bean=new ResponseBean();
		Head head=new Head();
		head.setCode(106);
		head.setMessage("token失效!");
		bean.setHead(head);
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		out.print(JsonUtil.bean2json(bean));
		out.flush();
	}
	/**
	 * 无权限重定向
	 * @param response
	 * @return
	 * @throws IOException 
	 */
	public void noPermisson(HttpServletResponse response) throws IOException {
		response.sendRedirect("loginController.do?noPermisson");
	}
	/**
	 * 转发
	 * @return
	 */
	@RequestMapping(params = "forword")
	public ModelAndView forword(HttpServletRequest request) {
		return new ModelAndView("redirect:/loginController.do?login");
	}

	private void forward(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		request.getRequestDispatcher("pages/login/timeout.jsp").forward(request, response);
	}
	// 检查经销商是否可用 true  启用的   false不启用
	public boolean checksap(String sapcode) {
		boolean b = false;
		TmUserEntity user=tmUserService.findUniqueByProperty(TmUserEntity.class,"userName",sapcode);

		if (user != null ) {

			if (user.getEnableStatus()!=null&&user.getEnableStatus()==0) {
				b = true;
			}
		}
		return b;
	}
}
