package com.biz.eisp.mdm.operation.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.icon.entity.TmIconEntity;
import com.biz.eisp.mdm.operation.entity.TmOperationEntity;
import com.biz.eisp.mdm.operation.service.OperationService;
import com.biz.eisp.mdm.operation.transformer.TmOperationEntityToTmOperationVo;
import com.biz.eisp.mdm.operation.vo.TmOperationVo;
import com.google.common.collect.Lists;


/** 
 * <p>菜单按钮Controller<br>
 * @author 肖胜
 * @version v1.0
 */
@Controller
@RequestMapping("/operationController")
public class OperationController extends BaseController{

	//注入菜单按钮Service层
	@Autowired
	private OperationService operationService;
	
	/**
	 * 加载按钮设置页面
	 * @param request 对象
	 * @param functionId 菜单主键ID
	 * @return ModelAndView 页面对象
	 */
	@RequestMapping(value = "operationList", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView operationList(HttpServletRequest request,
			String functionId) {
		request.setAttribute("functionId", functionId);
		return new ModelAndView("com/biz/eisp/mdm/operation/operationList");
	}
	
	/**
	 * 新增修改按钮维护界面
	 * @param request 对象
	 * @param functionId 菜单主键ID
	 * @param operationId 按钮id
	 * @return ModelAndView 页面对象
	 */
	@RequestMapping(value = "operation", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView operation(HttpServletRequest request,
			String functionId,	TmOperationEntity operation) {
		
		//将按钮对象传到页面 编辑时用
		if(StringUtil.isNotEmpty(operation.getId())){
			operation=operationService.get(TmOperationEntity.class, operation.getId());
		}
		request.setAttribute("operation", operation);
		
    	//将图标列表传到页面
    	List<TmIconEntity> iconlist = operationService.findByProperty(TmIconEntity.class, "iconType", 20);
    	request.setAttribute("iconlist", iconlist);
    	
     	//将菜单idw传到页面
		request.setAttribute("functionId", functionId);
		
		return new ModelAndView("com/biz/eisp/mdm/operation/operation");
	}
	
	
	/**
	 * 按钮Datagrid数据
	 * @param functionId 所选菜单id
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@RequestMapping(value = "operationGrid", method = {RequestMethod.GET, RequestMethod.POST})
	public void operationGrid(String functionId,
			HttpServletRequest request,HttpServletResponse response) {
		List<TmOperationEntity> result=operationService.getOperationList(functionId);
		
		List <TmOperationVo> voList = Lists.transform(result, new TmOperationEntityToTmOperationVo());
		super.datagridReturn(response, voList);
	}
	
	/**
	 * 保存按钮信息
	 * @param request 请求对象
	 * @param response 响应对象
	 * @param function 菜单记录对象
	 */
	@RequestMapping(value = "saveOperation", method = {RequestMethod.GET, RequestMethod.POST})
	public void saveFunction(HttpServletRequest request,
			HttpServletResponse response,TmOperationEntity operation){
		String msg=operationService.saveOperation(operation);
		this.message=StringUtil.isNotEmpty(msg)?msg:message;
		sendResponse(response);
	}
	
	/**
	 * 删除菜单信息
	 * @param request 请求对象
	 * @param response 响应对象
	 * @param function 菜单记录对象
	 */
	@RequestMapping(value = "deleteOperation", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public JSONObject deleteOperation(HttpServletRequest request,HttpServletResponse response,String id){
		try {
			TmOperationEntity operation=operationService.get(TmOperationEntity.class, id);
			operationService.delete(operation);
		} catch (Exception e) {
			e.printStackTrace();
			this.message="操作失败，请联系开发人员！";
		}
		return returnJson();
	}
	
}
