package com.biz.eisp.mdm.operation.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.mdm.function.entity.TmFunctionEntity;
import com.biz.eisp.mdm.icon.entity.TmIconEntity;

/**
 * 按钮权限实体.
 * <p>关联数据库：tm_operation<br>
 * @author grover
 * @version v1.0
 */
@Entity
@Table(name = "tm_operation")
public class TmOperationEntity extends IdEntity implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	/**
	 * 按钮编码
	 */
	private String operationCode;
	/**
	 * 按钮名称
	 */
	private String operationName;
	/**
	 * 图标
	 */
	private TmIconEntity tmIcon;
	/**
	 * 创建时间
	 */
	private java.util.Date createDate;
	/**
	 * 创建人ID
	 */
	private java.lang.String createName;
	/**
	 * 修改时间
	 */
	private java.util.Date updateDate;
	/**
	 * 修改人
	 */
	private java.lang.String updateName;
	/**
	 * 状态
	 */
	private java.lang.String status;
	/**
	 * 按钮与菜单关系菜单
	 */
	private TmFunctionEntity tmFunction;
	
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  创建时间
	 */
	@Column(name ="create_date",nullable=true)
	public java.util.Date getCreateDate(){
		return this.createDate;
	}
	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  创建时间
	 */
	public void setCreateDate(java.util.Date createDate){
		this.createDate = createDate;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  创建人ID
	 */
	@Column(name ="create_name",nullable=true,length=32)
	public java.lang.String getCreateName(){
		return this.createName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  创建人ID
	 */
	public void setCreateName(java.lang.String createName){
		this.createName = createName;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  修改时间
	 */
	@Column(name ="update_date",nullable=true)
	public java.util.Date getUpdateDate(){
		return this.updateDate;
	}
	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  修改时间
	 */
	public void setUpdateDate(java.util.Date updateDate){
		this.updateDate = updateDate;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  修改人ID
	 */
	@Column(name ="update_name",nullable=true,length=32)
	public java.lang.String getUpdateName(){
		return this.updateName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  修改人ID
	 */
	public void setUpdateName(java.lang.String updateName){
		this.updateName = updateName;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  按钮编码
	 */
	@Column(name ="operation_code",nullable=true,length=30)
	public String getOperationCode() {
		return operationCode;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  按钮编码
	 */
	public void setOperationCode(String operationCode) {
		this.operationCode = operationCode;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  按钮名称
	 */
	@Column(name ="operation_name",nullable=true,length=50)
	public String getOperationName() {
		return operationName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  按钮名称
	 */
	public void setOperationName(String operationName) {
		this.operationName = operationName;
	}
	/**
	 *方法: 取得 com.biz.eisp.mdm.icon.entity.TmIconEntity
	 *@return: com.biz.eisp.mdm.icon.entity.TmIconEntity 图标
	 */
	@ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "icon_id")
	public TmIconEntity getTmIcon() {
		return tmIcon;
	}
	 /**
	 *方法: 设置com.biz.eisp.mdm.icon.entity.TmIconEntity
	 *@param: com.biz.eisp.mdm.icon.entity.TmIconEntity 图标
	 */
	public void setTmIcon(TmIconEntity tmIcon) {
		this.tmIcon = tmIcon;
	}
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 状态
	 */
	@Transient
	public java.lang.String getStatus() {
		return status;
	}
	 /**
		 *方法: 设置 java.lang.String
		 *@param: java.lang.String 状态
		 */
	public void setStatus(java.lang.String status) {
		this.status = status;
	}
	/**
	 *方法: 取得 com.biz.eisp.mdm.function.entity.TmFunctionEntity
	 *@return: com.biz.eisp.mdm.function.entity.TmFunctionEntity 关联菜单
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "function_id")
	public TmFunctionEntity getTmFunction() {
		return this.tmFunction;
	}
	/**
	 *方法: 设置 com.biz.eisp.mdm.function.entity.TmFunctionEntity
	 *@param: com.biz.eisp.mdm.function.entity.TmFunctionEntity 关联菜单
	 */
	public void setTmFunction(TmFunctionEntity tmFunction) {
		this.tmFunction = tmFunction;
	}
}
