package com.biz.eisp.mdm.operation.service.impl;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.icon.entity.TmIconEntity;
import com.biz.eisp.mdm.operation.entity.TmOperationEntity;
import com.biz.eisp.mdm.operation.service.OperationService;

/** 
 * 菜单按钮service接口实现
 * @author 肖胜
 * @version v1.0
 */
@Service("operationService")
@Transactional
public class OperationServiceImpl extends BaseServiceImpl implements OperationService{

	@Override
	public List<TmOperationEntity> getOperationList(String functionId) {
		return this.findByProperty(TmOperationEntity.
				class, "tmFunction.id", functionId);
	}

	@Override
	public String saveOperation(TmOperationEntity operation) {
		if(StringUtil.isNotEmpty(operation.getId())){
			TmOperationEntity oper=this.get(TmOperationEntity.class, operation.getId());
			TmIconEntity icon = this.get(TmIconEntity.class, operation.getTmIcon().getId());
			oper.setTmFunction(operation.getTmFunction());
			oper.setOperationCode(operation.getOperationCode());
			oper.setOperationName(operation.getOperationName());
			oper.setTmIcon(icon);
			this.updateEntity(oper);
		}else{
			System.out.println("------------------------"+operation.getTmFunction().getId());
			String hql="from TmOperationEntity where tmFunction.id=? and operationCode=?";
			List<TmOperationEntity> list=
					this.findByHql(hql, operation.getTmFunction().getId(),operation.getOperationCode());
			if(list!=null&&list.size()>0){
				return "当前菜单已包含按钮编码为"+operation.getOperationCode()+"的按钮";
			}
			this.save(operation);
		}
		return null;
	}
	
}
