package com.biz.eisp.mdm.operation.transformer;

import org.springframework.beans.BeanUtils;

import com.biz.eisp.mdm.operation.entity.TmOperationEntity;
import com.biz.eisp.mdm.operation.vo.TmOperationVo;
import com.google.common.base.Function;

/** 类简述.
 * <p>类的详细说明第一行<br>
 * 类的详细说明第二行
 * @author liukai
 * @version v1.0
 */
public class TmOperationEntityToTmOperationVo implements Function <TmOperationEntity, TmOperationVo>{

	@Override
	public TmOperationVo apply(TmOperationEntity entity) {
		if(entity == null) {
			return null;
		}
		
		TmOperationVo vo = new TmOperationVo();
		
		BeanUtils.copyProperties(entity, vo);
		
		vo.setFunctionId(entity.getTmFunction().getId());
		if(entity.getTmIcon() != null) {
			vo.setIconId(entity.getTmIcon().getId());
			vo.setIconName(entity.getTmIcon().getIconName());
			vo.setIconPath(entity.getTmIcon().getIconPath());
		}
		
		return vo;
	}

}
