package com.biz.eisp.mdm.org.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.*;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.tag.util.oConvertUtils;
import com.biz.eisp.base.common.util.*;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.org.service.*;
import com.biz.eisp.mdm.org.transform.TmOrgEntityToTmOrgVo;
import com.biz.eisp.mdm.org.vo.QueryTmOrgVo;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** 组织控制器.
 * <p>组织相关功能的控制器方法
 * @author grover
 * @version v1.0
 */
@Controller
@RequestMapping("/tmOrgController")
public class TmOrgController extends BaseController {
	
	/**
	 * 组织service注入
	 */
	@Autowired
	private TmOrgService tmOrgService;

	@Autowired(required=false)
	private TmOrgMainExtendService tmOrgMainExtendService;

	@Autowired(required=false)
	private TmOrgFormExtendService tmOrgFormExtendService;
	
	@Autowired(required=false)
	private TmOrgBackExtendService tmOrgBackExtendService;

	/**
	 * 跳转组织页面.
	 * @author grover
	 * @param request 请求对象
	 * @return 组织主界面
	 */
	@RequestMapping(value = "goOrgMain",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goOrgMain(HttpServletRequest request) {
		request.setAttribute("extendTableName",Globals.TABLE_ORG);
		if(tmOrgMainExtendService!=null){
			request.setAttribute("includeJSP", tmOrgMainExtendService.includeJsp());
		}
		return new ModelAndView("com/biz/eisp/mdm/tmOrg/tmOrgMain");
	}
	/**
	 * 跳转组织选择页面.
	 * @author grover
	 * @param request 请求对象
	 * @return 组织选择界面
	 */
	@RequestMapping(value = "goOrgSelectMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goOrgSelectMain(HttpServletRequest request) {
		return new ModelAndView("com/biz/eisp/mdm/tmOrg/tmOrgSelectMain");
	}
	/**
	 * 组织列表.
	 * @author grover
	 * @param request 请求对象
	 * @param orgVo 组织vo对象
	 */
	@RequestMapping(value = "findOrgMainGrid",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public Object findOrgMainGrid(HttpServletRequest request, TreeGrid treeGrid,TmOrgVo orgVo) {
        List<TreeGrid> orgGris = TreeGridUtil.buildTree(tmOrgService.findOrgMainGrid(request, treeGrid, orgVo));
        //json特殊处理
  		String jsonString = JSON.toJSONString(orgGris, new FastJsonFilter());
  		Object object = JSONArray.parse(jsonString);
		return object;
	}
	/**
	 * 组织列表.
	 * @author grover
	 * @param request 请求对象
	 * @param orgVo 组织vo对象
	 */
	@RequestMapping(value = "findOrgMainList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public List<TmOrgVo> findOrgMainList(HttpServletRequest request,TmOrgVo orgVo) {
		List<TmOrgVo> orgList = tmOrgService.findOrgMainList(orgVo);
		return orgList;
	}

	/**
	 * 组织列表.
	 * @author grover
	 * @param request 请求对象
	 * @param orgVo 组织vo对象
	 */
	@RequestMapping(value = "findAuthOrgMainList",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public List<TmOrgVo> findAuthOrgMainList(HttpServletRequest request, String parentId, TmOrgVo orgVo) {
		if(StringUtils.isNotBlank(parentId) && StringUtil.isBlank(orgVo.getId())) {
			orgVo.setId(parentId);
		}
		List<TmOrgVo> orgList = tmOrgService.findOrgMainList(orgVo);
		return orgList;
	}

	/**
	 * 组织列表.
	 * @author grover
	 * @param request 请求对象
	 * @param orgVo 组织vo对象
	 */
	@RequestMapping(value = "findSelectOrgMainGrid",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public Object findSelectOrgMainGrid(HttpServletRequest request, TreeGrid treeGrid,TmOrgVo orgVo) {
		List<TreeGrid> orgGris = tmOrgService.findOrgMainGrid(request, treeGrid, orgVo);
		
		JSONArray jsonArray = new JSONArray();
		for (TreeGrid tg : orgGris) {
			jsonArray.add(JSON.parse(tg.toJson()));
		}
		return jsonArray;
	}
	/**
	 * 跳转组织列表.
	 * @author grover
	 * @param request 请求对象
	 * @param orgVo 组织vo对象
	 * @return 组织选择列表
	 */
	@RequestMapping(value = "goOrgMainSelectToPosGrid", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goSelectOrgMainGrid(HttpServletRequest request,TmOrgVo orgVo) {
		request.setAttribute("positionIds", orgVo.getPositionIds());
		request.setAttribute("orgId", orgVo.getOrgId());
		return new ModelAndView("com/biz/eisp/mdm/tmOrg/OrgSelectMainGrid");
	}
	/**
	 * 跳转组织列表.
	 * @author grover
	 * @param request 请求对象
	 * @param orgVo 组织vo对象
	 * @return 组织选择列表
	 */
	@RequestMapping(value = "goOrgMainSelectToCustomerGrid", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goOrgMainSelectToCustomerGrid(HttpServletRequest request,TmOrgVo orgVo) {
		request.setAttribute("customerIds", orgVo.getCustomerIds());
		request.setAttribute("orgId", orgVo.getOrgId());
		return new ModelAndView("com/biz/eisp/mdm/tmOrg/orgSelectMainToCustomerGrid");
	}
	/**
	 * 选择组织列表.
	 * @author grover
	 * @param request 请求对象
	 * @param orgVo 组织vo对象
	 */
	@RequestMapping(value = "findOrgSelectGrid", method = {RequestMethod.GET, RequestMethod.POST})
	public void findOrgSelectGrid(HttpServletRequest request,HttpServletResponse response ,TmOrgVo orgVo) {
		try {
			Page page = new EuPage(request);
			List<TmOrgVo> list = tmOrgService.findOrgSelectGrid(orgVo, page);
			this.datagridReturn(response, list, page);
		} catch (Exception e) {
			e.printStackTrace();
			throw new BusinessException("获取组织列表失败");
		}
	}
	
	/**
	 * 组织新增页面.
	 * <p>跳转组织新增页面
	 * @author grover
	 * @param request 请求对象
	 * @param orgVo 组织vo对象
	 * @return 组织新增页面
	 */
	@RequestMapping(value = "goOrgAddForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goOrgAddForm(HttpServletRequest request, TmOrgVo orgVo) {
		String optype=request.getParameter("optype");
		request.setAttribute("optype", optype);
		if(StringUtil.isNotEmpty(orgVo.getId())){
			TmOrgEntity orgEntity = tmOrgService.get(TmOrgEntity.class, orgVo.getId());
			orgVo=new TmOrgEntityToTmOrgVo(tmOrgService).apply(orgEntity);
			request.setAttribute("org", orgVo);
		}
		request.setAttribute("extendTableName",Globals.TABLE_ORG);
		if(tmOrgFormExtendService!=null){
			request.setAttribute("includeJSP", tmOrgFormExtendService.includeJsp());
		}

		return new ModelAndView("com/biz/eisp/mdm/tmOrg/tmOrgForm");
	}
	
	/**
	 * 获取上级组织.
	 * <p>获取上级组织的方法
	 * @author grover
	 * @param request 请求对象
	 * @param orgVo 组织vo对象
	 * @return 下拉树
	 */
	@RequestMapping(value = "getParentOrg", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public List<ComboTree> getParentOrg(HttpServletRequest request, ComboTree comboTree,TmOrgVo orgVo) {
		
		if ((orgVo!=null&&StringUtils.isBlank(orgVo.getPid()))||orgVo==null) {
			TmOrgEntity og= ResourceConfigUtils.getCurrOrg();
			if (og!=null) {
				TmOrgVo org=new TmOrgVo();
				org.setPid(og.getId());
				return tmOrgService.getParentOrg(orgVo, comboTree,request);	
			}
			return new ArrayList<ComboTree>();
		}else{
		return tmOrgService.getParentOrg(orgVo, comboTree,request);
	}
	
	}
	/**
     * 获取机构树-combotree
     * 
     * @param request
     * @return
     */
    @RequestMapping(value = "getOrgTree",method = {RequestMethod.GET,RequestMethod.POST})
    @ResponseBody
    public List<ComboTree> getOrgTree(HttpServletRequest request) {
    	ComboTreeModel comboTreeModel = new ComboTreeModel("id", "orgName", "tmOrgList");
    	List<ComboTree> comboTreesreturn=new ArrayList<ComboTree>();

    	String opOrgId = oConvertUtils.getString(request.getParameter("id"));
		if (StringUtil.isNotEmpty(opOrgId)) {
			TmOrgEntity tdepart=tmOrgService.get(TmOrgEntity.class, opOrgId);
			if (tdepart!=null) {
				List<ComboTree> comboTrees = ComboxTreeUtil.getComboTrees();//从内存里读取初始数据
				comboTreesreturn= ComboxTreeUtil.getComboxByObj(comboTrees, comboTreeModel, tdepart);
			}
		} else {
			String userId = ResourceConfigUtils.getSessionUserName().getId();
			String userName= ResourceConfigUtils.getSessionUserName().getUserName();
			
			if(userName.equalsIgnoreCase("admin")){
				comboTreesreturn = ComboxTreeUtil.getComboTrees();
			}else{
				QueryTmOrgVo queryTmOrgVo=new QueryTmOrgVo();
				queryTmOrgVo.setUserId(userId);
				List<TmOrgVo> ups=tmOrgService.findTmOrgByAllPossible(queryTmOrgVo, null);
//				List<TmOrgEntity> list=RoletoJson.setdepartlevel(ups);
				if (!CollectionUtils.isEmpty(ups)) {
					List<ComboTree> comboTrees = ComboxTreeUtil.getComboTrees();//从内存里读取初始数据
					for (TmOrgVo org : ups) {
						comboTreesreturn.addAll(ComboxTreeUtil.getComboxByObj(comboTrees, comboTreeModel, org));
					}
				}
			}
		}
        return comboTreesreturn;
    }
	/**
	 * 销售大区和销售省区树.
	 * @author grover
	 * @param request 请求对象
	 * @param orgVo 组织vo对象
	 * @return 下拉树
	 */
	@RequestMapping(value = "getSalesArae",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public List<ComboBox> getSalesArae(HttpServletRequest request, TmOrgVo orgVo) {
		return tmOrgService.getSalesArae(orgVo);
	}
	
	/**
	 * 销售大区和销售省区树.
	 * @author grover
	 * @param request 请求对象
	 * @param orgVo 组织vo对象
	 * @return 下拉树
	 */
	@RequestMapping(value = "getSalesAraeOrgCode",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public List<ComboBox> getSalesAraeOrgCode(HttpServletRequest request, TmOrgVo orgVo) {
		return tmOrgService.getSalesAraeOrgCode(orgVo);
	}
	
	/**
	 * 保存编辑.
	 * @param orgVo 组织vo对象
	 * @return 成功或者失败
	 */
	@RequestMapping(value = "saveOrUpdateOrg", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveOrUpdateOrg(HttpServletRequest request, TmOrgVo orgVo) {
		AjaxJson j = new AjaxJson();
		try {
			Page page = new EuPage(request);
			//保存数据
			String id = tmOrgService.saveOrUpdateOrg(orgVo, page);
			//更新叶子节点状态
			tmOrgService.updateIsLeafColumn(Globals.TABLE_ORG);
			//设置编码和名称，用于保存后进行查询操作
			Map<String, Object>attributes = new HashMap<String, Object>();
			attributes.put("orgCode", orgVo.getOrgCode());
			attributes.put("orgName", orgVo.getOrgName());
			j.setAttributes(attributes);
			if (null != tmOrgBackExtendService){
				tmOrgBackExtendService.afterSaveOrUpdateOrg(id);
			}
		} catch (Exception e) {
			j.setSuccess(false);
			j.setMsg("操作失败:"+e.getMessage());
			e.printStackTrace();
		}
		return j;
	}
	/**
	 * 删除组织.
	 * @author grover
	 * @param ids 组织ids
	 * @return 成功或者失败
	 */
	@RequestMapping(value = "delOrg", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson delOrg(String ids) {
		AjaxJson j = new AjaxJson();

		try {
			 j  = tmOrgService.delOrg(ids);
			 //更新叶子节点状态
			 tmOrgService.updateIsLeafColumn(Globals.TABLE_ORG);
			 if (null != tmOrgBackExtendService){
			 	tmOrgBackExtendService.afterDelOrg(ids);
			 }
		} catch(Exception e) {
			j.setSuccess(false);
			j.setMsg("操作失败");
			e.printStackTrace();
		}
		return j;
	}
	/**
	 * 验证重复.
	 * @author grover
	 * @param orgVo 组织vo对象
	 * @param request 验证对象
	 */
	@RequestMapping(value = "validateOrg",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public ValidForm validateOrg(TmOrgVo orgVo,HttpServletRequest request) {	
		String param = OConvertUtils.getString(request.getParameter("param"));
		ValidForm validForm = new ValidForm();
		//验证
		Criterion cr1 = Restrictions.eq("orgName", param);
		Criterion cr3 = Restrictions.eq("orgCode", param);
		Criterion cr4 = Restrictions.eq("enableStatus", Globals.ZERO);
		if(StringUtil.isNotEmpty(orgVo.getId())){
			Criterion cr2 = Restrictions.not(Restrictions.eq("id", orgVo.getId()));
			//修改
			if("0".equals(orgVo.getType())){
				//编码
				List<TmOrgEntity> tmOrgByCodes = tmOrgService.findByCriteria(TmOrgEntity.class, cr3, cr2, cr4);
				if(!CollectionUtils.isEmpty(tmOrgByCodes)){
					validForm.setStatus("n");
					validForm.setInfo("组织编码已存在");
				}
			}
			if("1".equals(orgVo.getType())){
				//名称
				List<TmOrgEntity> tmOrgs = tmOrgService.findByCriteria(TmOrgEntity.class, cr1, cr2, cr4);
				if(!CollectionUtils.isEmpty(tmOrgs)){
					validForm.setStatus("n");
					validForm.setInfo("组织名称已存在");
				}
			}
		}else{
			//新增
			if("0".equals(orgVo.getType())){
				//编码
				List<TmOrgEntity> tmOrgByCodes = tmOrgService.findByCriteria(TmOrgEntity.class, cr3, cr4);
				if(!CollectionUtils.isEmpty(tmOrgByCodes)){
					validForm.setStatus("n");
					validForm.setInfo("组织编码已存在");
				}
			}
			if("1".equals(orgVo.getType())){
				List<TmOrgEntity> tmOrgs = tmOrgService.findByCriteria(TmOrgEntity.class, cr1, cr4);
				if(!CollectionUtils.isEmpty(tmOrgs)){
					validForm.setStatus("n");
					validForm.setInfo("组织名称已存在");
				}
			}
		}
		return validForm;
	}

	/**
	 * 双屏选择组织 页面跳转
	 *
	 * @return
	 */
	@RequestMapping(value = "goOptionalOrgMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goOptionalOrgMain(String orgCodes,
										  HttpServletRequest request) {
		ModelAndView view = new ModelAndView("com/biz/eisp/mdm/tmOrg/tmOptionalOrgMain");
		view.addObject("orgCodes", orgCodes);
		return view;
	}


	/**
	 * 获取可选的组织.
	 * @author grover
	 * @param TmOrgApiVo
	 * 		组织vo
	 * @param request
	 * 		请求对象
	 * @return
	 */
	@RequestMapping(value = "findOptionalOrgSelectList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findOptionalOrgSelectList(TmOrgVo TmOrgApiVo, HttpServletRequest request) {
		Page page = new EuPage(request);
		List<TmOrgVo> TmOrgApiVos = new ArrayList<TmOrgVo>();
		try {
			TmOrgApiVos.addAll(tmOrgService.findOptionalOrgSelectList(TmOrgApiVo, page));
		} catch (Exception e) {
			e.printStackTrace();
			throw new BusinessException("获取待选组织信息失败,"+e.getMessage());
		}
		return new DataGrid(TmOrgApiVos, page);
	}
	/**
	 * 获取已选的组织.
	 * @author grover
	 * @param TmOrgApiVo
	 * 		组织vo
	 * @param request
	 * 		请求对象
	 * @return
	 */
	@RequestMapping(value = "findOptionalOrgAlreadyList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findOptionalOrgAlreadyList(TmOrgVo TmOrgApiVo,HttpServletRequest request) {
		Page page = new EuPage(request);
		List<TmOrgVo> TmOrgApiVos = new ArrayList<TmOrgVo>();
		try {
			TmOrgApiVos.addAll(tmOrgService.findOptionalOrgAlreadyList(TmOrgApiVo));
		} catch (Exception e) {
			e.printStackTrace();
			throw new BusinessException("获取待选组织信息失败,"+e.getMessage());
		}
		return new DataGrid(TmOrgApiVos, page);
	}
}
