package com.biz.eisp.mdm.org.dao;

import java.util.List;

import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;
import com.biz.eisp.mdm.org.vo.QueryTmOrgVo;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
/** 组织dao接口.
 * <p>组织相关查询方法的类
 * @author grover
 * @version v1.0
 */
@InterfaceDao
public interface TmOrgDao {
	
	/**
	 * 查询组织.
	 * @author grover
	 * @param tmOrgVo 组织vo
	 * @param page 分页对象
	 * @return 组织列表
	 */
	@Arguments({"tmOrgVo","page"})
	@ResultType(TmOrgVo.class)
	public List <TmOrgVo> findTmOrgList(TmOrgVo tmOrgVo, Page page);
	/**
	 * 企业组织相关接口.
	 * @author grover
	 * @param queryTmOrgVo 查询组织vo
	 * @param page 分页对象
	 * @return 组织信息
	 */
	@Arguments({"queryTmOrgVo","page"})
	@ResultType(TmOrgVo.class)
	public List <TmOrgVo> findTmOrgByAllPossible(QueryTmOrgVo queryTmOrgVo, Page page);

	/**
	 * 获取可选的组织.
	 * @author grover
	 * @param apiVo
	 * 		组织vo
	 * @param page
	 * 		页面对象
	 * @return
	 */
	@Arguments({"apiVo","page"})
	@ResultType(TmOrgVo.class)
	public List<TmOrgVo> findOptionalOrgSelectList(TmOrgVo apiVo, Page page);

	/**
	 * 获取费用类型已经选择的组织.
	 * @author grover
	 * @param apiVo
	 * 		组织vo
	 * @return
	 */
	@Arguments({"apiVo"})
	@ResultType(TmOrgVo.class)
	public List<TmOrgVo> findOptionalOrgAlreadyList(TmOrgVo apiVo);


	@ResultType(ComboTree.class)
	public List <ComboTree> findComboTree();
}
