package com.biz.eisp.mdm.org.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Where;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.log.curd.Loggerable;
import com.biz.eisp.log.curd.ModifyObject;
/**
 * 部门组织机构.
 * <p>关联数据库表：tm_org<br>
 * @author grover
 * @version v1.0
 */
@Entity
@Table(name = "tm_org")
public class TmOrgEntity extends IdEntity implements java.io.Serializable ,Loggerable{
	private static final long serialVersionUID = 1L;
	/**
	 * 部门名称
	 */
	private String orgName;
	/**
	 * 部门描述
	 */
	private String orgDesc;
	/**
	 * 机构编码
	 */
    private String orgCode;
    /**
     * 机构类型
     */
    private String orgType;
    /**
     * 拼音简写
     */
    private String headString;
    /**
     * 树形分段编码
     */
    private String subCode;
    /**
     * 启用状态：0-启用，1-不启用
     */
    private Integer enableStatus;
    /**
     * 创建时间
     */
	private java.util.Date createDate;
	/**
     * 创建人ID
     */
	private java.lang.String createName;
	/**
     * 修改时间
     */
	private java.util.Date updateDate;
	/**
     * 修改人
     */
	private java.lang.String updateName;
	/**
     * 状态 0删除 1正常
     */
	private Integer status;
	/**
     * 字符类型（length=100）-扩展字段1
     */
	private String extChar1;
	/**
	 * 字符类型（length=100）-扩展字段2
     */
	private String extChar2;
	/**
     * 字符类型（length=100）-扩展字段3
     */
	private String extChar3;
	/**
     * 字符类型（length=100）-扩展字段4
     */
	private String extChar4;
	/**
     * 字符类型（length=100）-扩展字段5
     */
	private String extChar5;
	/**
     * 数字类型-扩展字段1
     */
	private Integer extNumber1;
	/**
     * 数字类型-扩展字段2
     */
	private Integer extNumber2;
	/**
     * 数字类型-扩展字段3
     */
	private Integer extNumber3;
	/**
     * 日期类型-扩展字段1
     */
	private Date extDate1;
	/**
     * 日期类型-扩展字段2
     */
	private Date extDate2;
	/**
	 * 是否叶子节点
	 */
	private Integer isLeaf;
	/**
     * 上级部门
     */
	private TmOrgEntity tmOrg;
	
	/**
     * 下属部门
     */
	private List<TmOrgEntity> tmOrgList = new ArrayList<TmOrgEntity>();

	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String 组织名称
	 */
	@Column(name = "org_name", nullable = false, length = 50)
	public String getOrgName() {
		return this.orgName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String 组织名称
	 */
	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String 描述
	 */
	@Column(name = "org_desc", length = 100)
	public String getOrgDesc() {
		return this.orgDesc;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String 描述
	 */
	public void setOrgDesc(String orgDesc) {
		this.orgDesc = orgDesc;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String 组织编码
	 */
    @Column(name = "org_code", length = 30)
    public String getOrgCode() {
        return orgCode;
    }
    /**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String 组织编码
	 */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String 组织类型
	 */
    @Column(name = "org_type", length = 1)
    public String getOrgType() {
        return orgType;
    }
    /**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String 组织类型
	 */
    public void setOrgType(String orgType) {
        this.orgType = orgType;
    }
	/**
	 *方法: 取得java.lang.Integer
	 *@return: java.lang.Integer  状态
	 */
	@Column(name = "status")
	public Integer getStatus() {
		return status;
	}
	/**
	 *方法: 设置java.lang.Integer
	 *@param: java.lang.Integer 状态
	 */
	public void setStatus(Integer status) {
		this.status = status;
	}

	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  创建时间
	 */
	@Column(name ="create_date",nullable=true)
	public java.util.Date getCreateDate(){
		return this.createDate;
	}

	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  创建时间
	 */
	public void setCreateDate(java.util.Date createDate){
		this.createDate = createDate;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  创建人ID
	 */
	@Column(name ="create_name",nullable=true,length=30)
	public java.lang.String getCreateName(){
		return this.createName;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  创建人ID
	 */
	public void setCreateName(java.lang.String createName){
		this.createName = createName;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  修改时间
	 */
	@Column(name ="update_date",nullable=true)
	public java.util.Date getUpdateDate(){
		return this.updateDate;
	}

	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  修改时间
	 */
	public void setUpdateDate(java.util.Date updateDate){
		this.updateDate = updateDate;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  修改人ID
	 */
	@Column(name ="update_name",nullable=true,length=30)
	public java.lang.String getUpdateName(){
		return this.updateName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  修改人ID
	 */
	public void setUpdateName(java.lang.String updateName) {
		this.updateName = updateName;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String 拼音简写
	 */
	@Column(name ="headstring",nullable=true,length=50)
	public String getHeadString() {
		return headString;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String 拼音简写
	 */
	public void setHeadString(String headString) {
		this.headString = headString;
	}
	/**
	 *方法: 取得java.lang.Integer
	 *@return: java.lang.Integer 启用状态
	 */
	@Column(name ="enable_status",nullable=true,length=5)
	public Integer getEnableStatus() {
		return enableStatus;
	}
	/**
	 *方法: 设置java.lang.Integer
	 *@param: java.lang.Integer 启用状态
	 */
	public void setEnableStatus(Integer enableStatus) {
		this.enableStatus = enableStatus;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段1
	 */
	@Column(name = "ext_char_1")
	public String getExtChar1(){
		return extChar1;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String  字符扩展字段2
	 */
	@Column(name = "ext_char_2")
	public String getExtChar2(){
		return extChar2;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段3
	 */
	@Column(name = "ext_char_3")
	public String getExtChar3(){
		return extChar3;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段4
	 */
	@Column(name = "ext_char_4")
	public String getExtChar4(){
		return extChar4;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 字符扩展字段5
	 */
	@Column(name = "ext_char_5")
	public String getExtChar5(){
		return extChar5;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * @return java.lang.Integer 数字扩展字段1
	 */
	@Column(name = "ext_number_1")
	public Integer getExtNumber1(){
		return extNumber1;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * @return java.lang.Integer  数字扩展字段2
	 */
	@Column(name = "ext_number_2")
	public Integer getExtNumber2(){
		return extNumber2;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * @return java.lang.Integer 数字扩展字段3
	 */
	@Column(name = "ext_number_3")
	public Integer getExtNumber3(){
		return extNumber3;
	}
	/**
	 * 方法:取得java.util.Date
	 * @return java.util.Date 日期扩展字段1
	 */
	@Column(name = "ext_date_1")
	public Date getExtDate1() {
		return extDate1;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * @return java.lang.Integer 是否是叶子节点
	 */
	@Column(name = "is_leaf")
	public Integer getIsLeaf() {
		return isLeaf;
	}
	/**
	 * 方法:设置java.lang.Integer
	 * @param java.lang.Integer 是否叶子节点
	 */
	public void setIsLeaf(Integer isLeaf) {
		this.isLeaf = isLeaf;
	}
	/**
	 * 方法:设置java.util.Date
	 * @param java.util.Date 日期扩展字段1
	 */
	public void setExtDate1(Date extDate1) {
		this.extDate1 = extDate1;
	}
	/**
	 * 方法:取得java.util.Date
	 * @return java.util.Date 日期扩展字段2
	 */
	@Column(name = "ext_date_2")
	public Date getExtDate2() {
		return extDate2;
	}
	/**
	 * 方法:设置java.util.Date
	 * @param java.util.Date 日期扩展字段2
	 */
	public void setExtDate2(Date extDate2) {
		this.extDate2 = extDate2;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String  字符扩展字段1
	 */
	public void setExtChar1(String extChar1) {
		this.extChar1 = extChar1;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 字符扩展字段2
	 */
	public void setExtChar2(String extChar2) {
		this.extChar2 = extChar2;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 字符扩展字段3
	 */
	public void setExtChar3(String extChar3) {
		this.extChar3 = extChar3;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 字符扩展字段4
	 */
	public void setExtChar4(String extChar4) {
		this.extChar4 = extChar4;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 字符扩展字段5
	 */
	public void setExtChar5(String extChar5) {
		this.extChar5 = extChar5;
	}
	/**
	 * 方法:设置java.lang.Integer
	 * @param java.lang.Integer 数字扩展字段1
	 */
	public void setExtNumber1(Integer extNumber1) {
		this.extNumber1 = extNumber1;
	}
	/**
	 * 方法:设置java.lang.Integer
	 * @param java.lang.Integer  数字扩展字段2
	 */
	public void setExtNumber2(Integer extNumber2) {
		this.extNumber2 = extNumber2;
	}
	/**
	 * 方法:设置java.lang.Integer
	 * @param java.lang.Integer  数字扩展字段3
	 */
	public void setExtNumber3(Integer extNumber3) {
		this.extNumber3 = extNumber3;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 字符扩展字段4
	 */
	@Column(name = "sub_code")
	public String getSubCode() {
		return subCode;
	}
	/**
	 * 方法:设置java.lang.String
	 * @param java.lang.String 树形字段分段码
	 */
	public void setSubCode(String subCode) {
		this.subCode = subCode;
	}
	/**
	 *方法: 取得com.biz.eisp.mdm.depart.entity.TmDepartEntity
	 *@return: com.biz.eisp.mdm.depart.entity.TmDepartEntity 上级组织
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "parent_id")
	public TmOrgEntity getTmOrg() {
		return this.tmOrg;
	}
	/**
	 *方法: 设置com.biz.eisp.mdm.depart.entity.TmDepartEntity
	 *@param: com.biz.eisp.mdm.depart.entity.TmDepartEntity 上级组织
	 */
	public void setTmOrg(TmOrgEntity tmOrg) {
		this.tmOrg = tmOrg;
	}
	/**
	 *方法: 取得下级组织
	 *@return: com.biz.eisp.mdm.depart.entity.TmDepartEntity 
	 */
	@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER, mappedBy = "tmOrg")
	@Where(clause="enable_status=0")
	@JsonIgnore
	@Fetch(FetchMode.SUBSELECT)
	public List<TmOrgEntity> getTmOrgList() {
		return tmOrgList;
	}
	/**
	 *方法: 设置com.biz.eisp.mdm.depart.entity.TmDepartEntity
	 *@param: com.biz.eisp.mdm.depart.entity.TmDepartEntity 下级组织
	 */
	public void setTmOrgList(List<TmOrgEntity> tmOrgList) {
		this.tmOrgList = tmOrgList;
	}
	@Override
	public String businessDesc() {
		return "组织基本信息";
	}
	@Override
	public String addLogContent() {
		return null;
	}
	@Override
	public String updateLogContent(List<ModifyObject> modifyFieldList) {
		return null;
	}
	
}
