package com.biz.eisp.mdm.org.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.importer.ImpEventHandler;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.importer.validator.ValidatorFactory;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.org.vo.TmOrgVo;

/**  组织导入.
 * @author grover
 * @version v1.0
 */
public class TmOrgEventHandler extends ImpEventHandler <TmOrgVo>{
	/**
	 * service注入.
	 */
	private TmOrgService tmOrgService;

	private TmOrgBackExtendService tmOrgBackExtendService;
	private List<String> saveIdList;

	public TmOrgEventHandler(){
		tmOrgService = (TmOrgService) ApplicationContextUtils.getContext().getBean("tmOrgService");


		String[] beanNamesForBackExtendService = ApplicationContextUtils.getContext().getBeanNamesForType(TmOrgBackExtendService.class);
		if (beanNamesForBackExtendService.length > 0){
			tmOrgBackExtendService = ApplicationContextUtils.getContext().getBean(beanNamesForBackExtendService[0],TmOrgBackExtendService.class);
		}

		saveIdList = Collections.synchronizedList(new ArrayList<>());
	}
	
	@Override
	public void endRow(Map<String, Object> row, TmOrgVo bean) throws ValidateException {
		try {
			//执行保存
			String id = tmOrgService.saveOrUpdateOrg(bean, null);
			saveIdList.add(id);
		} catch (Exception e) {
			addError("第"+getRowNumber()+"行遇到错误:"+e.getMessage());
			e.printStackTrace();
		}
		setSuccNum(getSuccNum()+1);
	}
	
	public void end() {
		//刷新叶子节点
		tmOrgService.updateIsLeafColumn(Globals.TABLE_ORG);
	}
	
	@Override
	public void validate(Map<String, Object> row) throws ValidateException {
		//导入字段
		 List<TmMdmTableConfigEntity> list=DynamicConfigUtil.
				allTableConfigImpColumn.get(tableName.toUpperCase());
		for(TmMdmTableConfigEntity tableConfig:list){
			Object fieldValue=row.get(tableConfig.getField());//字段值
		    //验证主数据配置表单验证
			String errorMsg=ValidatorFactory.validateDynamicImplData(tableConfig, fieldValue);
			if(StringUtil.isNotEmpty(errorMsg)){
				addError("第"+getRowNumber()+"行:"+errorMsg);
			}
			//手动验证组织名称
			if(StringUtil.equals("orgName", tableConfig.getField())){
				String hql="from TmOrgEntity where enableStatus=0 and  orgName=?";
				//验证重复
				List count1 =  tmOrgService.findByHql(hql, fieldValue);
				if(count1 != null&&count1.size()>0){
					addError("第"+getRowNumber()+"行:组织名称["+fieldValue+"]已存在");
				}
			}
			//手动验证组织编码
			if(StringUtil.equals("orgCode", tableConfig.getField())){
				String hql="from TmOrgEntity where enableStatus=0 and  orgCode=?";
				//验证重复
				List count1 =  tmOrgService.findByHql(hql, fieldValue);
				if(count1 != null&&count1.size()>0){
					addError("第"+getRowNumber()+"行:组织名称["+fieldValue+"]已存在");
				}
			}
			//手动验证上级组织
			if(StringUtil.equals("parentId", tableConfig.getField())){
				String superOrgCodeHql="from TmOrgEntity where orgCode=? and enableStatus=?";
				//是否存在
				TmOrgEntity orgEntity = tmOrgService.getUniqueByHql(
						TmOrgEntity.class, superOrgCodeHql,fieldValue,
						Globals.ZERO);
				if(StringUtil.isEmpty(orgEntity)){
					addError("第"+getRowNumber()+"行,:上级组织编码["+fieldValue+"]不存在");
				}else{
					row.put(tableConfig.getField(), orgEntity.getId());
				}
			}
		}
	}

	@Override
	public void impEnd() {
		if (null != tmOrgBackExtendService){
			tmOrgBackExtendService.afterImportOrg(saveIdList);
		}
	}
}
