package com.biz.eisp.mdm.org.service;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.TreeGrid;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.org.vo.QueryTmOrgVo;
import com.biz.eisp.mdm.org.vo.TmOrgVo;

/** 组织服务层接口.
 * <p>组织服务层相关接口定义
 * @author grover
 * @version v1.0
 */
public interface TmOrgService extends BaseService {
	/**
	 * 获取组织grid列表.
	 * <p>获取组织grid列表接口定义.
	 * @author grover
	 * @param request 请求对象
	 * @param treeGrid 树对象
	 * @param TmOrgVo 组织vo
	 * @return 树json模型
	 */
	List<TreeGrid> findOrgMainGrid(HttpServletRequest request, TreeGrid treeGrid, TmOrgVo tmOrgVo);
	/**
	 * 获取组织grid列表.
	 * <p>获取组织grid列表接口定义.
	 * @author grover
	 * @param TmOrgVo 组织vo
	 * @return 组织信息
	 */
	List<TmOrgVo> findOrgMainList(TmOrgVo tmOrgVo);
	/**
	 * 获取组织选择grid列表.
	 * <p>获取组织选择grid列表接口定义.
	 * @author grover
	 * @param TmOrgVo 组织vo
	 * @param page 分页对象
	 * @return 组织集合
	 */
	List<TmOrgVo> findOrgSelectGrid(TmOrgVo tmOrgVo, Page page);
	/**
	 * 销售大区和销售省区列表.
	 * @author Sean
	 * @param orgVo 组织vo对象
	 * @return 下拉列表模型
	 */
	List<ComboBox> getSalesArae(TmOrgVo orgVo);
	
	/**
	 * 上级组织下拉树.
	 * <p>获取下拉组织树的接口方法定义
	 * @author grover
	 * @param orgVo 组织vo对象
	 * @param comboTree 下拉树对象
	 * @return 下拉树模型
	 */
	List<ComboTree> getParentOrg(TmOrgVo orgVo, ComboTree comboTree,HttpServletRequest request);
	
	/**
	 * 保存组织.
	 * <p>保存组织接口的定义
	 * @author grover
	 * @param tmOrgVo 组织vo对象
	 * @param page 页面对象
	 * @return 
	 */
	String saveOrUpdateOrg(TmOrgVo tmOrgVo, Page page);
	/**
	 * 删除组织.
	 * @author grover
	 * @param ids 组织ids
	 * @return 成功或者失败
	 */
	AjaxJson delOrg(String ids);
	/**
	 * 根据职位得到他的组织
	 * @author wan
	 * @param postionId
	 * @return
	 */
	//TODO 删除
	TmOrgVo getTmOrgByPostionId(String postionId);
	/**
	 * 组织导入.
	 * @author grover
	 * @param tmOrgVo 组织对象
	 */
	void importOrg(TmOrgVo tmOrgVo);
	/**
	 * 企业组织相关接口 - 主要对外.
	 * <p>该接口提供了所有可能查询企业组织的方式.<br>
	 * 0、无参数 orgName组织名称，orgCode组织编码 模糊查询
	 * 1、当前企业组织信息 所需参数：id组织id
	 * 2、企业组织的上级信息 所需参数：parentOrgId组织id
	 * 3、企业组织的下级信息 所需参数：levelOrgId组织id
	 * 4、某一类型的企业组织信息 所需参数：orgType组织类型
	 * 5、查看用户查询对应的组织信息 所需参数：userId用户id 或者 userName用户名称
	 * 6、企业组织的的所有上级组织信息 所需参数：parentAllOrgId组织id
	 * 7、企业组织的的所有下级组织信息 所需参数：levelAllOrgId组织id
	 * 8、职位职位对应的组织 所需参数：positionName职位名称 或者 positionId职位id
	 * @author grover
	 * @param queryTmOrgVo 查询方式vo
	 * @param page 分页对象 如果不分页传入一个null
	 * @return 组织vo集合
	 */
	List<TmOrgVo> findTmOrgByAllPossible(QueryTmOrgVo queryTmOrgVo, Page page);
	/**
	 * 查询所有的组织
	 * @author wan
	 * @return
	 */
	List<TmOrgVo> findAllOrg();
	/**
	 * 验证字段是否重复.
	 * <p>
	 * @param id 
	 * @param param
	 * @param fieldName
	 * @return
	 */
	public boolean validate(String id, String param, String fieldName);
	/**
	 * 销售大区和销售省区列表.
	 * @author Sean
	 * @param orgVo 组织vo对象
	 * @return 下拉列表模型
	 */
	public List<ComboBox> getSalesAraeOrgCode(TmOrgVo orgVo);

	/**
	 * 获取可选的组织.
	 * @author grover
	 * @param TmOrgApiVo
	 * 		组织vo
	 * @param page
	 * 		页面对象
	 * @return
	 */
	public List<TmOrgVo> findOptionalOrgSelectList(TmOrgVo TmOrgApiVo, Page page);
	/**
	 * 获取费用类型已经选择的组织.
	 * @author grover
	 * @param TmOrgApiVo
	 * 		组织vo
	 * @return
	 */
	public List<TmOrgVo> findOptionalOrgAlreadyList(TmOrgVo TmOrgApiVo);
}
