package com.biz.eisp.mdm.org.service.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.biz.eisp.api.TmMqSerivce;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.TreeGrid;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.tag.bean.TreeGridModel;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TreeGridUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.org.dao.TmOrgDao;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.org.service.TmOrgExtendService;
import com.biz.eisp.mdm.org.service.TmOrgService;
import com.biz.eisp.mdm.org.transform.TmOrgEntityToTmOrgVo;
import com.biz.eisp.mdm.org.transform.TmOrgVoTransFormPo;
import com.biz.eisp.mdm.org.vo.QueryTmOrgVo;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.system.service.InitListenerService;
import com.google.common.collect.Lists;

/** 组织接口实现.
 * <p>组织相关接口定义的实现
 * @author grover
 * @version v1.0
 */
@Service("tmOrgService")
@Transactional
public class TmOrgServiceImpl extends BaseServiceImpl implements TmOrgService {
	/**
	 * 注入组织dao
	 */
	@Autowired
	private TmOrgDao tmOrgDao;
	/**
	 * 注入组织扩展service
	 */
	@Autowired(required=false)
	private TmOrgExtendService tmOrgExtendService;
	@Autowired
	private InitListenerService initListenerService;

	@Autowired(required=false)
	private TmMqSerivce tmMqSerivce;
	@Override
	public List<TreeGrid> findOrgMainGrid(HttpServletRequest request,
			TreeGrid treeGrid, TmOrgVo tmOrgVo) {
		//树容器集合初始化
		List<TreeGrid> treeGrids = new ArrayList<TreeGrid>();
		
		//查询条件定义
		Criterion cr1 = null; 
		Criterion cr2 = Restrictions.eq("enableStatus", Globals.ZERO);
		//定义查询结果集
		List<TmOrgEntity> orgList = new ArrayList<TmOrgEntity>();
		//没有nodeId时 模糊搜索
		//是否搜索
		if(StringUtil.isNotEmpty(tmOrgVo.getOrgName())||StringUtil.isNotEmpty(tmOrgVo.getOrgCode())){
			String hql = "select t from TmOrgEntity t where 1 = 1 and t.enableStatus = ? ";
			if(StringUtil.isNotEmpty(tmOrgVo.getOrgName())){
				hql+=" and t.orgName like "+"'%"+tmOrgVo.getOrgName()+"%'";
			}
			if(StringUtil.isNotEmpty(tmOrgVo.getOrgCode())){
				hql+=" and t.orgCode like "+"'%"+tmOrgVo.getOrgCode()+"%'";
			}
			List<TmOrgEntity> temp = this.findByHql(hql, Globals.ZERO);
			for(TmOrgEntity tt:temp){
				orgList.add(tt);
				addParentsEntity(tt,orgList);
			}
		}else{
			if(StringUtil.isNotEmpty(treeGrid.getId())){
				cr1 = Restrictions.eq("tmOrg.id", treeGrid.getId());
			}
			if (StringUtil.isEmpty(treeGrid.getId())) {
	        	cr1 = Restrictions.isNull("tmOrg");
	        } 
			orgList = findByCriteria(TmOrgEntity.class,cr1,cr2);
		}
		List<TmOrgVo> orgVoList = new ArrayList<TmOrgVo>();
		TmOrgEntityToTmOrgVo orgTransForm = new TmOrgEntityToTmOrgVo(this);
		for(TmOrgEntity tto:orgList){
			orgVoList.add(orgTransForm.apply(tto));
		}
        //拼接模型
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setTextField("orgName");
        treeGridModel.setParentText("tmOrg_orgName");
        treeGridModel.setParentId("tmOrg_id");
        treeGridModel.setSrc("orgDesc");
        treeGridModel.setIdField("id");
        treeGridModel.setChildList("tmOrgList");
        treeGridModel.setCode("orgCode");
        //其他参数
        Map<String, Object> fieldMap = new HashMap<String, Object>();
        this.addField(fieldMap, TmOrgVo.class);
        treeGridModel.setFieldMap(fieldMap);
        treeGrids = this.treegrid(orgVoList, treeGridModel);
		return treeGrids;
	}
	
	private void addField( Map<String, Object> fieldMap,Class clazz){
		Field[] fields =clazz.getDeclaredFields();
		for(Field field:fields){
			String fieldName=field.getName();
			if(!StringUtil.equals("tmOrgList", fieldName)){
				 fieldMap.put(fieldName, fieldName);
			}
		}
	}
	
	/**
	 *  递归添加树每个层级的父节点，剔除一个树种形同的节点
	 * @author wuzhujun
	 * @param tt
	 * @param orgList 模糊查询出来匹配节点集合
	 */
	private void addParentsEntity(TmOrgEntity tt, List<TmOrgEntity> orgList) {
		String sql = "select parent_id from tm_org where id=?";
		Map<String, Object> map = findForMap(sql, tt.getId());
		//获取节点parentId
		if(StringUtil.isNotEmpty(map.get("parent_id"))){
			String parent_id = (String) map.get("parent_id");
			TmOrgEntity tempEntity = super.get(TmOrgEntity.class, parent_id);
				if(tempEntity!=null){
	    		//加入之前检查是否有重复的元素，没有则加入
	    		if(!orgList.contains(tempEntity)){
	    			orgList.add(tempEntity);
	    		}
	    		addParentsEntity(tempEntity,orgList);
	    	}
		}
	}

	@Override
	public List<TmOrgVo> findOrgSelectGrid(TmOrgVo tmOrgVo, Page page) {
		return tmOrgDao.findTmOrgList(tmOrgVo, page);
	}
	
	@Override
	public List<ComboTree> getParentOrg(TmOrgVo orgVo, ComboTree comboTree,HttpServletRequest request) {
		List<TmOrgEntity> tmOrgList = new ArrayList<TmOrgEntity>();
		Criterion cr1 = null;
		String selfId = request.getParameter("selfId");
		
		if(StringUtil.isNotEmpty(selfId)){
			tmOrgList = findByProperty(TmOrgEntity.class,"id",selfId);
		}else if(StringUtil.isNotEmpty(orgVo.getOrgId())){
			cr1 = Restrictions.ne("id", orgVo.getOrgId());
		}
		Criterion cr4 = Restrictions.eq("enableStatus", Globals.ZERO);
		if(StringUtil.isNotEmpty(comboTree.getId())) {
			Criterion cr2 = Restrictions.eq("tmOrg.id", comboTree.getId());
			if(StringUtil.isNotEmpty(cr1)){
				tmOrgList.addAll(findByCriteria(TmOrgEntity.class, cr1, cr2, cr4));
			}else{
				tmOrgList.addAll(findByCriteria(TmOrgEntity.class, cr2, cr4));
			}
		} else {
			Criterion cr3 = null;
			if(StringUtil.isNotEmpty(orgVo.getPid())){
				cr3 = Restrictions.eq("id", orgVo.getPid());
			}else if(StringUtil.isEmpty(selfId)){
				cr3 = Restrictions.isNull("tmOrg.id");
			}
			if(StringUtil.isNotEmpty(cr1)){
				tmOrgList.addAll(findByCriteria(TmOrgEntity.class, cr1, cr3, cr4));
			}else if(StringUtil.isEmpty(selfId)){
				tmOrgList.addAll(findByCriteria(TmOrgEntity.class, cr3, cr4));
			}
		}
		ComboTreeModel comboTreeModel = new ComboTreeModel("id", "orgName", "tmOrgList");
		List<ComboTree> comboTrees = this.comboTree(tmOrgList, comboTreeModel, null, false);
		return comboTrees;
	}

	@Override
    public String saveOrUpdateOrg(TmOrgVo tmOrgVo, Page page) {
		TmOrgEntity tmOrgEntity = null;
		//保存前扩展 此时entity还未通过vo转换
		if(StringUtil.isNotEmpty(tmOrgExtendService)){
			//数据验证
			try {
				tmOrgExtendService.validate(tmOrgVo, page);
			} catch (Exception e) {
				throw new BusinessException("验证数据失败:"+e.getMessage());
			}
			//保存前扩展
			tmOrgEntity = tmOrgExtendService.saveBefore(tmOrgVo, page);
		}
		//如果entity为null则直接转换
		if(StringUtil.isEmpty(tmOrgEntity)){
			//转化对象实例
			TmOrgVoTransFormPo formPo = new  TmOrgVoTransFormPo();
			tmOrgEntity = formPo.apply(tmOrgVo);
		}
		//保持前扩展 此时entity已经通过vo转换
		if(StringUtil.isNotEmpty(tmOrgExtendService)){
			tmOrgEntity = tmOrgExtendService.saveBefore(tmOrgEntity, tmOrgVo, page);
		}
		
		//1.保存或者更新
		saveOrUpdate(tmOrgEntity);
		if (StringUtil.isNotEmpty(tmMqSerivce)){
			tmMqSerivce.orgCallBack(tmOrgEntity.getId(),tmOrgEntity.getTmOrg().getId(),tmOrgEntity.getOrgName(),2);
		}else{
			initListenerService.refleshDepart(tmOrgEntity.getId(),tmOrgEntity.getTmOrg().getId(),tmOrgEntity.getOrgName(),2);
		}
		//保存后扩展
		if(StringUtil.isNotEmpty(tmOrgExtendService)){
			tmOrgEntity = tmOrgExtendService.savePost(tmOrgEntity, tmOrgVo, page);
		}
		//2.保存之后，如果调整了上级组织则清空该组织下的所有职位与上级职位之间的关系
		if(StringUtil.isNotEmpty(tmOrgVo.getId())){
			//修改的组织ID
			String id = tmOrgEntity.getId();
			//获取修改之前ParentID
			TmOrgEntity oldOrgEntity  = this.get(TmOrgEntity.class, id);
			String oldParnetId = oldOrgEntity.getTmOrg().getId();
			if(!oldParnetId.equals(tmOrgVo.getPid())){
				String sql = "update tm_position set parent_id = null where org_id = ? ";
				this.executeSql(sql, id);
			}
		}

		if (null != tmOrgEntity){
			return tmOrgEntity.getId();
		}
		return null;
	}

	@Override
	public AjaxJson delOrg(String ids) {
		AjaxJson j = new AjaxJson();
		j.setSuccess(true);
		j.setMsg("删除成功");
		String[] orgIds = ids.split(",");
		for (String id : orgIds) {
			TmOrgEntity orgEntity = get(TmOrgEntity.class, id);
			//1.判断删除组织是否有下级组织
			if(CollectionUtils.isEmpty(orgEntity.getTmOrgList())){
				List<TmPositionEntity> positions = findByProperty(TmPositionEntity.class, "tmOrg.id", id);
				//2.判断该组织是否有关联的职位
				if(!CollectionUtils.isEmpty(positions)){
					j.setMsg("删除的当前组织【"+orgEntity.getOrgName()+"】有关联的职位不能删除！");
					j.setSuccess(false);
					return j;
				}
				//3.软删除
				orgEntity.setEnableStatus(Globals.ONE);
				updateEntity(orgEntity);
				initListenerService.refleshDepart(orgEntity.getId(),orgEntity.getTmOrg().getId(),orgEntity.getOrgName(),3);
			}else{
				j.setMsg("删除的当前组织【"+orgEntity.getOrgName()+"】下级组织不能删除！");
				j.setSuccess(false);
				return j;
			}
		}
		return j;
	}
	
	@Override
	public TmOrgVo getTmOrgByPostionId(String postionId) {
		String sql = "select t1.* from tm_org t1 where t1.id = (select t2.org_id from tm_position t2 where t2.id = ?)";
		TmOrgEntity org = getUniqueBySql(TmOrgEntity.class, sql, postionId);
		TmOrgVo result = new TmOrgEntityToTmOrgVo(this).apply(org);
		return result;
	}

	@Override
	public void importOrg(TmOrgVo tmOrgVo) {
		//转化对象实例
		TmOrgVoTransFormPo formPo = new  TmOrgVoTransFormPo();
		TmOrgEntity tmOrgEntity = formPo.apply(tmOrgVo);
		saveOrUpdate(tmOrgEntity);
	}

	@Override
	public List<TmOrgVo> findTmOrgByAllPossible(QueryTmOrgVo queryTmOrgVo,
			Page page) {
		return tmOrgDao.findTmOrgByAllPossible(queryTmOrgVo, page);
	}

	@Override
	public List<TmOrgVo> findAllOrg() {
		List<TmOrgEntity> orgs = super.findByCriteria(TmOrgEntity.class);
		return Lists.transform(orgs, new TmOrgEntityToTmOrgVo(this));
	}

	@Override
	public List<TmOrgVo> findOrgMainList(TmOrgVo tmOrgVo) {
		//动态sql
		String sql = DynamicConfigUtil.getInstance().buildTreeGridQuerySql(Globals.TABLE_ORG, tmOrgVo);
		List<TmOrgVo> tmOrgList = findBySql(TmOrgVo.class, sql);
		//判断是否有查询条件 有则组装树形
		if(DynamicConfigUtil.getInstance().isHaveQuery(Globals.TABLE_ORG, tmOrgVo)){
			tmOrgList = findQueryCustomerOrgList(tmOrgVo, tmOrgList);
		}
		return tmOrgList;
	}
	/**
	 * 构造树形.
	 * @author grover
	 * @param tmOrgVo 组织vo
	 * @param voList 组织list
	 * @return
	 */
	@SuppressWarnings("unchecked")
	private List<TmOrgVo> findQueryCustomerOrgList(TmOrgVo tmOrgVo, List <TmOrgVo> voList) {
		//如果是导出，既不用组装成TreeGrid,带有children的树形，直接返回列表值
		if(tmOrgVo.getExportExcel().equals("true")) {
			return voList;
		}
		
		//构造成一个树传回
		List<TmOrgVo> allQueryVolist = TreeGridUtil.buildTreeGrid(voList);
		return allQueryVolist; 
	}
	/**
	 * 判断是否有查询条件.
	 * @author grover
	 * @param tmOrgVo 组织vo
	 * @return true 有 false 没有
	 */
	private boolean hasQueryValue(TmOrgVo tmOrgVo){
		if(StringUtil.isEmpty(tmOrgVo.getOrgCode())&&
				StringUtil.isEmpty(tmOrgVo.getOrgName())&&
				StringUtil.isEmpty(tmOrgVo.getOrgDesc())&&
				StringUtil.isEmpty(tmOrgVo.getOrgType())&&
				StringUtil.isEmpty(tmOrgVo.getHeadString())&&
				StringUtil.isEmpty(tmOrgVo.getExtChar1())&&
				StringUtil.isEmpty(tmOrgVo.getExtChar2())&&
				StringUtil.isEmpty(tmOrgVo.getExtChar3())&&
				StringUtil.isEmpty(tmOrgVo.getExtChar4())&&
				StringUtil.isEmpty(tmOrgVo.getExtChar5())&&
				tmOrgVo.getExtDate1()==null&&
				tmOrgVo.getExtDate2()==null&&
				tmOrgVo.getExtNumber1()==null&&
				tmOrgVo.getExtNumber2()==null&&
				tmOrgVo.getExtNumber3()==null&&
				tmOrgVo.getEnableStatus()==null){
			return false;
		}
		return true;
	}

	@Override
	public List<ComboBox> getSalesArae(TmOrgVo orgVo){
		String sql="select id value,org_name text from tm_org where 1=1";
		if(StringUtil.isNotEmpty(orgVo.getOrgType())){
			sql+=" and org_type="+orgVo.getOrgType();
		}
		if(StringUtil.isNotEmpty(orgVo.getPid())){
			sql+=" and parent_id ='"+orgVo.getPid()+"'";
		}
		return this.findBySql(ComboBox.class, sql);
	}

	@Override
	public boolean validate(String id, String param, String fieldName) {
		Criterion cr1 = Restrictions.eq(fieldName, param);
		Criterion cr3 = Restrictions.eq("enableStatus",Globals.ZERO);
		List<TmOrgEntity> tmtbas = new ArrayList<TmOrgEntity>();
		if(StringUtil.isNotEmpty(id)){
			Criterion cr2 = Restrictions.ne("id", id);
			tmtbas = findByCriteria(TmOrgEntity.class, cr1, cr2,cr3);
		}else{
			tmtbas = findByCriteria(TmOrgEntity.class, cr1,cr3);
		}
		if(!CollectionUtils.isEmpty(tmtbas)){
			return true;
		}
		return false;
	}

	@Override
	public List<ComboBox> getSalesAraeOrgCode(TmOrgVo orgVo) {
		String sql="select org_code value,org_name text from tm_org where 1=1";
		if(StringUtil.isNotEmpty(orgVo.getOrgType())){
			sql+=" and org_type="+orgVo.getOrgType();
		}
		if(StringUtil.isNotEmpty(orgVo.getPid())){
			sql+=" and parent_id ='"+orgVo.getPid()+"'";
		}
		return this.findBySql(ComboBox.class, sql);
	}

	@Override
	public List<TmOrgVo> findOptionalOrgSelectList(TmOrgVo tmOrgVo, Page page) {
		return tmOrgDao.findOptionalOrgSelectList(tmOrgVo, page);
	}

	@Override
	public List<TmOrgVo> findOptionalOrgAlreadyList(
			TmOrgVo tmOrgVo) {
		if(StringUtil.isNotEmpty(tmOrgVo.getOrgCodes())){
			String codes = "";
			for (String orgCode : tmOrgVo.getOrgCodes().split(",")) {
				if(StringUtil.isNotEmpty(codes)){
					codes += ",";
				}
				codes += "'"+orgCode+"'";
			}
			tmOrgVo.setOrgCodes(codes);
		}else{
			tmOrgVo.setOrgCodes("'-1'");
		}
		return tmOrgDao.findOptionalOrgAlreadyList(tmOrgVo);
	}
}
